/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.generic.nested;

import java.util.List;
import org.matheclipse.core.generic.util.INestedListElement;
import org.matheclipse.generic.interfaces.IIndexFunction;
import org.matheclipse.generic.nested.INestedList;

public class IndexTableGenerator<T extends INestedListElement, L extends List<T> & INestedListElement> {
    final int[] fIndexArray;
    final L fPrototypeList;
    final IIndexFunction<? extends T> fFunction;
    int fIndex;
    int[] fCurrentIndex;
    private final INestedList<T, L> fCopier;

    public IndexTableGenerator(int[] indexArray, L prototypeList, IIndexFunction<? extends T> function, INestedList<T, L> copier) {
        this.fIndexArray = indexArray;
        this.fPrototypeList = prototypeList;
        this.fFunction = function;
        this.fIndex = 0;
        this.fCurrentIndex = new int[indexArray.length];
        this.fCopier = copier;
    }

    public T table() {
        if (this.fIndex < this.fIndexArray.length) {
            int iter = this.fIndexArray[this.fIndex];
            int index = this.fIndex++;
            try {
                L result = this.fCopier.clone(this.fPrototypeList);
                int i = 0;
                while (i < iter) {
                    this.fCurrentIndex[index] = i++;
                    result.add(this.table());
                }
                T t = this.fCopier.castList(result);
                return t;
            }
            finally {
                --this.fIndex;
            }
        }
        return (T)((INestedListElement)this.fFunction.evaluate(this.fCurrentIndex));
    }
}

