/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.generic.nested;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.matheclipse.core.generic.util.INestedListElement;
import org.matheclipse.generic.ListSizeSequence;
import org.matheclipse.generic.interfaces.IPositionConverter;
import org.matheclipse.generic.nested.INestedList;
import org.matheclipse.generic.nested.LevelSpec;

public abstract class NestedAlgorithms<T extends INestedListElement, L extends List<T> & INestedListElement>
implements INestedList<T, L> {
    @Override
    public final L cast(T obj) {
        return (L)((List)obj);
    }

    @Override
    public final T castList(L list) {
        return (T)((INestedListElement)list);
    }

    public T apply(T expr, Function<T, T> function, LevelSpec level) {
        return this.apply(expr, function, level, 0);
    }

    public T apply(T expr, Function<T, T> function, LevelSpec level, int headOffset) {
        List<Object> result = null;
        int minDepth = 0;
        level.incCurrentLevel();
        if (this.isInstance(expr)) {
            L list = this.cast(expr);
            int i = headOffset;
            while (i < list.size()) {
                INestedListElement temp = this.apply((INestedListElement)list.get(i), function, level, headOffset);
                if (temp != null) {
                    if (result == null) {
                        result = this.clone(list);
                    }
                    result.set(i, temp);
                }
                if (level.getCurrentDepth() < minDepth) {
                    minDepth = level.getCurrentDepth();
                }
                ++i;
            }
            level.setCurrentDepth(--minDepth);
            level.decCurrentLevel();
            if (level.isInRange()) {
                if (result == null) {
                    result = (List<Object>)this.clone(list);
                }
                result.set(0, (INestedListElement)function.apply((Object)((INestedListElement)result.get(0))));
            }
        } else {
            level.setCurrentDepth(--minDepth);
            level.decCurrentLevel();
        }
        return this.castList(result);
    }

    public int countIf(L argList, Predicate<? super T> matcher) {
        return this.countIf(argList, matcher, 0);
    }

    public int countIf(L argList, Predicate<? super T> matcher, int headOffset) {
        int counter = 0;
        int i = headOffset;
        while (i < argList.size()) {
            if (this.isInstance((INestedListElement)argList.get(i))) {
                L list = this.cast((INestedListElement)argList.get(i));
                counter += this.countIf(list, matcher, headOffset);
            } else if (matcher.apply(argList.get(i))) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public int depth(L list) {
        return this.depth(list, 0);
    }

    public int depth(L list, int headOffset) {
        int maxDepth = 1;
        int i = headOffset;
        while (i < list.size()) {
            int d;
            if (this.isInstance((INestedListElement)list.get(i)) && (d = this.depth(this.cast((INestedListElement)list.get(i)), headOffset)) > maxDepth) {
                maxDepth = d;
            }
            ++i;
        }
        return ++maxDepth;
    }

    public T extract(L list, List<? extends T> positions, IPositionConverter<? super T> positionConverter) {
        return this.extract(list, positions, positionConverter, 0);
    }

    public T extract(L list, List<? extends T> positions, IPositionConverter<? super T> positionConverter, int headOffset) {
        int p = 0;
        L temp = list;
        int posSize = positions.size() - 1;
        Object expr = this.castList(list);
        int i = headOffset;
        while (i <= posSize) {
            p = positionConverter.toInt(positions.get(i));
            if (temp == null || temp.size() <= p) {
                return null;
            }
            expr = (INestedListElement)temp.get(p);
            if (this.isInstance(expr)) {
                temp = this.cast(expr);
            } else if (i < positions.size()) {
                temp = null;
            }
            ++i;
        }
        return expr;
    }

    public Collection<? super T> extract(T nestedListElement, Predicate<? super T> matcher, Collection<? super T> resultCollection) {
        return this.extract(nestedListElement, matcher, resultCollection, 0);
    }

    public Collection<? super T> extract(T nestedListElement, Predicate<? super T> matcher, Collection<? super T> resultCollection, int headOffset) {
        if (matcher.apply(nestedListElement)) {
            resultCollection.add(nestedListElement);
        }
        if (this.isInstance(nestedListElement)) {
            L list = this.cast(nestedListElement);
            int i = headOffset;
            while (i < list.size()) {
                this.extract((INestedListElement)list.get(i), matcher, resultCollection, headOffset);
                ++i;
            }
        }
        return resultCollection;
    }

    public boolean flatten(L argList, Collection<? super T> resultList) {
        return this.flatten(argList, resultList, 0);
    }

    public boolean flatten(L argList, Collection<? super T> resultList, int headOffset) {
        boolean isEvaled = false;
        int i = headOffset;
        while (i < argList.size()) {
            if (this.isInstance((INestedListElement)argList.get(i))) {
                isEvaled = true;
                this.flatten(this.cast((INestedListElement)argList.get(i)), resultList, headOffset);
            } else {
                resultList.add(argList.get(i));
            }
            ++i;
        }
        return isEvaled;
    }

    public boolean flatten(T head, L argList, Collection<? super T> resultList) {
        return this.flatten(head, argList, resultList, 0);
    }

    public boolean flatten(T head, L argList, Collection<? super T> resultList, int headOffset) {
        boolean isEvaled = false;
        int i = headOffset;
        while (i < argList.size()) {
            if (this.isInstance((INestedListElement)argList.get(i))) {
                L list = this.cast((INestedListElement)argList.get(i));
                if (((INestedListElement)list.get(0)).equals(head)) {
                    isEvaled = true;
                    this.flatten(head, list, resultList, headOffset);
                } else {
                    resultList.add(argList.get(i));
                }
            } else {
                resultList.add(argList.get(i));
            }
            ++i;
        }
        return isEvaled;
    }

    public Collection<? super T> level(T expr, LevelSpec level, Collection<? super T> resultCollection) {
        return this.level(expr, level, resultCollection, 0);
    }

    public Collection<? super T> level(T expr, LevelSpec level, Collection<? super T> resultCollection, int headOffset) {
        int minDepth = 0;
        level.incCurrentLevel();
        if (this.isInstance(expr)) {
            L list = this.cast(expr);
            int i = headOffset;
            while (i < list.size()) {
                this.level((INestedListElement)list.get(i), level, resultCollection, headOffset);
                if (level.getCurrentDepth() < minDepth) {
                    minDepth = level.getCurrentDepth();
                }
                ++i;
            }
            level.setCurrentDepth(--minDepth);
            level.decCurrentLevel();
            if (level.isInRange()) {
                resultCollection.add(expr);
            }
        } else {
            level.setCurrentDepth(--minDepth);
            level.decCurrentLevel();
            if (level.isInRange()) {
                resultCollection.add(expr);
            }
        }
        return resultCollection;
    }

    public void total(T expr, LevelSpec level, Function<T, T> function, int headOffset) {
        int minDepth = 0;
        level.incCurrentLevel();
        if (this.isInstance(expr)) {
            L list = this.cast(expr);
            int i = headOffset;
            while (i < list.size()) {
                this.total((INestedListElement)list.get(i), level, function, headOffset);
                if (level.getCurrentDepth() < minDepth) {
                    minDepth = level.getCurrentDepth();
                }
                ++i;
            }
            level.setCurrentDepth(--minDepth);
            level.decCurrentLevel();
        } else {
            level.setCurrentDepth(--minDepth);
            level.decCurrentLevel();
            if (level.isInRange()) {
                function.apply(expr);
            }
        }
    }

    public T map(T expr, Function<T, ? extends T> function, LevelSpec level) {
        return this.map(expr, function, level, 0);
    }

    public T map(T expr, Function<T, ? extends T> function, LevelSpec level, int headOffset) {
        List result = null;
        int minDepth = 0;
        level.incCurrentLevel();
        if (this.isInstance(expr)) {
            L list = this.cast(expr);
            int i = headOffset;
            while (i < list.size()) {
                T temp = this.map((INestedListElement)list.get(i), function, level, headOffset);
                if (temp != null) {
                    if (result == null) {
                        result = (List)this.clone(list);
                    }
                    result.set(i, temp);
                }
                if (level.getCurrentDepth() < minDepth) {
                    minDepth = level.getCurrentDepth();
                }
                ++i;
            }
        }
        level.setCurrentDepth(--minDepth);
        level.decCurrentLevel();
        if (level.isInRange()) {
            if (result == null) {
                return (T)((INestedListElement)function.apply(expr));
            }
            return (T)((INestedListElement)function.apply(this.castList(result)));
        }
        return this.castList(result);
    }

    public Collection<? super T> position(L list, L prototypeList, Collection<? super T> resultCollection, LevelSpec level, Predicate<? super T> matcher, IPositionConverter<? extends T> positionConverter) {
        return this.position(list, prototypeList, resultCollection, level, matcher, positionConverter, 0);
    }

    public Collection<? super T> position(L list, L prototypeList, Collection<? super T> resultCollection, LevelSpec level, Predicate<? super T> matcher, IPositionConverter<? extends T> positionConverter, int headOffset) {
        int minDepth = 0;
        level.incCurrentLevel();
        List clone = null;
        int i = headOffset;
        while (i < list.size()) {
            if (matcher.apply(list.get(i))) {
                if (level.isInRange()) {
                    clone = (List)this.clone(prototypeList);
                    INestedListElement t = (INestedListElement)positionConverter.toObject(i);
                    clone.add(t);
                    resultCollection.add(this.castList(clone));
                }
            } else if (this.isInstance((INestedListElement)list.get(i))) {
                clone = (List)this.clone(prototypeList);
                clone.add((INestedListElement)positionConverter.toObject(i));
                this.position(this.cast((INestedListElement)list.get(i)), clone, resultCollection, level, matcher, positionConverter, headOffset);
                if (level.getCurrentDepth() < minDepth) {
                    minDepth = level.getCurrentDepth();
                }
            }
            ++i;
        }
        level.setCurrentDepth(--minDepth);
        level.decCurrentLevel();
        return resultCollection;
    }

    public T replace(T expr, T from, T to) {
        return this.replace(expr, from, to, 0);
    }

    public T replace(T expr, T from, T to, int headOffset) {
        if (expr.equals(from)) {
            return to;
        }
        if (this.isInstance(expr)) {
            L nestedList = this.cast(expr);
            List result = null;
            int i = headOffset;
            while (i < nestedList.size()) {
                INestedListElement temp = this.replace((INestedListElement)nestedList.get(i), from, to, headOffset);
                if (temp != null) {
                    if (result == null) {
                        result = (List)this.clone(nestedList);
                    }
                    result.set(i, temp);
                }
                ++i;
            }
            return this.castList(result);
        }
        return null;
    }

    public T replaceAll(T expr, Predicate<T> from, Function<T, ? extends T> to) {
        if (from.apply(expr)) {
            return (T)((INestedListElement)to.apply(expr));
        }
        if (this.isInstance(expr)) {
            L nestedList = this.cast(expr);
            List<Object> result = null;
            INestedListElement head = (INestedListElement)nestedList.get(0);
            INestedListElement temp = this.replaceAll((T)head, (L)from, (L)to);
            if (temp == null) {
                return null;
            }
            result = (List<Object>)this.clone(nestedList);
            result.set(0, temp);
            int i = 1;
            while (i < nestedList.size()) {
                temp = this.replaceAll((T)((INestedListElement)nestedList.get(i)), (L)from, (L)to);
                if (temp != null) {
                    if (result == null) {
                        result = this.clone(nestedList);
                    }
                } else {
                    return null;
                }
                result.set(i, temp);
                ++i;
            }
            return this.castList(result);
        }
        return expr;
    }

    public T replaceAll(T expr, L from, L to) {
        return this.replaceAll(expr, from, to, 0);
    }

    public T replaceAll(T expr, L from, L to, int headOffset) {
        int i = headOffset;
        while (i < from.size()) {
            if (expr.equals(from.get(i))) {
                return (T)((INestedListElement)to.get(i));
            }
            ++i;
        }
        if (this.isInstance(expr)) {
            L nestedList = this.cast(expr);
            List<Object> result = null;
            INestedListElement head = (INestedListElement)nestedList.get(0);
            INestedListElement temp = this.replaceAll(head, from, to, headOffset);
            if (temp != null) {
                result = (List<Object>)this.clone(nestedList);
                result.set(0, temp);
            }
            int i2 = 1;
            while (i2 < nestedList.size()) {
                temp = this.replaceAll((INestedListElement)nestedList.get(i2), from, to, headOffset);
                if (temp != null) {
                    if (result == null) {
                        result = this.clone(nestedList);
                    }
                    result.set(i2, temp);
                }
                ++i2;
            }
            return this.castList(result);
        }
        return null;
    }

    public <K> T replaceAll(T expr, Map<K, T> ruleMap) {
        return this.replaceAll(expr, ruleMap, 0);
    }

    public <K> T replaceAll(T expr, Map<K, T> ruleMap, int headOffset) {
        INestedListElement value = (INestedListElement)ruleMap.get(expr);
        if (value != null) {
            return (T)value;
        }
        if (this.isInstance(expr)) {
            L nestedList = this.cast(expr);
            List<Object> result = null;
            INestedListElement head = (INestedListElement)nestedList.get(0);
            INestedListElement temp = this.replaceAll((T)head, ruleMap, headOffset);
            if (temp != null) {
                result = (List<Object>)this.clone(nestedList);
                result.set(0, temp);
            }
            int i = 1;
            while (i < nestedList.size()) {
                temp = this.replaceAll((T)((INestedListElement)nestedList.get(i)), ruleMap, headOffset);
                if (temp != null) {
                    if (result == null) {
                        result = this.clone(nestedList);
                    }
                    result.set(i, temp);
                }
                ++i;
            }
            return this.castList(result);
        }
        return null;
    }

    public <K> T replaceAll(T expr, Function<T, T> function) {
        return this.replaceAll(expr, function, 0);
    }

    public <K> T replaceAll(T expr, Function<T, T> function, int headOffset) {
        INestedListElement value = (INestedListElement)function.apply(expr);
        if (value != null) {
            return (T)value;
        }
        if (this.isInstance(expr)) {
            L nestedList = this.cast(expr);
            List<Object> result = null;
            INestedListElement head = (INestedListElement)nestedList.get(0);
            INestedListElement temp = this.replaceAll((T)head, function, headOffset);
            if (temp != null) {
                result = (List<Object>)this.clone(nestedList);
                result.set(0, temp);
            }
            int i = 1;
            while (i < nestedList.size()) {
                temp = this.replaceAll((T)((INestedListElement)nestedList.get(i)), function, headOffset);
                if (temp != null) {
                    if (result == null) {
                        result = this.clone(nestedList);
                    }
                    result.set(i, temp);
                }
                ++i;
            }
            return this.castList(result);
        }
        return null;
    }

    public boolean some(L nestedList, Predicate<? super T> matcher) {
        return this.some((T)nestedList, (Predicate<T>)matcher, 0);
    }

    public boolean some(L nestedList, Predicate<? super T> matcher, int headOffset) {
        int i = headOffset;
        while (i < nestedList.size()) {
            L list;
            if (this.isInstance((INestedListElement)nestedList.get(i)) ? this.some((T)(list = this.cast((INestedListElement)nestedList.get(i))), (Predicate<T>)matcher, headOffset) : matcher.apply(nestedList.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean some(T expr, Predicate<T> matcher) {
        return this.some(expr, matcher, 0);
    }

    public boolean some(T expr, Predicate<T> matcher, int headOffset) {
        if (matcher.apply(expr)) {
            return true;
        }
        if (this.isInstance(expr)) {
            L list = this.cast(expr);
            int i = headOffset;
            while (i < list.size()) {
                if (matcher.apply((Object)((INestedListElement)list.get(i)))) {
                    return true;
                }
                if (this.some((T)((INestedListElement)list.get(i)), matcher, headOffset)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return matcher.apply(expr);
    }

    public T substitute(T expr, L from, L to) {
        return this.substitute(expr, (T)from, (T)to, 0);
    }

    public T substitute(T expr, L from, L to, int headOffset) {
        T result = this.replaceAll(expr, from, to, headOffset);
        return result == null ? expr : result;
    }

    public T substitute(T expr, T from, T to) {
        return this.substitute(expr, from, to, 0);
    }

    public T substitute(T expr, T from, T to, int headOffset) {
        T result = this.replace(expr, from, to, headOffset);
        return result == null ? expr : result;
    }

    public L take(L list, int level, ListSizeSequence[] sequ) {
        sequ[level].setListSize(list.size());
        L resultList = this.newInstance(list);
        int newLevel = level + 1;
        int i = sequ[level].getStart();
        while (i < sequ[level].getEnd()) {
            if (sequ.length > newLevel) {
                if (this.isInstance((INestedListElement)list.get(i))) {
                    resultList.add(this.castList(this.take(this.cast((INestedListElement)list.get(i)), newLevel, sequ)));
                }
            } else {
                resultList.add((INestedListElement)((INestedListElement)list.get(i)));
            }
            i += sequ[level].getStep();
        }
        return resultList;
    }
}

