/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client.ast;

import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.SymbolNode;

public class PatternNode
extends ASTNode {
    protected final SymbolNode fSymbol;
    protected final boolean fDefault;
    protected final ASTNode fConstraint;

    public PatternNode(SymbolNode symbol, ASTNode constraint) {
        this(symbol, constraint, false);
    }

    public PatternNode(SymbolNode symbol, ASTNode constraint, boolean optional) {
        super(null);
        this.fSymbol = symbol;
        this.fConstraint = constraint;
        this.fDefault = optional;
    }

    public ASTNode getConstraint() {
        return this.fConstraint;
    }

    public SymbolNode getSymbol() {
        return this.fSymbol;
    }

    public boolean isDefault() {
        return this.fDefault;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.fSymbol != null) {
            buff.append(this.fSymbol.toString());
        }
        buff.append('_');
        if (this.fDefault) {
            buff.append('.');
        }
        if (this.fConstraint != null) {
            buff.append(this.fConstraint.toString());
        }
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PatternNode) {
            PatternNode pn = (PatternNode)obj;
            if (this.fSymbol == pn.fSymbol) {
                if (this.fConstraint == null || pn.fConstraint == null) {
                    return this.fConstraint == pn.fConstraint;
                }
                return this.fConstraint.equals(pn.fConstraint);
            }
            if (this.fSymbol == null || pn.fSymbol == null) {
                return false;
            }
            if (this.fSymbol.equals(pn.fSymbol)) {
                if (this.fConstraint == null || pn.fConstraint == null) {
                    return this.fConstraint == pn.fConstraint;
                }
                return this.fConstraint.equals(pn.fConstraint);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.fSymbol != null) {
            return this.fSymbol.hashCode();
        }
        return 11;
    }
}

