/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client.math;

import java.io.Serializable;
import org.matheclipse.parser.client.math.MathUtils;

public class Complex
implements Serializable {
    private static final long serialVersionUID = -6530173849413811929L;
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex NaN = new Complex(Double.NaN, Double.NaN);
    public static final Complex INF = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex ZERO = new Complex(0.0, 0.0);
    private final double imaginary;
    private final double real;

    public Complex(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    public double abs() {
        if (this.isNaN()) {
            return Double.NaN;
        }
        if (this.isInfinite()) {
            return Double.POSITIVE_INFINITY;
        }
        if (Math.abs(this.real) < Math.abs(this.imaginary)) {
            if (this.imaginary == 0.0) {
                return Math.abs(this.real);
            }
            double q = this.real / this.imaginary;
            return Math.abs(this.imaginary) * Math.sqrt(1.0 + q * q);
        }
        if (this.real == 0.0) {
            return Math.abs(this.imaginary);
        }
        double q = this.imaginary / this.real;
        return Math.abs(this.real) * Math.sqrt(1.0 + q * q);
    }

    public Complex add(Complex rhs) {
        return this.createComplex(this.real + rhs.getReal(), this.imaginary + rhs.getImaginary());
    }

    public Complex conjugate() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(this.real, -this.imaginary);
    }

    public Complex divide(Complex rhs) {
        if (this.isNaN() || rhs.isNaN()) {
            return NaN;
        }
        double c = rhs.getReal();
        double d = rhs.getImaginary();
        if (c == 0.0 && d == 0.0) {
            return NaN;
        }
        if (rhs.isInfinite() && !this.isInfinite()) {
            return ZERO;
        }
        if (Math.abs(c) < Math.abs(d)) {
            if (d == 0.0) {
                return this.createComplex(this.real / c, this.imaginary / c);
            }
            double q = c / d;
            double denominator = c * q + d;
            return this.createComplex((this.real * q + this.imaginary) / denominator, (this.imaginary * q - this.real) / denominator);
        }
        if (c == 0.0) {
            return this.createComplex(this.imaginary / d, -this.real / c);
        }
        double q = d / c;
        double denominator = d * q + c;
        return this.createComplex((this.imaginary * q + this.real) / denominator, (this.imaginary - this.real * q) / denominator);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof Complex) {
            Complex rhs = (Complex)other;
            boolean ret = rhs.isNaN() ? this.isNaN() : this.real == rhs.getReal() && this.imaginary == rhs.getImaginary();
            return ret;
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 7;
        }
        return 37 * (17 * MathUtils.hash(this.imaginary) + MathUtils.hash(this.real));
    }

    public double getImaginary() {
        return this.imaginary;
    }

    public double getReal() {
        return this.real;
    }

    public boolean isNaN() {
        return Double.isNaN(this.real) || Double.isNaN(this.imaginary);
    }

    public boolean isInfinite() {
        return !this.isNaN() && (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary));
    }

    public Complex multiply(Complex rhs) {
        if (this.isNaN() || rhs.isNaN()) {
            return NaN;
        }
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary) || Double.isInfinite(rhs.real) || Double.isInfinite(rhs.imaginary)) {
            return INF;
        }
        return this.createComplex(this.real * rhs.real - this.imaginary * rhs.imaginary, this.real * rhs.imaginary + this.imaginary * rhs.real);
    }

    public Complex negate() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(-this.real, -this.imaginary);
    }

    public Complex subtract(Complex rhs) {
        if (this.isNaN() || rhs.isNaN()) {
            return NaN;
        }
        return this.createComplex(this.real - rhs.getReal(), this.imaginary - rhs.getImaginary());
    }

    public Complex acos() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.add(this.sqrt1z().multiply(I)).log().multiply(I.negate());
    }

    public Complex asin() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.sqrt1z().add(this.multiply(I)).log().multiply(I.negate());
    }

    public Complex atan() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.add(I).divide(I.subtract(this)).log().multiply(I.divide(this.createComplex(2.0, 0.0)));
    }

    public Complex cos() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(Math.cos(this.real) * MathUtils.cosh(this.imaginary), -Math.sin(this.real) * MathUtils.sinh(this.imaginary));
    }

    public Complex cosh() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(MathUtils.cosh(this.real) * Math.cos(this.imaginary), MathUtils.sinh(this.real) * Math.sin(this.imaginary));
    }

    public Complex exp() {
        if (this.isNaN()) {
            return NaN;
        }
        double expReal = Math.exp(this.real);
        return this.createComplex(expReal * Math.cos(this.imaginary), expReal * Math.sin(this.imaginary));
    }

    public Complex log() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(Math.log(this.abs()), Math.atan2(this.imaginary, this.real));
    }

    public Complex pow(Complex x) {
        if (x == null) {
            throw new NullPointerException();
        }
        if (x.imaginary == 0.0) {
            if (x.real == 0.0) {
                if (this.real == 0.0 && this.imaginary == 0.0) {
                    return NaN;
                }
                return ONE;
            }
            if (x.real == 0.5) {
                return this.sqrt();
            }
        }
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return ZERO;
        }
        return this.log().multiply(x).exp();
    }

    public Complex sin() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(Math.sin(this.real) * MathUtils.cosh(this.imaginary), Math.cos(this.real) * MathUtils.sinh(this.imaginary));
    }

    public Complex sinh() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.createComplex(MathUtils.sinh(this.real) * Math.cos(this.imaginary), MathUtils.cosh(this.real) * Math.sin(this.imaginary));
    }

    public Complex sqrt() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return this.createComplex(0.0, 0.0);
        }
        double t = Math.sqrt((Math.abs(this.real) + this.abs()) / 2.0);
        if (this.real >= 0.0) {
            return this.createComplex(t, this.imaginary / (2.0 * t));
        }
        return this.createComplex(Math.abs(this.imaginary) / (2.0 * t), MathUtils.indicator(this.imaginary) * t);
    }

    public Complex sqrt1z() {
        return this.createComplex(1.0, 0.0).subtract(this.multiply(this)).sqrt();
    }

    public Complex tan() {
        if (this.isNaN()) {
            return NaN;
        }
        double real2 = 2.0 * this.real;
        double imaginary2 = 2.0 * this.imaginary;
        double d = Math.cos(real2) + MathUtils.cosh(imaginary2);
        return this.createComplex(Math.sin(real2) / d, MathUtils.sinh(imaginary2) / d);
    }

    public Complex tanh() {
        if (this.isNaN()) {
            return NaN;
        }
        double real2 = 2.0 * this.real;
        double imaginary2 = 2.0 * this.imaginary;
        double d = MathUtils.cosh(real2) + Math.cos(imaginary2);
        return this.createComplex(MathUtils.sinh(real2) / d, Math.sin(imaginary2) / d);
    }

    protected Complex createComplex(double real, double imaginary) {
        return new Complex(real, imaginary);
    }
}

