/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.swing.plot;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import javax.swing.JPanel;
import org.matheclipse.core.interfaces.IAST;

public abstract class AbstractPlotter2D
extends JPanel {
    protected int ascent;
    protected int xMinLength;
    protected int xMaxLength;
    protected double yMin;
    protected double yMax;
    protected double yRange;
    protected double xMin;
    protected double xMax;
    protected double xRange;
    protected GlyphVector yLabel;
    protected GlyphVector xLabel;
    protected int yLabelLength;
    protected int xLabelLength;
    protected String xText = "X";
    protected String yText = "Y";
    protected GlyphVector yMaxText;
    protected GlyphVector yMinText;
    protected GlyphVector xMaxText;
    protected GlyphVector xMinText;
    protected float yMaxLength;
    protected float yMinLength;
    protected Color[] color;
    static final Color[] COLOR = new Color[]{Color.BLUE, Color.RED, Color.GREEN, Color.ORANGE, Color.MAGENTA, Color.PINK, Color.YELLOW, Color.CYAN};
    static int newResolution = 1000;
    protected int thisResolution;
    protected static final Font f = new Font("SansSerif", 0, 12);

    public static void setResolution(int arg) {
        newResolution = arg;
    }

    protected AbstractPlotter2D() {
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    public abstract void plot(IAST var1);

    public abstract void reclaim();

    protected abstract void paintPlots(Graphics2D var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected void setupText() {
        FontRenderContext frc = new FontRenderContext(null, false, false);
        this.ascent = (int)new TextLayout(Double.toString(this.yMax), f, frc).getAscent();
        this.yLabel = f.createGlyphVector(frc, this.yText);
        this.xLabel = f.createGlyphVector(frc, this.xText);
        this.xLabelLength = (int)this.xLabel.getVisualBounds().getWidth();
        this.yLabelLength = (int)this.yLabel.getVisualBounds().getWidth();
        this.yMaxText = f.createGlyphVector(frc, Double.toString(this.yMax));
        this.yMinText = f.createGlyphVector(frc, Double.toString(this.yMin));
        this.xMaxText = f.createGlyphVector(frc, Double.toString(this.xMax));
        this.xMinText = f.createGlyphVector(frc, Double.toString(this.xMin));
        this.xMaxLength = (int)this.xMaxText.getVisualBounds().getWidth();
        this.xMinLength = (int)this.xMinText.getVisualBounds().getWidth();
        this.yMaxLength = (float)this.yMaxText.getVisualBounds().getWidth();
        this.yMinLength = (float)this.yMinText.getVisualBounds().getWidth();
        this.xMaxLength += 2;
        this.xMinLength += 2;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int left = this.getLeft();
        int right = this.getRight();
        int top = this.getTop();
        int bottom = this.getBottom();
        int width = this.getDrawableWidth(left, right);
        int height = this.getDrawableHeight(top, bottom);
        int xAxis = this.xAxis(top, height);
        int yAxis = this.yAxis(left, width);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.fillBackground(g2d, xAxis, yAxis, top, bottom, left, right);
        this.paintPlots(g2d, top, height, bottom, left, width, right);
        this.paintAxisLabels(g2d, xAxis, yAxis, top, bottom, left, right);
    }

    protected void fillBackground(Graphics2D g2d, int xAxis, int yAxis, int top, int bottom, int left, int right) {
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(Color.BLACK);
        g2d.drawLine(yAxis, top - this.ascent, yAxis, bottom);
        g2d.drawLine(left, xAxis, right + this.ascent, xAxis);
    }

    protected void paintAxisLabels(Graphics2D g2d, int xAxis, int yAxis, int top, int bottom, int left, int right) {
        Polygon yArrow = new Polygon(new int[]{yAxis, yAxis - this.ascent / 2, yAxis, yAxis + this.ascent / 2}, new int[]{this.ascent, this.ascent * 2, this.ascent * 5 / 3, this.ascent * 2}, 4);
        g2d.setPaint(new GradientPaint(0.0f, this.ascent, Color.BLACK, 0.0f, this.ascent * 2, Color.WHITE, true));
        g2d.fill(yArrow);
        g2d.setPaint(Color.BLACK);
        g2d.drawGlyphVector(this.yLabel, yAxis - this.yLabelLength / 2, this.ascent);
        g2d.setPaint(new GradientPaint(right, 0.0f, Color.WHITE, right + this.ascent, 0.0f, Color.BLACK));
        g2d.fill(new Polygon(new int[]{right, right + this.ascent, right, right + this.ascent / 3}, new int[]{xAxis - this.ascent / 2, xAxis, xAxis + this.ascent / 2, xAxis}, 4));
        g2d.setPaint(Color.BLACK);
        g2d.drawGlyphVector(this.xLabel, right + this.ascent, xAxis + this.ascent / 2);
        g2d.drawLine(yAxis, top, yAxis - this.ascent / 2, top);
        g2d.drawLine(yAxis, bottom, yAxis - this.ascent / 2, bottom);
        g2d.drawGlyphVector(this.yMaxText, (float)(yAxis - this.ascent) - this.yMaxLength, top + this.ascent / 2);
        g2d.drawGlyphVector(this.yMinText, (float)(yAxis - this.ascent) - this.yMinLength, bottom + this.ascent / 2);
        g2d.drawLine(left, xAxis, left, xAxis + this.ascent / 2);
        g2d.drawLine(right, xAxis, right, xAxis + this.ascent / 2);
        g2d.drawGlyphVector(this.xMaxText, right - this.xMaxLength / 2, xAxis + this.ascent * 2);
        g2d.drawGlyphVector(this.xMinText, left - this.xMinLength / 2, xAxis + this.ascent * 2);
    }

    protected int getTop() {
        return 2 * this.ascent;
    }

    protected int getBottom() {
        return this.getHeight() - this.ascent * 2;
    }

    protected int getDrawableHeight(int top, int bottom) {
        return bottom - top;
    }

    protected int getLeft() {
        return Math.max(this.xMinLength / 2, (int)Math.max(this.yMaxLength + (float)this.ascent, this.yMinLength + (float)this.ascent));
    }

    protected int getRight() {
        int right = this.getWidth() - (this.ascent + this.xLabelLength);
        if (right + this.xMaxLength / 2 > this.getWidth()) {
            return this.getWidth() - this.xMaxLength / 2;
        }
        return right;
    }

    protected int getDrawableWidth(int left, int right) {
        return right - left;
    }

    protected int yAxis(int left, int width) {
        return left + (int)(-this.xMin * (double)width / this.xRange);
    }

    protected int xAxis(int top, int height) {
        return top + height - (int)(-this.yMin * (double)height / this.yRange);
    }
}

