/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.swing.plot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.UnaryNumerical;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.swing.plot.AbstractPlotter2D;

public class ParametricPlotter
extends AbstractPlotter2D {
    private static final long serialVersionUID = -3712508834083106491L;
    protected double tMin;
    protected double tMax;
    protected double tRange;
    protected ISymbol t;
    protected UnaryNumerical x;
    protected UnaryNumerical y;
    protected double[][] xPoints;
    protected double[][] yPoints;
    protected static final List cache = new LinkedList();
    protected int functions;

    @Override
    public void plot(IAST args) {
        if (args.size() != 3) {
            throw new IllegalArgumentException("Incorrect number of arguments");
        }
        if (!((IExpr)args.get(1)).isList() || !((IExpr)args.get(2)).isList()) {
            throw new IllegalArgumentException("Both arguments must be lists");
        }
        this.thisResolution = newResolution;
        EvalEngine engine = EvalEngine.get();
        IAST funcs = (AST)args.get(1);
        if (((IExpr)funcs.get(1)).isList()) {
            this.functions = funcs.size() - 1;
        } else {
            funcs = args;
            this.functions = 1;
        }
        AST tArgs = (AST)args.get(2);
        if (tArgs.size() != 4) {
            throw new IllegalArgumentException("Variable name and bounds malformed");
        }
        this.t = (ISymbol)tArgs.get(1);
        this.tMin = ((INum)engine.evaluate(F.N((IExpr)tArgs.get(2)))).getRealPart();
        this.tMax = ((INum)engine.evaluate(F.N((IExpr)tArgs.get(3)))).getRealPart();
        this.tRange = this.tMax - this.tMin;
        this.xPoints = new double[this.functions][this.thisResolution + 1];
        this.yPoints = new double[this.functions][this.thisResolution + 1];
        this.color = new Color[this.functions];
        this.xMax = this.xMin = new UnaryNumerical((IExpr)((AST)funcs.get(1)).get(1), this.t, engine).value(this.tMin);
        this.yMax = this.yMin = new UnaryNumerical((IExpr)((AST)funcs.get(1)).get(2), this.t, engine).value(this.tMin);
        int f = 0;
        while (f < this.functions) {
            this.doPlot(funcs, f, engine);
            ++f;
        }
        if (this.xMax <= this.xMin) {
            if (this.xMax < 0.0) {
                this.xMax = 0.0;
            } else if (this.xMin > 0.0) {
                this.xMin = 0.0;
            } else {
                this.xMax += 1.0;
                this.xMin -= 1.0;
            }
        }
        if (this.yMax <= this.yMin) {
            if (this.yMax < 0.0) {
                this.yMax = 0.0;
            } else if (this.yMin > 0.0) {
                this.yMin = 0.0;
            } else {
                this.yMax += 1.0;
                this.yMin -= 1.0;
            }
        }
        this.xRange = this.xMax - this.xMin;
        this.yRange = this.yMax - this.yMin;
        this.setupText();
    }

    protected void doPlot(IAST funcs, int f, EvalEngine engine) {
        if (((AST)funcs.get(f + 1)).size() < 3) {
            throw new IllegalArgumentException("Two functions required for plot #" + f);
        }
        this.x = new UnaryNumerical((IExpr)((AST)funcs.get(f + 1)).get(1), this.t, engine);
        this.y = new UnaryNumerical((IExpr)((AST)funcs.get(f + 1)).get(2), this.t, engine);
        int counter = 0;
        while (counter <= this.thisResolution) {
            this.plotPoint(f, counter);
            ++counter;
        }
        this.colorPlot(funcs, f);
    }

    protected void colorPlot(IAST funcs, int f) {
        String s;
        this.color[f] = ((AST)funcs.get(f + 1)).size() > 3 ? ((s = ((IExpr)((AST)funcs.get(f + 1)).get(3)).toString().toLowerCase()).startsWith("b") ? Color.BLUE : (s.startsWith("c") ? Color.CYAN : (s.startsWith("g") ? Color.GREEN : (s.startsWith("m") ? Color.MAGENTA : (s.startsWith("o") ? Color.ORANGE : (s.startsWith("p") ? Color.PINK : (s.startsWith("r") ? Color.RED : Color.YELLOW))))))) : COLOR[f % COLOR.length];
    }

    protected void plotPoint(int f, int n) {
        this.xPoints[f][n] = this.x.value(this.tMin + this.tRange * (double)n / (double)this.thisResolution);
        if (this.xPoints[f][n] < this.xMin) {
            this.xMin = this.xPoints[f][n];
        } else if (this.xPoints[f][n] > this.xMax) {
            this.xMax = this.xPoints[f][n];
        }
        this.yPoints[f][n] = this.y.value(this.tMin + this.tRange * (double)n / (double)this.thisResolution);
        if (this.yPoints[f][n] < this.yMin) {
            this.yMin = this.yPoints[f][n];
        } else if (this.yPoints[f][n] > this.yMax) {
            this.yMax = this.yPoints[f][n];
        }
    }

    @Override
    protected void paintPlots(Graphics2D g2d, int top, int height, int bottom, int left, int width, int right) {
        int[] x = new int[this.thisResolution + 1];
        int[] y = new int[this.thisResolution + 1];
        int f = 0;
        while (f < this.functions) {
            this.paintPlot(g2d, top, height, bottom, left, width, right, x, y, f);
            ++f;
        }
    }

    protected void paintPlot(Graphics2D g2d, int top, int height, int bottom, int left, int width, int right, int[] x, int[] y, int f) {
        g2d.setColor(this.color[f]);
        int counter = 0;
        while (counter <= this.thisResolution) {
            this.convertPoint(top, height, bottom, left, width, right, x, y, f, counter);
            ++counter;
        }
        g2d.drawPolyline(x, y, this.thisResolution + 1);
    }

    protected void convertPoint(int top, int height, int bottom, int left, int width, int right, int[] x, int[] y, int f, int n) {
        x[n] = left + (int)((this.xPoints[f][n] - this.xMin) * (double)width / this.xRange);
        y[n] = top + height - (int)((this.yPoints[f][n] - this.yMin) * (double)height / this.yRange);
    }

    public static ParametricPlotter getParametricPlotter() {
        if (cache.isEmpty()) {
            return new ParametricPlotter();
        }
        ParametricPlotter pp = (ParametricPlotter)cache.get(0);
        cache.remove(pp);
        return pp;
    }

    @Override
    public void reclaim() {
        this.xPoints = null;
        this.yPoints = null;
        this.x = null;
        this.y = null;
        cache.add(this);
    }

    public static void clearCache() {
        cache.clear();
    }
}

