/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.swing.plot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.UnaryNumerical;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.swing.plot.AbstractPlotter2D;

public class Plotter
extends AbstractPlotter2D {
    private static final long serialVersionUID = 1281925675150410124L;
    protected int numFuncs;
    protected double[][] point;
    protected int[] paintPoint;
    protected int[] xPoint;
    protected static final List<Plotter> cache = new ArrayList<Plotter>();

    @Override
    public void plot(IAST args) {
        IAST funcs;
        if (args.size() < 3) {
            throw new IllegalArgumentException("At least two arguments needed.");
        }
        this.thisResolution = newResolution;
        EvalEngine engine = EvalEngine.get();
        if (((IExpr)args.get(1)).isList()) {
            funcs = (AST)args.get(1);
            this.numFuncs = funcs.size() - 1;
        } else {
            funcs = args;
            this.numFuncs = 1;
        }
        this.point = new double[this.numFuncs][this.thisResolution + 1];
        this.paintPoint = new int[this.thisResolution + 1];
        this.xPoint = new int[this.thisResolution + 1];
        this.color = new Color[this.numFuncs];
        AST xArgs = (AST)args.get(2);
        ISymbol xVar = (ISymbol)xArgs.get(1);
        this.xText = xVar.toString();
        this.xMin = ((INum)engine.evaluate(F.N((IExpr)xArgs.get(2)))).getRealPart();
        this.xMax = ((INum)engine.evaluate(F.N((IExpr)xArgs.get(3)))).getRealPart();
        this.xRange = this.xMax - this.xMin;
        try {
            this.yMax = this.yMin = new UnaryNumerical((IExpr)funcs.get(1), xVar, engine).value(this.xMin);
        }
        catch (Exception e) {
            this.yMin = 0.0;
            this.yMax = 0.0;
        }
        int func = 0;
        while (func < this.numFuncs) {
            this.populate(funcs, func, xVar, engine);
            ++func;
        }
        int counter = 3;
        while (counter < args.size()) {
            AST currentArgs = (AST)args.get(counter);
            if (this.getColor((IExpr)currentArgs.get(1)) != null) {
                int i = 0;
                while (i < this.color.length) {
                    this.color[i] = this.getColor((IExpr)currentArgs.get(i % (currentArgs.size() - 1) + 1));
                    ++i;
                }
            } else {
                this.yText = ((IExpr)currentArgs.get(1)).toString();
                this.yMin = ((INum)engine.evaluate(F.N((IExpr)currentArgs.get(2)))).getRealPart();
                this.yMax = ((INum)engine.evaluate(F.N((IExpr)currentArgs.get(3)))).getRealPart();
            }
            ++counter;
        }
        if (this.yMax <= this.yMin) {
            if (this.yMax < 0.0) {
                this.yMax = 0.0;
            }
            if (this.yMin > 0.0) {
                this.yMin = 0.0;
            }
            if (this.yMax <= this.yMin) {
                this.yMax = this.yMin = (this.yMax + this.yMin) / 2.0;
                this.yMax += 1.0;
                this.yMin -= 1.0;
            }
        }
        this.yRange = this.yMax - this.yMin;
        this.setupText();
    }

    protected void populate(IAST funcs, int func, ISymbol xVar, EvalEngine engine) {
        UnaryNumerical un = new UnaryNumerical((IExpr)funcs.get(func + 1), xVar, engine);
        this.color[func] = COLOR[func % COLOR.length];
        int counter = 0;
        while (counter <= this.thisResolution) {
            try {
                this.populatePoint(func, un, counter);
            }
            catch (Exception e) {
                this.point[func][counter] = Double.POSITIVE_INFINITY;
            }
            ++counter;
        }
    }

    protected void populatePoint(int func, UnaryNumerical un, int x) {
        this.point[func][x] = un.value(this.xMin + this.xRange * (double)x / (double)this.thisResolution);
        if (this.point[func][x] < this.yMin) {
            this.yMin = this.point[func][x];
        } else if (this.point[func][x] > this.yMax) {
            this.yMax = this.point[func][x];
        }
    }

    protected Color getColor(IExpr ho) {
        String s = ho.toString().toLowerCase();
        if (s.startsWith("blue")) {
            return Color.BLUE;
        }
        if (s.startsWith("cyan")) {
            return Color.CYAN;
        }
        if (s.startsWith("green")) {
            return Color.GREEN;
        }
        if (s.startsWith("magenta")) {
            return Color.MAGENTA;
        }
        if (s.equals("orange")) {
            return Color.ORANGE;
        }
        if (s.equals("pink")) {
            return Color.PINK;
        }
        if (s.equals("red")) {
            return Color.RED;
        }
        if (s.equals("yellow")) {
            return Color.YELLOW;
        }
        return null;
    }

    @Override
    protected void paintPlots(Graphics2D g2d, int top, int height, int bottom, int left, int width, int right) {
        int func = 0;
        while (func < this.numFuncs) {
            this.paintPlot(g2d, top, height, bottom, left, width, right, func);
            ++func;
        }
    }

    protected void paintPlot(Graphics2D g2d, int top, int height, int bottom, int left, int width, int right, int func) {
        int index = 0;
        g2d.setColor(this.color[func]);
        int counter = 0;
        while (counter <= this.thisResolution) {
            this.xPoint[index] = left + counter * width / this.thisResolution;
            this.paintPoint[index] = top + height - (int)((this.point[func][counter] - this.yMin) * (double)height / this.yRange);
            if (this.paintPoint[index] >= top && this.paintPoint[index] <= bottom) {
                ++index;
            } else {
                g2d.drawPolyline(this.xPoint, this.paintPoint, --index);
                index = 0;
            }
            ++counter;
        }
        g2d.drawPolyline(this.xPoint, this.paintPoint, index);
    }

    public static Plotter getPlotter() {
        if (cache.isEmpty()) {
            return new Plotter();
        }
        Plotter p = cache.get(0);
        cache.remove(p);
        return p;
    }

    @Override
    public void reclaim() {
        cache.add(this);
    }

    public static void clearCache() {
        cache.clear();
    }
}

