/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sosy_lab.common.Appender;

public class Appenders {
    private Appenders() {
    }

    public static Appender createAppender(@Nullable Object o) {
        if (o instanceof Appender) {
            return (Appender)o;
        }
        return Appenders.fromToStringMethod(o);
    }

    public static void appendTo(Appendable output, @Nullable Object o) throws IOException {
        if (o instanceof Appender) {
            ((Appender)o).appendTo(output);
        } else {
            output.append(Objects.toString(o));
        }
    }

    public static Appender forIterable(final Joiner joiner, final Iterable<?> it) {
        Preconditions.checkNotNull(joiner);
        Preconditions.checkNotNull(it);
        return new AbstractAppender(){

            @Override
            public void appendTo(Appendable appendable) throws IOException {
                joiner.appendTo(appendable, it);
            }
        };
    }

    public static Appender forMap(final Joiner.MapJoiner joiner, final Map<?, ?> map) {
        Preconditions.checkNotNull(joiner);
        Preconditions.checkNotNull(map);
        return new AbstractAppender(){

            @Override
            public void appendTo(Appendable appendable) throws IOException {
                joiner.appendTo(appendable, map);
            }
        };
    }

    public static Appender fromToStringMethod(final @Nullable Object o) {
        return new AbstractAppender(){

            @Override
            public void appendTo(Appendable appendable) throws IOException {
                appendable.append(Objects.toString(o));
            }
        };
    }

    public static StringBuilder appendTo(StringBuilder sb, Appender a) {
        Preconditions.checkNotNull(sb);
        try {
            a.appendTo(sb);
        }
        catch (IOException e) {
            throw new AssertionError("StringBuilder threw IOException", e);
        }
        return sb;
    }

    public static Appender concat(final Iterable<Appender> pAppenders) {
        Preconditions.checkNotNull(pAppenders);
        return new AbstractAppender(){

            @Override
            public void appendTo(Appendable pAppendable) throws IOException {
                for (Appender appender : pAppenders) {
                    appender.appendTo(pAppendable);
                }
            }
        };
    }

    public static Appender concat(Appender ... pAppenders) {
        return Appenders.concat(ImmutableList.copyOf(pAppenders));
    }

    public static String toString(Appender a) {
        return Appenders.appendTo(new StringBuilder(), a).toString();
    }

    public static String toStringWithTruncation(Appender a, final int truncateAt) {
        Preconditions.checkArgument(truncateAt >= 0, "Maximum size of String cannot be negative");
        final StringBuilder sb = new StringBuilder();
        Appendable limiter = new Appendable(){

            private void checkSize() throws SizeLimitReachedException {
                if (sb.length() >= truncateAt) {
                    throw new SizeLimitReachedException();
                }
            }

            @Override
            public Appendable append(CharSequence pCsq, int pStart, int pEnd) throws IOException {
                sb.append(pCsq, pStart, pEnd);
                this.checkSize();
                return this;
            }

            @Override
            public Appendable append(char pC) throws IOException {
                sb.append(pC);
                this.checkSize();
                return this;
            }

            @Override
            public Appendable append(CharSequence pCsq) throws IOException {
                sb.append(pCsq);
                this.checkSize();
                return this;
            }
        };
        try {
            a.appendTo(limiter);
        }
        catch (SizeLimitReachedException e) {
            assert (sb.length() >= truncateAt);
            sb.setLength(truncateAt);
        }
        catch (IOException e) {
            throw new AssertionError("StringBuilder threw IOException", e);
        }
        return sb.toString();
    }

    public static abstract class AbstractAppender
    implements Appender {
        public String toString() {
            return Appenders.toString(this);
        }
    }

    private static class SizeLimitReachedException
    extends IOException {
        private static final long serialVersionUID = 1855247676627224183L;

        private SizeLimitReachedException() {
        }
    }
}

