/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.regex.Pattern;

public class ChildFirstPatternClassLoader
extends URLClassLoader {
    private final Pattern classPattern;

    public ChildFirstPatternClassLoader(Pattern pClassPattern, URL[] pUrls, ClassLoader pParent) {
        super(pUrls, Preconditions.checkNotNull(pParent));
        this.classPattern = Preconditions.checkNotNull(pClassPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean pResolve) throws ClassNotFoundException {
        if (!this.classPattern.matcher(name).matches()) {
            return super.loadClass(name, pResolve);
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
            if (pResolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }
}

