/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.annotations.Unmaintained;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;

public final class Classes {
    private Classes() {
    }

    public static <T> T createInstance(Class<? extends T> cls, @Nullable Class<?>[] argumentTypes, @Nullable Object[] argumentValues, Class<T> type) throws ClassInstantiationException, InvocationTargetException {
        Preconditions.checkNotNull(type);
        try {
            Constructor<T> ct = cls.getConstructor(argumentTypes);
            return ct.newInstance(argumentValues);
        }
        catch (SecurityException e) {
            throw new ClassInstantiationException(cls.getCanonicalName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ClassInstantiationException(cls.getCanonicalName(), "Matching constructor not found!", e);
        }
        catch (InstantiationException e) {
            throw new ClassInstantiationException(cls.getCanonicalName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ClassInstantiationException(cls.getCanonicalName(), e);
        }
    }

    public static <T> T createInstance(Class<T> type, Class<? extends T> cls, @Nullable Class<?>[] argumentTypes, Object[] argumentValues) throws InvalidConfigurationException {
        return Classes.createInstance(type, cls, argumentTypes, argumentValues, RuntimeException.class);
    }

    public static <T, X extends Exception> T createInstance(Class<T> type, Class<? extends T> cls, @Nullable Class<?>[] argumentTypes, Object[] argumentValues, Class<X> exceptionType) throws X, InvalidConfigurationException {
        Constructor<T> ct;
        Preconditions.checkNotNull(exceptionType);
        if (argumentTypes == null) {
            argumentTypes = new Class[argumentValues.length];
            int i = 0;
            for (Object obj : argumentValues) {
                argumentTypes[i++] = obj.getClass();
            }
        } else {
            Preconditions.checkArgument(argumentTypes.length == argumentValues.length);
        }
        String className = cls.getSimpleName();
        String typeName = type.getSimpleName();
        try {
            ct = cls.getConstructor(argumentTypes);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidConfigurationException("Invalid " + typeName + " " + className + ", no matching constructor", e);
        }
        String exception = Classes.verifyDeclaredExceptions(ct, exceptionType, InvalidConfigurationException.class);
        if (exception != null) {
            throw new InvalidConfigurationException("Invalid " + typeName + " " + className + ", constructor declares unsupported checked exception " + exception);
        }
        try {
            return ct.newInstance(argumentValues);
        }
        catch (InstantiationException e) {
            throw new InvalidConfigurationException("Invalid " + typeName + " " + className + ", class cannot be instantiated (" + e.getMessage() + ")", e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidConfigurationException("Invalid " + typeName + " " + className + ", constructor is not accessible", e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfPossible(t, exceptionType, InvalidConfigurationException.class);
            throw new UnexpectedCheckedException("instantiation of " + typeName + " " + className, t);
        }
    }

    public static Class<?> forName(String name, @Nullable String prefix) throws ClassNotFoundException, SecurityException {
        return Classes.forName(name, prefix, null);
    }

    private static Class<?> forName(String name, @Nullable String prefix, @Nullable ClassLoader cl) throws ClassNotFoundException, SecurityException {
        if (cl == null) {
            cl = Classes.class.getClassLoader();
        }
        if (prefix == null || prefix.isEmpty()) {
            return cl.loadClass(name);
        }
        try {
            return cl.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            try {
                return cl.loadClass(prefix + "." + name);
            }
            catch (ClassNotFoundException _) {
                throw e;
            }
        }
    }

    @Nullable
    public static String verifyDeclaredExceptions(Constructor<?> constructor, Class<?> ... allowedExceptionTypes) {
        return Classes.verifyDeclaredExceptions(constructor.getExceptionTypes(), allowedExceptionTypes);
    }

    @Nullable
    public static String verifyDeclaredExceptions(Method method, Class<?> ... allowedExceptionTypes) {
        return Classes.verifyDeclaredExceptions(method.getExceptionTypes(), allowedExceptionTypes);
    }

    @Nullable
    private static String verifyDeclaredExceptions(Class<?>[] declaredExceptionTypes, Class<?>[] allowedExceptionTypes) {
        Preconditions.checkNotNull(allowedExceptionTypes);
        for (Class<?> declaredException : declaredExceptionTypes) {
            if (!Exception.class.isAssignableFrom(declaredException) || Runtime.class.isAssignableFrom(declaredException)) continue;
            boolean ok = false;
            for (Class<?> allowedExceptionType : allowedExceptionTypes) {
                if (!allowedExceptionType.isAssignableFrom(declaredException)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return declaredException.getSimpleName();
        }
        return null;
    }

    public static Pair<Class<?>, ParameterizedType> getComponentType(Type type) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(type instanceof ParameterizedType, "Cannot extract generic parameter from non-parameterized type %s", type);
        ParameterizedType pType = (ParameterizedType)type;
        Type[] parameterTypes = pType.getActualTypeArguments();
        Preconditions.checkArgument(parameterTypes.length == 1, "Cannot extract generic parameter from parameterized type %s which has not exactly one parameter", type);
        Type paramType = parameterTypes[0];
        paramType = Classes.extractUpperBoundFromType(paramType);
        ParameterizedType componentGenericType = null;
        if (paramType instanceof ParameterizedType) {
            componentGenericType = (ParameterizedType)paramType;
            paramType = componentGenericType.getRawType();
        }
        if (!(paramType instanceof Class)) {
            throw new UnsupportedOperationException("Cannot extract generic base type from type " + paramType);
        }
        Class componentType = (Class)paramType;
        return Pair.of(componentType, componentGenericType);
    }

    public static Type extractUpperBoundFromType(Type type) {
        Preconditions.checkNotNull(type);
        if (type instanceof WildcardType) {
            WildcardType wcType = (WildcardType)type;
            if (wcType.getLowerBounds().length > 0) {
                throw new UnsupportedOperationException("Currently wildcard types with a lower bound like \"" + type + "\" are not supported ");
            }
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            if (upperBounds.length != 1) {
                throw new UnsupportedOperationException("Currently only type bounds with one upper bound are supported, not \"" + type + "\"");
            }
            type = upperBounds[0];
        }
        return type;
    }

    public static void produceClassLoadingWarning(LogManager logger, Class<?> cls, @Nullable Class<?> type) {
        String typeName;
        Preconditions.checkNotNull(logger);
        Package pkg = cls.getPackage();
        String string = typeName = type == null ? "class" : type.getSimpleName();
        if (cls.isAnnotationPresent(Deprecated.class) || pkg.isAnnotationPresent(Deprecated.class)) {
            logger.logf(Level.WARNING, "Using %s %s, which is marked as deprecated and should not be used.", typeName, cls.getSimpleName());
        } else if (cls.isAnnotationPresent(Unmaintained.class) || pkg.isAnnotationPresent(Unmaintained.class)) {
            logger.logf(Level.WARNING, "Using %s %s, which is unmaintained and may not work correctly.", typeName, cls.getSimpleName());
        }
    }

    public static final class UnexpectedCheckedException
    extends RuntimeException {
        private static final long serialVersionUID = -8706288432548996095L;

        public UnexpectedCheckedException(String message, Throwable source) {
            super("Unexpected checked exception " + source.getClass().getSimpleName() + (Strings.isNullOrEmpty(message) ? "" : " during " + message) + (Strings.isNullOrEmpty(source.getMessage()) ? "" : ": " + source.getMessage()), source);
            assert (source instanceof Exception && !(source instanceof RuntimeException));
        }
    }

    public static class ClassInstantiationException
    extends Exception {
        private static final long serialVersionUID = 7862065219560550275L;

        public ClassInstantiationException(String className, String msg, Throwable cause) {
            super("Cannot instantiate class " + className + ":" + msg, cause);
        }

        public ClassInstantiationException(String className, Throwable cause) {
            super("Cannot instantiate class " + className + ":" + cause.getMessage(), cause);
        }
    }
}

