/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Strings;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.common.io.Path;

public final class JSON {
    private JSON() {
    }

    public static void writeJSONString(@Nullable Object value, Path file) throws IOException {
        try (Writer out = file.asCharSink(StandardCharsets.US_ASCII, new FileWriteMode[0]).openStream();){
            JSON.writeJSONString(value, (Appendable)out);
        }
    }

    public static void writeJSONString(@Nullable Object value, Appendable out) throws IOException {
        if (value == null) {
            out.append("null");
        } else if (value instanceof CharSequence) {
            out.append('\"');
            JSON.escape((CharSequence)value, out);
            out.append('\"');
        } else if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                out.append("null");
            } else {
                out.append(value.toString());
            }
        } else if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                out.append("null");
            } else {
                out.append(value.toString());
            }
        } else if (value instanceof Number) {
            out.append(value.toString());
        } else if (value instanceof Boolean) {
            out.append(value.toString());
        } else if (value instanceof Map) {
            JSON.writeJSONString((Map)value, out);
        } else if (value instanceof List) {
            JSON.writeJSONString((List)value, out);
        } else {
            throw new NotSerializableException("Object of class " + value.getClass().getName() + " cannot be written as JSON");
        }
    }

    private static void writeJSONString(List<?> list, Appendable out) throws IOException {
        boolean first = true;
        out.append('[');
        for (Object value : list) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            JSON.writeJSONString(value, out);
        }
        out.append(']');
    }

    private static void writeJSONString(Map<?, ?> map, Appendable out) throws IOException {
        boolean first = true;
        out.append('{');
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append('\"');
            JSON.escape(String.valueOf(entry.getKey()), out);
            out.append('\"');
            out.append(':');
            JSON.writeJSONString(entry.getValue(), out);
        }
        out.append('}');
    }

    private static void escape(CharSequence s, Appendable out) throws IOException {
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    out.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    out.append("\\b");
                    continue block10;
                }
                case '\f': {
                    out.append("\\f");
                    continue block10;
                }
                case '\n': {
                    out.append("\\n");
                    continue block10;
                }
                case '\r': {
                    out.append("\\r");
                    continue block10;
                }
                case '\t': {
                    out.append("\\t");
                    continue block10;
                }
                case '/': {
                    out.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch).toUpperCase();
                        out.append("\\u");
                        out.append(Strings.padStart(ss, 4, '0'));
                        continue block10;
                    }
                    out.append(ch);
                }
            }
        }
    }
}

