/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Pair<A, B>
implements Serializable {
    private static final long serialVersionUID = -8410959888808077296L;
    @Nullable
    private final A first;
    @Nullable
    private final B second;

    private Pair(@Nullable A first, @Nullable B second) {
        this.first = first;
        this.second = second;
    }

    public static <A, B> Pair<A, B> of(@Nullable A first, @Nullable B second) {
        return new Pair<A, B>(first, second);
    }

    @Nullable
    public A getFirst() {
        return this.first;
    }

    @Nullable
    public B getSecond() {
        return this.second;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Pair && Objects.equals(this.first, ((Pair)other).first) && Objects.equals(this.second, ((Pair)other).second);
    }

    public int hashCode() {
        if (this.first == null) {
            return this.second == null ? 0 : this.second.hashCode() + 1;
        }
        if (this.second == null) {
            return this.first.hashCode() + 2;
        }
        return this.first.hashCode() * 17 + this.second.hashCode();
    }

    public static <T> Function<Pair<? extends T, ?>, T> getProjectionToFirst() {
        return Holder.getInstance().PROJECTION_TO_FIRST;
    }

    public static <T> Function<Pair<?, ? extends T>, T> getProjectionToSecond() {
        return Holder.getInstance().PROJECTION_TO_SECOND;
    }

    public static <K, V> Function<Map.Entry<? extends K, ? extends V>, Pair<K, V>> getPairFomMapEntry() {
        return Holder.getInstance().PAIR_FROM_MAP_ENTRY;
    }

    public static <A, B> List<Pair<A, B>> zipList(Collection<? extends A> a, Collection<? extends B> b) {
        ArrayList<Pair<A, B>> result = new ArrayList<Pair<A, B>>(a.size());
        Iterator<A> iteratorA = a.iterator();
        Iterator<B> iteratorB = b.iterator();
        while (iteratorA.hasNext()) {
            Preconditions.checkArgument(iteratorB.hasNext(), "Second list is shorter");
            result.add(Pair.of(iteratorA.next(), iteratorB.next()));
        }
        Preconditions.checkArgument(!iteratorB.hasNext(), "Second list is longer");
        return result;
    }

    public static <A, B> Iterable<Pair<A, B>> zipWithPadding(final Iterable<? extends A> a, final Iterable<? extends B> b) {
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        return new Iterable<Pair<A, B>>(){

            @Override
            public Iterator<Pair<A, B>> iterator() {
                return new ZipIterator(a.iterator(), b.iterator());
            }
        };
    }

    public static <A1, B1, A2, B2> Function<Pair<A1, A2>, Pair<B1, B2>> componentWise(final Function<? super A1, ? extends B1> f1, final Function<? super A2, ? extends B2> f2) {
        Preconditions.checkNotNull(f1);
        Preconditions.checkNotNull(f2);
        return new Function<Pair<A1, A2>, Pair<B1, B2>>(){

            @Override
            public Pair<B1, B2> apply(@Nonnull Pair<A1, A2> pInput) {
                return Pair.of(f1.apply(pInput.getFirst()), f2.apply(pInput.getSecond()));
            }
        };
    }

    public static <A extends Comparable<? super A>, B extends Comparable<? super B>> Ordering<Pair<A, B>> lexicographicalNaturalComparator() {
        return Pair.lexicographicalComparator(Ordering.natural(), Ordering.natural());
    }

    public static <A, B> Ordering<Pair<A, B>> lexicographicalComparator(Comparator<A> firstOrdering, Comparator<B> secondOrdering) {
        return Ordering.from(firstOrdering).onResultOf(Pair.getProjectionToFirst()).compound(Ordering.from(secondOrdering).onResultOf(Pair.getProjectionToSecond()));
    }

    private static class ZipIterator<A, B>
    implements Iterator<Pair<A, B>> {
        private final Iterator<? extends A> a;
        private final Iterator<? extends B> b;

        public ZipIterator(Iterator<? extends A> pA, Iterator<? extends B> pB) {
            this.a = pA;
            this.b = pB;
        }

        @Override
        public boolean hasNext() {
            return this.a.hasNext() || this.b.hasNext();
        }

        @Override
        public Pair<A, B> next() {
            Object nextA = null;
            if (this.a.hasNext()) {
                nextA = this.a.next();
            }
            Object nextB = null;
            if (this.b.hasNext()) {
                nextB = this.b.next();
            }
            return Pair.of(nextA, nextB);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class Holder<T, T2> {
        private static final Holder<?, ?> INSTANCE = new Holder();
        private final Function<Pair<? extends T, ?>, T> PROJECTION_TO_FIRST = new Function<Pair<? extends T, ?>, T>(){

            @Override
            public T apply(@Nonnull Pair<? extends T, ?> pArg0) {
                return pArg0.getFirst();
            }
        };
        private final Function<Pair<?, ? extends T>, T> PROJECTION_TO_SECOND = new Function<Pair<?, ? extends T>, T>(){

            @Override
            public T apply(@Nonnull Pair<?, ? extends T> pArg0) {
                return pArg0.getSecond();
            }
        };
        private final Function<Map.Entry<? extends T, ? extends T2>, Pair<T, T2>> PAIR_FROM_MAP_ENTRY = new Function<Map.Entry<? extends T, ? extends T2>, Pair<T, T2>>(){

            @Override
            public Pair<T, T2> apply(@Nonnull Map.Entry<? extends T, ? extends T2> pArg0) {
                return Pair.of(pArg0.getKey(), pArg0.getValue());
            }
        };

        private Holder() {
        }

        public static <T, T2> Holder<T, T2> getInstance() {
            return INSTANCE;
        }
    }
}

