/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.concurrency.Concurrency;
import org.sosy_lab.common.log.LogManager;

public class ProcessExecutor<E extends Exception> {
    private final String name;
    private final Class<E> exceptionClass;
    private final Writer in;
    private final ListeningExecutorService executor = MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(3));
    private final ListenableFuture<?> outFuture;
    private final ListenableFuture<?> errFuture;
    private final ListenableFuture<Integer> processFuture;
    private final List<String> output = new ArrayList<String>();
    private final List<String> errorOutput = new ArrayList<String>();
    private boolean finished = false;
    protected final LogManager logger;

    public ProcessExecutor(LogManager logger, Class<E> exceptionClass, String ... cmd) throws IOException {
        this(logger, exceptionClass, ImmutableMap.of(), cmd);
    }

    public ProcessExecutor(final LogManager logger, Class<E> exceptionClass, Map<String, String> environmentOverride, String ... cmd) throws IOException {
        Preconditions.checkNotNull(cmd);
        Preconditions.checkArgument(cmd.length > 0);
        this.logger = Preconditions.checkNotNull(logger);
        this.exceptionClass = Preconditions.checkNotNull(exceptionClass);
        this.name = cmd[0];
        logger.log(Level.FINEST, "Executing", this.name);
        logger.log(Level.ALL, cmd);
        ProcessBuilder proc = new ProcessBuilder(cmd);
        Map<String, String> environment = proc.environment();
        for (Map.Entry<String, String> entry : environmentOverride.entrySet()) {
            if (entry.getValue() == null) {
                environment.remove(entry.getKey());
                continue;
            }
            environment.put(entry.getKey(), entry.getValue());
        }
        final Process process = proc.start();
        this.processFuture = this.executor.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                logger.log(Level.FINEST, "Waiting for", ProcessExecutor.this.name);
                try {
                    int exitCode = process.waitFor();
                    logger.log(Level.FINEST, ProcessExecutor.this.name, "has terminated normally");
                    ProcessExecutor.this.handleExitCode(exitCode);
                    return exitCode;
                }
                catch (InterruptedException e) {
                    process.destroy();
                    while (true) {
                        try {
                            int exitCode = process.waitFor();
                            logger.log(Level.FINEST, ProcessExecutor.this.name, "has terminated after it was cancelled");
                            Thread.currentThread().interrupt();
                            return exitCode;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }
        });
        this.in = new OutputStreamWriter(process.getOutputStream(), Charset.defaultCharset());
        this.outFuture = this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception, IOException {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        ProcessExecutor.this.handleOutput(line);
                    }
                }
                catch (IOException e) {
                    if (ProcessExecutor.this.processFuture.isCancelled()) {
                        logger.logDebugException(e, "IOException after process was killed");
                    }
                    throw e;
                }
                return null;
            }
        });
        this.errFuture = this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception, IOException {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), Charset.defaultCharset()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        ProcessExecutor.this.handleErrorOutput(line);
                    }
                }
                catch (IOException e) {
                    if (ProcessExecutor.this.processFuture.isCancelled()) {
                        logger.logDebugException(e, "IOException after process was killed");
                    }
                    throw e;
                }
                return null;
            }
        });
        FutureCallback<Object> cancelProcessOnFailure = new FutureCallback<Object>(){

            @Override
            public void onFailure(Throwable e) {
                if (!ProcessExecutor.this.processFuture.isCancelled()) {
                    logger.logUserException(Level.FINEST, e, "Killing " + ProcessExecutor.this.name + " due to error in output handling");
                    ProcessExecutor.this.processFuture.cancel(true);
                } else {
                    logger.logDebugException(e, "Error in output handling after " + ProcessExecutor.this.name + " was already killed");
                }
            }

            @Override
            public void onSuccess(Object pArg0) {
            }
        };
        Futures.addCallback(this.outFuture, cancelProcessOnFailure);
        Futures.addCallback(this.errFuture, cancelProcessOnFailure);
        this.executor.shutdown();
    }

    public void println(String s) throws IOException {
        Preconditions.checkNotNull(s);
        this.print(s + "\n");
    }

    public void print(String s) throws IOException {
        Preconditions.checkNotNull(s);
        Preconditions.checkState(!this.finished, "Cannot write to process that has already terminated.");
        this.in.write(s);
        this.in.flush();
    }

    public void sendEOF() throws IOException {
        Preconditions.checkState(!this.finished, "Cannot write to process that has already terminated.");
        this.in.close();
    }

    public int join(long timelimit) throws IOException, E, TimeoutException, InterruptedException {
        try {
            Integer exitCode = null;
            try {
                exitCode = timelimit > 0L ? (Integer)this.processFuture.get(timelimit, TimeUnit.MILLISECONDS) : (Integer)this.processFuture.get();
            }
            catch (CancellationException e) {
                // empty catch block
            }
            this.outFuture.get();
            this.errFuture.get();
            if (exitCode == null) {
                throw new InterruptedException();
            }
            int e = exitCode;
            return e;
        }
        catch (TimeoutException e) {
            this.logger.log(Level.WARNING, "Killing", this.name, "due to timeout");
            this.processFuture.cancel(true);
            throw e;
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, "Killing", this.name, "due to user interrupt");
            this.processFuture.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfPossible(t, IOException.class, this.exceptionClass);
            throw new Classes.UnexpectedCheckedException("output handling of external process " + this.name, t);
        }
        finally {
            assert (this.processFuture.isDone());
            Concurrency.waitForTermination(this.executor);
            try {
                this.in.close();
            }
            catch (IOException e) {}
            this.finished = true;
        }
    }

    public int join() throws IOException, E, InterruptedException {
        try {
            return this.join(0L);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void handleOutput(String line) throws E {
        Preconditions.checkNotNull(line);
        this.logger.log(Level.ALL, this.name, "output:", line);
        this.output.add(line);
    }

    protected void handleErrorOutput(String line) throws E {
        Preconditions.checkNotNull(line);
        this.logger.log(Level.WARNING, this.name, "error output:", line);
        this.errorOutput.add(line);
    }

    protected void handleExitCode(int code) throws E {
        if (code != 0) {
            this.logger.log(Level.WARNING, "Exit code from", this.name, "was", code);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public List<String> getOutput() {
        Preconditions.checkState(this.finished, "Cannot get output while process is not yet finished");
        return this.output;
    }

    public List<String> getErrorOutput() {
        Preconditions.checkState(this.finished, "Cannot get error output while process is not yet finished");
        return this.errorOutput;
    }
}

