/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;

abstract class AbstractImmutableMap<K, V>
implements Map<K, V> {
    AbstractImmutableMap() {
    }

    static <V> Function<Map.Entry<?, V>, V> getValueFunction() {
        return new Function<Map.Entry<?, V>, V>(){

            @Override
            public V apply(@Nonnull Map.Entry<?, V> input) {
                return input.getValue();
            }
        };
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putAll(Map<? extends K, ? extends V> pM) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V remove(Object pKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object pValue) {
        return this.values().contains(pValue);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public Collection<V> values() {
        return Collections2.transform(this.entrySet(), AbstractImmutableMap.getValueFunction());
    }

    @Override
    public boolean equals(Object pObj) {
        if (pObj instanceof Map) {
            return this.entrySet().equals(((Map)pObj).entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Joiner.on(", ").withKeyValueSeparator("=").useForNull("null").appendTo(sb, (Map<?, ?>)this);
        sb.append('}');
        return sb.toString();
    }
}

