/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Chars;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections3 {
    private Collections3() {
    }

    public static <V> SortedMap<String, V> subMapWithPrefix(SortedMap<String, V> map, String prefix) {
        Preconditions.checkNotNull(map);
        Preconditions.checkArgument(!prefix.isEmpty());
        String end = Collections3.incrementStringByOne(prefix);
        return map.subMap(prefix, end);
    }

    public static SortedSet<String> subSetWithPrefix(SortedSet<String> set, String prefix) {
        Preconditions.checkNotNull(set);
        Preconditions.checkArgument(!prefix.isEmpty());
        String end = Collections3.incrementStringByOne(prefix);
        return set.subSet(prefix, end);
    }

    private static String incrementStringByOne(String prefix) {
        StringBuilder end = new StringBuilder(prefix);
        int lastPos = end.length() - 1;
        end.setCharAt(lastPos, Chars.checkedCast(end.charAt(lastPos) + '\u0001'));
        return end.toString();
    }
}

