/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingSortedMap;
import com.google.common.collect.ForwardingSortedSet;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.sosy_lab.common.collect.PersistentSortedMap;

public class CopyOnWriteSortedMap<K, V>
extends ForwardingSortedMap<K, V> {
    private final AtomicReference<PersistentSortedMap<K, V>> map;

    private CopyOnWriteSortedMap(PersistentSortedMap<K, V> pMap) {
        this.map = new AtomicReference<PersistentSortedMap<K, PersistentSortedMap<K, V>>>(Preconditions.checkNotNull(pMap));
    }

    public static <K extends Comparable<? super K>, V> CopyOnWriteSortedMap<K, V> copyOf(PersistentSortedMap<K, V> pMap) {
        return new CopyOnWriteSortedMap<K, V>(pMap);
    }

    public static <K extends Comparable<? super K>, V> CopyOnWriteSortedMap<K, V> copyOf(CopyOnWriteSortedMap<K, V> pMap) {
        return new CopyOnWriteSortedMap<K, V>(pMap.map.get());
    }

    @Override
    protected SortedMap<K, V> delegate() {
        return this.map.get();
    }

    public PersistentSortedMap<K, V> getSnapshot() {
        return this.map.get();
    }

    @Override
    public V put(K pKey, V pValue) {
        PersistentSortedMap<K, V> oldMap = this.put0(pKey, pValue);
        return oldMap.get(pKey);
    }

    private PersistentSortedMap<K, V> put0(K pKey, V pValue) {
        PersistentSortedMap<K, V> newMap;
        PersistentSortedMap<K, V> oldMap;
        while (!this.map.compareAndSet(oldMap = this.map.get(), newMap = oldMap.putAndCopy(pKey, pValue))) {
        }
        return oldMap;
    }

    @Override
    @Nullable
    public V remove(Object pKey) {
        PersistentSortedMap<K, V> newMap;
        PersistentSortedMap<K, V> oldMap;
        do {
            if ((oldMap = this.map.get()).containsKey(pKey)) continue;
            return null;
        } while (!this.map.compareAndSet(oldMap, newMap = oldMap.removeAndCopy(pKey)));
        return oldMap.get(pKey);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> pMap) {
        for (Map.Entry<K, V> entry : pMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.set(this.map.get().empty());
    }

    @Override
    public SortedSet<Map.Entry<K, V>> entrySet() {
        return new ForwardingSortedSet<Map.Entry<K, V>>(){

            @Override
            protected SortedSet<Map.Entry<K, V>> delegate() {
                return ((PersistentSortedMap)CopyOnWriteSortedMap.this.map.get()).entrySet();
            }
        };
    }

    @Override
    public SortedSet<K> keySet() {
        return new ForwardingSortedSet<K>(){

            @Override
            protected SortedSet<K> delegate() {
                return ((PersistentSortedMap)CopyOnWriteSortedMap.this.map.get()).keySet();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new ForwardingCollection<V>(){

            @Override
            protected Collection<V> delegate() {
                return ((PersistentSortedMap)CopyOnWriteSortedMap.this.map.get()).values();
            }
        };
    }

    @Override
    public SortedMap<K, V> headMap(final K pToKey) {
        Preconditions.checkNotNull(pToKey);
        return new ForwardingSortedMap<K, V>(){

            @Override
            protected SortedMap<K, V> delegate() {
                return ((PersistentSortedMap)CopyOnWriteSortedMap.this.map.get()).headMap(pToKey);
            }
        };
    }

    @Override
    public SortedMap<K, V> tailMap(final K pFromKey) {
        Preconditions.checkNotNull(pFromKey);
        return new ForwardingSortedMap<K, V>(){

            @Override
            protected SortedMap<K, V> delegate() {
                return ((PersistentSortedMap)CopyOnWriteSortedMap.this.map.get()).tailMap(pFromKey);
            }
        };
    }

    @Override
    public SortedMap<K, V> subMap(final K pFromKey, final K pToKey) {
        Preconditions.checkNotNull(pFromKey);
        Preconditions.checkNotNull(pToKey);
        return new ForwardingSortedMap<K, V>(){

            @Override
            protected SortedMap<K, V> delegate() {
                return ((PersistentSortedMap)CopyOnWriteSortedMap.this.map.get()).subMap(pFromKey, pToKey);
            }
        };
    }
}

