/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import com.google.common.collect.UnmodifiableIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sosy_lab.common.collect.AbstractImmutableSortedMap;
import org.sosy_lab.common.collect.OurSortedMap;
import org.sosy_lab.common.collect.PersistentSortedMap;

public final class PathCopyingPersistentTreeMap<K extends Comparable<? super K>, V>
extends AbstractImmutableSortedMap<K, V>
implements PersistentSortedMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1041711151457528188L;
    private static final PathCopyingPersistentTreeMap<?, ?> EMPTY_MAP = new PathCopyingPersistentTreeMap(null);
    @Nullable
    private final Node<K, V> root;
    @Nullable
    private transient EntrySet<K, V> entrySet;

    public static <K extends Comparable<? super K>, V> PersistentSortedMap<K, V> of() {
        return EMPTY_MAP;
    }

    public static <K extends Comparable<? super K>, V> PersistentSortedMap<K, V> copyOf(Map<K, V> map) {
        Preconditions.checkNotNull(map);
        if (map instanceof PathCopyingPersistentTreeMap) {
            return (PathCopyingPersistentTreeMap)map;
        }
        PersistentSortedMap<K, V> result = PathCopyingPersistentTreeMap.of();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result = result.putAndCopy(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private PathCopyingPersistentTreeMap(@Nullable Node<K, V> pRoot) {
        this.root = pRoot;
    }

    @Nullable
    private static <K extends Comparable<? super K>, V> Node<K, V> findNode(Object key, Node<K, V> root) {
        Preconditions.checkNotNull(key);
        return PathCopyingPersistentTreeMap.findNode((Comparable)key, root);
    }

    @Nullable
    private static <K extends Comparable<? super K>, V> Node<K, V> findNode(K key, Node<K, V> root) {
        Preconditions.checkNotNull(key);
        Node current = root;
        while (current != null) {
            int comp = key.compareTo(current.getKey());
            if (comp < 0) {
                current = current.left;
                continue;
            }
            if (comp > 0) {
                current = current.right;
                continue;
            }
            return current;
        }
        return null;
    }

    private static <K extends Comparable<? super K>, V> Node<K, V> findSmallestNode(Node<K, V> root) {
        Node current = root;
        while (current.left != null) {
            current = current.left;
        }
        return current;
    }

    private static <K extends Comparable<? super K>, V> Node<K, V> findLargestNode(Node<K, V> root) {
        Node current = root;
        while (current.right != null) {
            current = current.right;
        }
        return current;
    }

    @Nullable
    private static <K extends Comparable<? super K>, V> Node<K, V> findNextGreaterOrEqualNode(K key, Node<K, V> root) {
        Preconditions.checkNotNull(key);
        Node result = null;
        Node current = root;
        while (current != null) {
            int comp = key.compareTo(current.getKey());
            if (comp < 0) {
                result = current;
                current = current.left;
            } else if (comp > 0) {
                current = current.right;
            } else {
                return current;
            }
            if (current != null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private static <K extends Comparable<? super K>, V> Node<K, V> findNextStrictlySmallerNode(K key, Node<K, V> root) {
        Preconditions.checkNotNull(key);
        Node result = null;
        Node current = root;
        while (current != null) {
            int comp = key.compareTo(current.getKey());
            if (comp < 0) {
                current = current.left;
            } else if (comp > 0) {
                result = current;
                current = current.right;
            } else {
                if (current.left == null) {
                    return result;
                }
                return PathCopyingPersistentTreeMap.findLargestNode(current.left);
            }
            if (current != null) continue;
            return result;
        }
        return null;
    }

    private static <K extends Comparable<? super K>, V> int checkAssertions(Node<K, V> current) throws IllegalStateException {
        if (current == null) {
            return 0;
        }
        if (((Node)current).left != null) {
            Preconditions.checkState(((Comparable)current.getKey()).compareTo(((Node)current).left.getKey()) > 0, "Tree has left child that is not smaller.");
        }
        if (((Node)current).right != null) {
            Preconditions.checkState(((Comparable)current.getKey()).compareTo(((Node)current).right.getKey()) < 0, "Tree has right child that is not bigger.");
        }
        Preconditions.checkState(!Node.isRed(((Node)current).right), "LLRB has red right child");
        Preconditions.checkState(!Node.isRed(current) || !Node.isRed(((Node)current).left) || !Node.isRed(((Node)current).left.left), "LLRB has three red nodes in a row.");
        int leftBlackHeight = PathCopyingPersistentTreeMap.checkAssertions(((Node)current).left);
        int rightBlackHeight = PathCopyingPersistentTreeMap.checkAssertions(((Node)current).right);
        Preconditions.checkState(leftBlackHeight == rightBlackHeight, "Black path length on left is " + leftBlackHeight + " and on right is " + rightBlackHeight);
        int blackHeight = leftBlackHeight;
        if (current.isBlack()) {
            ++blackHeight;
        }
        return blackHeight;
    }

    @VisibleForTesting
    void checkAssertions() throws IllegalStateException {
        PathCopyingPersistentTreeMap.checkAssertions(this.root);
    }

    private PersistentSortedMap<K, V> mapFromTree(Node<K, V> newRoot) {
        if (newRoot == this.root) {
            return this;
        }
        if (newRoot == null) {
            return PathCopyingPersistentTreeMap.of();
        }
        newRoot = newRoot.withColor(false);
        return new PathCopyingPersistentTreeMap<K, V>(newRoot);
    }

    @Override
    public PersistentSortedMap<K, V> putAndCopy(K key, V value) {
        return this.mapFromTree(PathCopyingPersistentTreeMap.putAndCopy0((Comparable)Preconditions.checkNotNull(key), value, this.root));
    }

    private static <K extends Comparable<? super K>, V> Node<K, V> putAndCopy0(K key, V value, Node<K, V> current) {
        if (current == null) {
            return new Node<K, V>(key, value);
        }
        int comp = key.compareTo(current.getKey());
        if (comp < 0) {
            Node<K, V> newLeft = PathCopyingPersistentTreeMap.putAndCopy0(key, value, ((Node)current).left);
            current = current.withLeftChild(newLeft);
        } else if (comp > 0) {
            Node<K, V> newRight = PathCopyingPersistentTreeMap.putAndCopy0(key, value, ((Node)current).right);
            current = current.withRightChild(newRight);
        } else {
            current = new Node<K, V>(key, value, ((Node)current).left, ((Node)current).right, current.getColor());
        }
        return PathCopyingPersistentTreeMap.restoreInvariants(current);
    }

    @Override
    public PersistentSortedMap<K, V> removeAndCopy(Object key) {
        if (this.isEmpty()) {
            return this;
        }
        return this.mapFromTree(PathCopyingPersistentTreeMap.removeAndCopy0((Comparable)Preconditions.checkNotNull(key), this.root));
    }

    @Nullable
    private static <K extends Comparable<? super K>, V> Node<K, V> removeAndCopy0(K key, Node<K, V> current) {
        int comp = key.compareTo(current.getKey());
        if (comp < 0) {
            if (((Node)current).left == null) {
                return current;
            }
            if (!Node.isRed(((Node)current).left) && !Node.isRed(((Node)current).left.left)) {
                current = PathCopyingPersistentTreeMap.makeLeftRed(current);
            }
            Node<K, V> newLeft = PathCopyingPersistentTreeMap.removeAndCopy0(key, ((Node)current).left);
            current = current.withLeftChild(newLeft);
        } else {
            if (comp > 0 && ((Node)current).right == null) {
                return current;
            }
            if (Node.isRed(((Node)current).left)) {
                current = PathCopyingPersistentTreeMap.rotateClockwise(current);
                comp = key.compareTo(current.getKey());
                assert (comp >= 0);
            }
            if (comp == 0 && ((Node)current).right == null) {
                assert (((Node)current).left == null);
                return null;
            }
            if (!Node.isRed(((Node)current).right) && !Node.isRed(((Node)current).right.left)) {
                current = PathCopyingPersistentTreeMap.makeRightRed(current);
                comp = key.compareTo(current.getKey());
                assert (comp >= 0);
            }
            if (comp == 0) {
                Node successor = ((Node)current).right;
                while (successor.left != null) {
                    successor = successor.left;
                }
                Node<K, V> newRight = PathCopyingPersistentTreeMap.removeMininumNodeInTree(((Node)current).right);
                current = new Node(successor.getKey(), successor.getValue(), ((Node)current).left, newRight, current.getColor());
            } else {
                Node<K, V> newRight = PathCopyingPersistentTreeMap.removeAndCopy0(key, ((Node)current).right);
                current = current.withRightChild(newRight);
            }
        }
        return PathCopyingPersistentTreeMap.restoreInvariants(current);
    }

    @Nullable
    private static <K, V> Node<K, V> removeMininumNodeInTree(Node<K, V> current) {
        if (((Node)current).left == null) {
            return null;
        }
        if (!Node.isRed(((Node)current).left) && !Node.isRed(((Node)current).left.left)) {
            current = PathCopyingPersistentTreeMap.makeLeftRed(current);
        }
        Node<K, V> newLeft = PathCopyingPersistentTreeMap.removeMininumNodeInTree(((Node)current).left);
        current = current.withLeftChild(newLeft);
        return PathCopyingPersistentTreeMap.restoreInvariants(current);
    }

    private static <K, V> Node<K, V> restoreInvariants(Node<K, V> current) {
        if (Node.isRed(((Node)current).right)) {
            current = PathCopyingPersistentTreeMap.rotateCounterclockwise(current);
        }
        if (Node.isRed(((Node)current).left) && Node.isRed(((Node)current).left.left)) {
            current = PathCopyingPersistentTreeMap.rotateClockwise(current);
        }
        if (Node.isRed(((Node)current).left) && Node.isRed(((Node)current).right)) {
            current = PathCopyingPersistentTreeMap.colorFlip(current);
        }
        return current;
    }

    private static <K, V> Node<K, V> colorFlip(Node<K, V> current) {
        Node newLeft = ((Node)current).left.withColor(!((Node)current).left.getColor());
        Node newRight = ((Node)current).right.withColor(!((Node)current).right.getColor());
        return new Node(current.getKey(), current.getValue(), newLeft, newRight, !current.getColor());
    }

    private static <K, V> Node<K, V> rotateCounterclockwise(Node<K, V> current) {
        Node crossoverNode = ((Node)current).right.left;
        Node newLeft = new Node(current.getKey(), current.getValue(), ((Node)current).left, crossoverNode, true);
        return new Node(((Node)current).right.getKey(), ((Node)current).right.getValue(), newLeft, ((Node)current).right.right, current.getColor());
    }

    private static <K, V> Node<K, V> rotateClockwise(Node<K, V> current) {
        Node crossOverNode = ((Node)current).left.right;
        Node newRight = new Node(current.getKey(), current.getValue(), crossOverNode, ((Node)current).right, true);
        return new Node(((Node)current).left.getKey(), ((Node)current).left.getValue(), ((Node)current).left.left, newRight, current.getColor());
    }

    private static <K, V> Node<K, V> makeLeftRed(Node<K, V> current) {
        if (Node.isRed(((Node)(current = PathCopyingPersistentTreeMap.colorFlip(current))).right.left)) {
            Node<K, V> newRight = PathCopyingPersistentTreeMap.rotateClockwise(((Node)current).right);
            current = new Node(current.getKey(), current.getValue(), ((Node)current).left, newRight, current.getColor());
            current = PathCopyingPersistentTreeMap.rotateCounterclockwise(current);
            current = PathCopyingPersistentTreeMap.colorFlip(current);
        }
        return current;
    }

    private static <K, V> Node<K, V> makeRightRed(Node<K, V> current) {
        if (Node.isRed(((Node)(current = PathCopyingPersistentTreeMap.colorFlip(current))).left.left)) {
            current = PathCopyingPersistentTreeMap.rotateClockwise(current);
            current = PathCopyingPersistentTreeMap.colorFlip(current);
        }
        return current;
    }

    @Override
    public PersistentSortedMap<K, V> empty() {
        return PathCopyingPersistentTreeMap.of();
    }

    @Override
    public boolean containsKey(Object pObj) {
        return PathCopyingPersistentTreeMap.findNode(pObj, this.root) != null;
    }

    @Override
    public V get(Object pObj) {
        Node<Object, V> node = PathCopyingPersistentTreeMap.findNode(pObj, this.root);
        return node == null ? null : (V)node.getValue();
    }

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public SortedSet<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this.root);
        }
        return this.entrySet;
    }

    @Override
    public SortedMap<K, V> subMap(K pFromKey, K pToKey) {
        Preconditions.checkNotNull(pFromKey);
        Preconditions.checkNotNull(pToKey);
        return PartialSortedMap.create(this.root, pFromKey, pToKey);
    }

    @Override
    public SortedMap<K, V> headMap(K pToKey) {
        Preconditions.checkNotNull(pToKey);
        return PartialSortedMap.create(this.root, null, pToKey);
    }

    @Override
    public SortedMap<K, V> tailMap(K pFromKey) {
        Preconditions.checkNotNull(pFromKey);
        return PartialSortedMap.create(this.root, pFromKey, null);
    }

    private static class PartialSortedMap<K extends Comparable<? super K>, V>
    extends AbstractImmutableSortedMap<K, V>
    implements OurSortedMap<K, V> {
        private final Node<K, V> root;
        @Nullable
        private final K fromKey;
        @Nullable
        private final K toKey;
        @Nullable
        private transient SortedSet<Map.Entry<K, V>> entrySet;

        static <K extends Comparable<? super K>, V> OurSortedMap<K, V> create(Node<K, V> pRoot, @Nullable K pFromKey, @Nullable K pToKey) {
            Node<K, V> root;
            Preconditions.checkArgument(pFromKey != null || pToKey != null);
            if (pFromKey != null && pToKey != null) {
                int comp = pFromKey.compareTo(pToKey);
                if (comp == 0) {
                    return OurSortedMap.EmptyImmutableOurSortedMap.of();
                }
                Preconditions.checkArgument(comp < 0, "fromKey > toKey");
            }
            if ((root = PartialSortedMap.findBestRoot(pRoot, pFromKey, pToKey)) == null) {
                return OurSortedMap.EmptyImmutableOurSortedMap.of();
            }
            Object fromKey = pFromKey;
            Node lowestNode = null;
            if (pFromKey != null) {
                lowestNode = PathCopyingPersistentTreeMap.findNextGreaterOrEqualNode(pFromKey, root);
                if (lowestNode == null) {
                    return OurSortedMap.EmptyImmutableOurSortedMap.of();
                }
                fromKey = (Comparable)lowestNode.getKey();
            }
            Node highestNode = null;
            if (pToKey != null && (highestNode = PathCopyingPersistentTreeMap.findNextStrictlySmallerNode(pToKey, root)) == null) {
                return OurSortedMap.EmptyImmutableOurSortedMap.of();
            }
            if (pFromKey != null && pToKey != null) {
                assert (lowestNode != null && highestNode != null);
                if (((Comparable)lowestNode.getKey()).compareTo(highestNode.getKey()) > 0) {
                    return OurSortedMap.EmptyImmutableOurSortedMap.of();
                }
            }
            return new PartialSortedMap<K, V>(root, fromKey, pToKey);
        }

        @Nullable
        private static <K extends Comparable<? super K>, V> Node<K, V> findBestRoot(@Nullable Node<K, V> pRoot, @Nullable K pFromKey, @Nullable K pToKey) {
            Node current = pRoot;
            while (current != null) {
                if (pFromKey != null && ((Comparable)current.getKey()).compareTo(pFromKey) < 0) {
                    current = current.right;
                    continue;
                }
                if (pToKey != null && ((Comparable)current.getKey()).compareTo(pToKey) >= 0) {
                    current = current.left;
                    continue;
                }
                return current;
            }
            return null;
        }

        private PartialSortedMap(Node<K, V> pRoot, @Nullable K pLowKey, @Nullable K pHighKey) {
            this.root = pRoot;
            this.fromKey = pLowKey;
            this.toKey = pHighKey;
            assert (this.root != null);
            assert (pLowKey == null || this.containsKey(pLowKey));
            assert (pHighKey == null || this.containsKey(PathCopyingPersistentTreeMap.findNextStrictlySmallerNode(pHighKey, pRoot).getKey()));
        }

        private boolean inRange(K key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        private boolean tooLow(K key) {
            return this.fromKey != null && key.compareTo(this.fromKey) < 0;
        }

        private boolean tooHigh(K key) {
            return this.toKey != null && key.compareTo(this.toKey) >= 0;
        }

        @Override
        public boolean containsKey(Object pKey) {
            Comparable key = (Comparable)Preconditions.checkNotNull(pKey);
            return this.inRange(key) && PathCopyingPersistentTreeMap.findNode(key, this.root) != null;
        }

        @Override
        public V get(Object pKey) {
            Comparable key = (Comparable)Preconditions.checkNotNull(pKey);
            if (!this.inRange(key)) {
                return null;
            }
            Node node = PathCopyingPersistentTreeMap.findNode(key, this.root);
            return node == null ? null : (V)node.getValue();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public SortedSet<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new PartialEntrySet();
            }
            return this.entrySet;
        }

        @Override
        public OurSortedMap<K, V> subMap(K pFromKey, K pToKey) {
            Preconditions.checkNotNull(pFromKey);
            Preconditions.checkNotNull(pToKey);
            Preconditions.checkArgument(this.inRange(pFromKey));
            Preconditions.checkArgument(this.inRange(pToKey));
            return PartialSortedMap.create(this.root, pFromKey, pToKey);
        }

        @Override
        public OurSortedMap<K, V> headMap(K pToKey) {
            Preconditions.checkNotNull(pToKey);
            Preconditions.checkArgument(this.inRange(pToKey));
            return PartialSortedMap.create(this.root, this.fromKey, pToKey);
        }

        @Override
        public OurSortedMap<K, V> tailMap(K pFromKey) {
            Preconditions.checkNotNull(pFromKey);
            Preconditions.checkArgument(this.inRange(pFromKey));
            return PartialSortedMap.create(this.root, pFromKey, this.toKey);
        }

        private class PartialEntrySet
        extends AbstractSet<Map.Entry<K, V>>
        implements SortedSet<Map.Entry<K, V>> {
            private transient int size;

            private PartialEntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return EntryInOrderIterator.createWithBounds(PartialSortedMap.this.root, PartialSortedMap.this.fromKey, PartialSortedMap.this.toKey);
            }

            @Override
            public boolean contains(Object pO) {
                if (!(pO instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry other = (Map.Entry)pO;
                if (!PartialSortedMap.this.inRange((Comparable)other.getKey())) {
                    return false;
                }
                Node thisNode = PathCopyingPersistentTreeMap.findNode(other.getKey(), PartialSortedMap.this.root);
                return thisNode != null && Objects.equals(thisNode.getValue(), other.getValue());
            }

            @Override
            public boolean containsAll(Collection<?> pC) {
                if (pC.size() > this.size()) {
                    return false;
                }
                return super.containsAll(pC);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public int size() {
                if (this.size == 0) {
                    this.size = Iterators.size(this.iterator());
                }
                return this.size;
            }

            @Override
            public Map.Entry<K, V> first() {
                if (PartialSortedMap.this.fromKey == null) {
                    return PathCopyingPersistentTreeMap.findSmallestNode(PartialSortedMap.this.root);
                }
                return PathCopyingPersistentTreeMap.findNextGreaterOrEqualNode(PartialSortedMap.this.fromKey, PartialSortedMap.this.root);
            }

            @Override
            public Map.Entry<K, V> last() {
                if (PartialSortedMap.this.toKey == null) {
                    return PathCopyingPersistentTreeMap.findLargestNode(PartialSortedMap.this.root);
                }
                return PathCopyingPersistentTreeMap.findNextStrictlySmallerNode(PartialSortedMap.this.toKey, PartialSortedMap.this.root);
            }

            @Override
            public Comparator<? super Map.Entry<K, V>> comparator() {
                return Ordering.natural().onResultOf(Node.getKeyFunction());
            }

            @Override
            public SortedSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> pFromElement, Map.Entry<K, V> pToElement) {
                return PartialSortedMap.this.subMap((Comparable)pFromElement.getKey(), (Comparable)pToElement.getKey()).entrySet();
            }

            @Override
            public SortedSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> pToElement) {
                return PartialSortedMap.this.headMap((Comparable)pToElement.getKey()).entrySet();
            }

            @Override
            public SortedSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> pFromElement) {
                return PartialSortedMap.this.tailMap((Comparable)pFromElement.getKey()).entrySet();
            }
        }
    }

    private static class EntryInOrderIterator<K extends Comparable<? super K>, V>
    extends UnmodifiableIterator<Map.Entry<K, V>> {
        private final Deque<Node<K, V>> stack = new ArrayDeque<Node<K, V>>();
        @Nullable
        private final K highKey;

        static <K extends Comparable<? super K>, V> Iterator<Map.Entry<K, V>> create(@Nullable Node<K, V> root) {
            if (root == null) {
                return Collections.emptyIterator();
            }
            return new EntryInOrderIterator<Object, V>(root, null, null);
        }

        static <K extends Comparable<? super K>, V> Iterator<Map.Entry<K, V>> createWithBounds(@Nullable Node<K, V> root, @Nullable K pFromKey, @Nullable K pToKey) {
            if (root == null) {
                return Collections.emptyIterator();
            }
            return new EntryInOrderIterator<K, V>(root, pFromKey, pToKey);
        }

        private EntryInOrderIterator(Node<K, V> root, @Nullable K pLowKey, @Nullable K pHighKey) {
            this.highKey = pHighKey;
            if (pLowKey == null) {
                this.pushLeftMostNodesOnStack(root);
            } else {
                this.pushNodesToKeyOnStack(root, pLowKey);
            }
            this.stopFurtherIterationIfOutOfRange();
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        private void pushLeftMostNodesOnStack(Node<K, V> current) {
            while (current.left != null) {
                this.stack.push(current);
                current = current.left;
            }
            this.stack.push(current);
        }

        private void pushNodesToKeyOnStack(Node<K, V> current, K key) {
            while (current != null) {
                int comp = key.compareTo(current.getKey());
                if (comp < 0) {
                    this.stack.push(current);
                    current = current.left;
                    continue;
                }
                if (comp > 0) {
                    current = current.right;
                    continue;
                }
                this.stack.push(current);
                return;
            }
            throw new AssertionError((Object)"PartialEntryInOrderIterator created with lower bound that is not in map");
        }

        private void stopFurtherIterationIfOutOfRange() {
            if (this.highKey != null && !this.stack.isEmpty() && ((Comparable)this.stack.peek().getKey()).compareTo(this.highKey) >= 0) {
                this.stack.clear();
            }
        }

        @Override
        public Map.Entry<K, V> next() {
            Node<K, V> current = this.stack.pop();
            if (((Node)current).right != null) {
                this.pushLeftMostNodesOnStack(((Node)current).right);
            }
            this.stopFurtherIterationIfOutOfRange();
            return current;
        }
    }

    private static final class EntrySet<K extends Comparable<? super K>, V>
    extends AbstractSet<Map.Entry<K, V>>
    implements SortedSet<Map.Entry<K, V>> {
        @Nullable
        private final Node<K, V> root;
        private transient int size = -1;

        private EntrySet(Node<K, V> pRoot) {
            this.root = pRoot;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return EntryInOrderIterator.create(this.root);
        }

        @Override
        public boolean contains(Object pO) {
            if (!(pO instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)pO;
            Node thisNode = PathCopyingPersistentTreeMap.findNode(other.getKey(), this.root);
            return thisNode != null && Objects.equals(thisNode.getValue(), other.getValue());
        }

        @Override
        public boolean containsAll(Collection<?> pC) {
            if (pC instanceof EntrySet) {
                EntrySet other = (EntrySet)pC;
                if (this.root == other.root) {
                    return true;
                }
            }
            if (pC.size() > this.size()) {
                return false;
            }
            return super.containsAll(pC);
        }

        private boolean containsAll(EntrySet<?, ?> other) {
            if (Math.pow(2.0, this.size()) >= Math.pow(this.size(), other.size())) {
                return super.containsAll(other);
            }
            Iterator<Map.Entry<K, V>> thisIt = this.iterator();
            Iterator<Map.Entry<?, ?>> otherIt = other.iterator();
            Map.Entry<?, ?> otherEntry = null;
            while (thisIt.hasNext() && otherIt.hasNext()) {
                int comp;
                Map.Entry<K, V> thisEntry = thisIt.next();
                if (otherEntry == null) {
                    otherEntry = otherIt.next();
                }
                if ((comp = ((Comparable)thisEntry.getKey()).compareTo((Comparable)otherEntry.getKey())) < 0) continue;
                if (comp > 0) {
                    return false;
                }
                if (!Objects.equals(thisEntry.getKey(), otherEntry.getKey())) {
                    return false;
                }
                otherEntry = null;
            }
            return !otherIt.hasNext();
        }

        @Override
        public int size() {
            if (this.size < 0) {
                this.size = Node.countNodes(this.root);
            }
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.root == null;
        }

        @Override
        public Map.Entry<K, V> first() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            return PathCopyingPersistentTreeMap.findSmallestNode(this.root);
        }

        @Override
        public Map.Entry<K, V> last() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            return PathCopyingPersistentTreeMap.findLargestNode(this.root);
        }

        @Override
        public boolean equals(Object pO) {
            if (pO instanceof EntrySet) {
                EntrySet other = (EntrySet)pO;
                if (this.root == other.root) {
                    return true;
                }
                if (this.size() != other.size()) {
                    return false;
                }
                return Iterables.elementsEqual(this, other);
            }
            return super.equals(pO);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public Comparator<? super Map.Entry<K, V>> comparator() {
            return Ordering.natural().onResultOf(Node.getKeyFunction());
        }

        @Override
        public SortedSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> pFromElement, Map.Entry<K, V> pToElement) {
            Comparable fromKey = (Comparable)pFromElement.getKey();
            Comparable toKey = (Comparable)pToElement.getKey();
            Preconditions.checkNotNull(fromKey);
            Preconditions.checkNotNull(toKey);
            return PartialSortedMap.create(this.root, fromKey, toKey).entrySet();
        }

        @Override
        public SortedSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> pToElement) {
            Comparable toKey = (Comparable)pToElement.getKey();
            Preconditions.checkNotNull(toKey);
            return PartialSortedMap.create(this.root, null, toKey).entrySet();
        }

        @Override
        public SortedSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> pFromElement) {
            Comparable fromKey = (Comparable)pFromElement.getKey();
            Preconditions.checkNotNull(fromKey);
            return PartialSortedMap.create(this.root, fromKey, null).entrySet();
        }
    }

    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="Inherits equals() according to specification.")
    private static final class Node<K, V>
    extends AbstractMap.SimpleImmutableEntry<K, V> {
        private static final boolean RED = true;
        private static final boolean BLACK = false;
        private static final long serialVersionUID = -7393505826652634501L;
        @Nullable
        private final Node<K, V> left;
        @Nullable
        private final Node<K, V> right;
        private final boolean isRed;

        Node(K pKey, V pValue) {
            super(pKey, pValue);
            this.left = null;
            this.right = null;
            this.isRed = true;
        }

        Node(K pKey, V pValue, Node<K, V> pLeft, Node<K, V> pRight, boolean pRed) {
            super(pKey, pValue);
            this.left = pLeft;
            this.right = pRight;
            this.isRed = pRed;
        }

        boolean isLeaf() {
            return this.left == null && this.right == null;
        }

        boolean isRed() {
            return this.isRed;
        }

        boolean isBlack() {
            return !this.isRed;
        }

        boolean getColor() {
            return this.isRed;
        }

        static boolean isRed(@Nullable Node<?, ?> n) {
            return n != null && n.isRed;
        }

        static boolean isBlack(@Nullable Node<?, ?> n) {
            return n != null && n.isBlack();
        }

        Node<K, V> withColor(boolean color) {
            if (this.isRed == color) {
                return this;
            }
            return new Node(this.getKey(), this.getValue(), this.left, this.right, color);
        }

        Node<K, V> withLeftChild(Node<K, V> newLeft) {
            if (newLeft == this.left) {
                return this;
            }
            return new Node(this.getKey(), this.getValue(), newLeft, this.right, this.isRed);
        }

        Node<K, V> withRightChild(Node<K, V> newRight) {
            if (newRight == this.right) {
                return this;
            }
            return new Node(this.getKey(), this.getValue(), this.left, newRight, this.isRed);
        }

        static int countNodes(@Nullable Node<?, ?> n) {
            if (n == null) {
                return 0;
            }
            return Node.countNodes(n.left) + 1 + Node.countNodes(n.right);
        }

        static <K> Function<Map.Entry<K, ?>, K> getKeyFunction() {
            return new Function<Map.Entry<K, ?>, K>(){

                @Override
                public K apply(@Nonnull Map.Entry<K, ?> input) {
                    return input.getKey();
                }
            };
        }
    }
}

