/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.concurrency;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import org.sosy_lab.common.concurrency.CatchSecurityViolationThreadFactoryBuilder;

public class Threads {
    @Nullable
    private static ThreadFactory factory;

    private Threads() {
    }

    public static Thread newThread(Runnable r) {
        return Threads.newThread(r, null, null, null);
    }

    public static Thread newThread(Runnable r, String name) {
        return Threads.newThread(r, Preconditions.checkNotNull(name), null, null);
    }

    public static Thread newThread(Runnable r, String name, boolean daemon) {
        return Threads.newThread(r, Preconditions.checkNotNull(name), daemon, null);
    }

    public static Thread newThread(Runnable r, @Nullable String name, @Nullable Boolean daemon, @Nullable Integer priority) {
        Preconditions.checkNotNull(r);
        CatchSecurityViolationThreadFactoryBuilder builder = Threads.threadFactoryBuilder();
        if (name != null) {
            builder.setNameFormat(name);
        }
        if (daemon != null) {
            builder.setDaemon(daemon);
        }
        if (priority != null) {
            builder.setPriority(priority);
        }
        return builder.build().newThread(r);
    }

    public static ThreadFactory threadFactory() {
        if (factory == null) {
            return Executors.defaultThreadFactory();
        }
        return factory;
    }

    public static void setThreadFactory(@Nullable ThreadFactory threadFactory) {
        factory = threadFactory;
    }

    public static CatchSecurityViolationThreadFactoryBuilder threadFactoryBuilder() {
        return new CatchSecurityViolationThreadFactoryBuilder().setThreadFactory(Threads.threadFactory());
    }
}

