/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Parser;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;

public class Builder
implements ConfigurationBuilder {
    @Nullable
    private Map<String, String> properties = null;
    @Nullable
    private Map<String, Path> sources = null;
    @Nullable
    private Configuration oldConfig = null;
    @Nullable
    private String prefix = null;
    @Nullable
    private Map<Class<?>, TypeConverter> converters = null;

    private void setupProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
            this.sources = new HashMap<String, Path>();
            if (this.oldConfig != null) {
                this.properties.putAll(this.oldConfig.properties);
                this.sources.putAll(this.oldConfig.sources);
            }
        }
    }

    @Override
    public ConfigurationBuilder setOption(String name, String value) {
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(value);
        this.setupProperties();
        this.properties.put(name, value);
        this.sources.put(name, Paths.get("manually set", new String[0]));
        return this;
    }

    @Override
    public ConfigurationBuilder clearOption(String name) {
        Preconditions.checkNotNull(name);
        this.setupProperties();
        this.properties.remove(name);
        this.sources.remove(name);
        return this;
    }

    @Override
    public ConfigurationBuilder setOptions(Map<String, String> options) {
        Preconditions.checkNotNull(options);
        this.setupProperties();
        this.properties.putAll(options);
        for (String name : options.keySet()) {
            this.sources.put(name, Paths.get("manually set", new String[0]));
        }
        return this;
    }

    @Override
    public ConfigurationBuilder setPrefix(String prefix) {
        Preconditions.checkNotNull(prefix);
        this.prefix = prefix;
        return this;
    }

    @Override
    public ConfigurationBuilder copyFrom(Configuration oldConfig) {
        Preconditions.checkNotNull(oldConfig);
        Preconditions.checkState(this.properties == null);
        Preconditions.checkState(this.sources == null);
        Preconditions.checkState(this.oldConfig == null);
        Preconditions.checkState(this.converters == null);
        this.oldConfig = oldConfig;
        return this;
    }

    @Override
    public ConfigurationBuilder copyOptionFrom(Configuration oldConfig, String option) throws IllegalArgumentException {
        Preconditions.checkNotNull(oldConfig);
        Preconditions.checkNotNull(option);
        Preconditions.checkArgument(oldConfig.properties.containsKey(option));
        this.setupProperties();
        this.properties.put(option, oldConfig.properties.get(option));
        this.sources.put(option, oldConfig.sources.get(option));
        return this;
    }

    @Override
    public ConfigurationBuilder loadFromSource(CharSource source, String basePath, String sourceName) throws IOException, InvalidConfigurationException {
        Preconditions.checkNotNull(source);
        Preconditions.checkNotNull(basePath);
        this.setupProperties();
        Pair<Map<String, String>, Map<String, Path>> content = Parser.parse(source, basePath, sourceName);
        this.properties.putAll(content.getFirst());
        this.sources.putAll(content.getSecond());
        return this;
    }

    @Override
    @Deprecated
    public ConfigurationBuilder loadFromStream(InputStream stream, String basePath, String sourceName) throws IOException, InvalidConfigurationException {
        Preconditions.checkNotNull(stream);
        Preconditions.checkNotNull(basePath);
        byte[] rawContent = ByteStreams.toByteArray(stream);
        CharSource source = ByteSource.wrap(rawContent).asCharSource(StandardCharsets.UTF_8);
        return this.loadFromSource(source, basePath, sourceName);
    }

    @Override
    @Deprecated
    public ConfigurationBuilder loadFromStream(InputStream stream) throws IOException, InvalidConfigurationException {
        return this.loadFromStream(stream, "", "unknown source");
    }

    @Override
    public ConfigurationBuilder loadFromFile(@Nullable String filename) throws IOException, InvalidConfigurationException {
        return this.loadFromFile(Paths.get(filename, new String[0]));
    }

    @Override
    public ConfigurationBuilder loadFromFile(Path file) throws IOException, InvalidConfigurationException {
        Preconditions.checkNotNull(file);
        if (!file.exists()) {
            throw new IOException("The file does not exist.");
        }
        this.setupProperties();
        Pair<Map<String, String>, Map<String, Path>> content = Parser.parse(file, "");
        this.properties.putAll(content.getFirst());
        this.sources.putAll(content.getSecond());
        return this;
    }

    @Override
    public ConfigurationBuilder addConverter(Class<?> cls, TypeConverter converter) {
        Preconditions.checkNotNull(cls);
        Preconditions.checkNotNull(converter);
        if (this.converters == null) {
            this.converters = Configuration.createConverterMap();
            if (this.oldConfig != null) {
                this.converters.putAll(this.oldConfig.converters);
            } else {
                this.converters.putAll(Configuration.DEFAULT_CONVERTERS);
            }
        }
        this.converters.put(cls, converter);
        return this;
    }

    @Override
    public Configuration build() throws InvalidConfigurationException {
        Set<String> newDeprecatedProperties;
        Set<String> newUnusedProperties;
        ImmutableMap<String, String> newProperties = this.properties == null ? (this.oldConfig != null ? this.oldConfig.properties : ImmutableMap.of()) : ImmutableMap.copyOf(this.properties);
        ImmutableMap<String, Path> newSources = this.sources == null ? (this.oldConfig != null ? this.oldConfig.sources : ImmutableMap.of()) : ImmutableMap.copyOf(this.sources);
        String newPrefix = this.prefix == null ? (this.oldConfig != null ? this.oldConfig.prefix : "") : this.prefix;
        ImmutableMap<Class<?>, TypeConverter> newConverters = this.converters == null ? (this.oldConfig != null ? this.oldConfig.converters : ImmutableMap.copyOf(Configuration.DEFAULT_CONVERTERS)) : ImmutableMap.copyOf(this.converters);
        if (this.oldConfig != null) {
            newUnusedProperties = this.oldConfig.unusedProperties;
            newDeprecatedProperties = this.oldConfig.deprecatedProperties;
        } else {
            newUnusedProperties = new HashSet<String>(newProperties.keySet());
            newDeprecatedProperties = new HashSet<String>(0);
        }
        Configuration newConfig = new Configuration(newProperties, newSources, newPrefix, newConverters, newUnusedProperties, newDeprecatedProperties, this.oldConfig != null ? this.oldConfig.getLogger() : null);
        newConfig.inject(newConfig);
        this.properties = null;
        this.prefix = null;
        this.oldConfig = null;
        return newConfig;
    }
}

