/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration.converters;

import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;

public class ClassTypeConverter
implements TypeConverter {
    @Override
    public Object convert(String optionName, String value, Class<?> type, Type genericType, Annotation secondaryOption, Path pSource, LogManager logger) throws InvalidConfigurationException {
        Iterable<Object> packagePrefixes = Collections.singleton(null);
        if (secondaryOption != null) {
            if (!(secondaryOption instanceof ClassOption)) {
                throw new UnsupportedOperationException("Options of type Class may not be annotated with " + secondaryOption);
            }
            packagePrefixes = Iterables.concat(packagePrefixes, Arrays.asList(((ClassOption)secondaryOption).packagePrefix()));
        }
        Class<?> targetType = Classes.getComponentType(genericType).getFirst();
        Class<?> cls = null;
        for (String string : packagePrefixes) {
            try {
                cls = Classes.forName(value, string);
            }
            catch (ClassNotFoundException _) {}
        }
        if (cls == null) {
            throw new InvalidConfigurationException("Class " + value + " specified in option " + optionName + " not found");
        }
        if (!targetType.isAssignableFrom(cls)) {
            throw new InvalidConfigurationException("Class " + value + " specified in option " + optionName + " is not an instance of " + targetType.getCanonicalName());
        }
        Classes.produceClassLoadingWarning(logger, cls, targetType);
        return cls;
    }

    @Override
    public <T> T convertDefaultValue(String pOptionName, T pValue, Class<T> pType, Type pGenericType, Annotation pSecondaryOption) {
        return pValue;
    }
}

