/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.converters.BaseTypeConverter;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;

public class IntegerTypeConverter
implements TypeConverter {
    @Override
    public Object convert(String optionName, String valueStr, Class<?> type, Type pGenericType, Annotation pOption, Path pSource, LogManager logger) throws InvalidConfigurationException {
        if (!(pOption instanceof IntegerOption)) {
            throw new UnsupportedOperationException("IntegerTypeConverter needs otions annotated with @IntegerOption");
        }
        IntegerOption option = (IntegerOption)pOption;
        assert (type.equals(Integer.class) || type.equals(Long.class));
        Object value = BaseTypeConverter.valueOf(type, optionName, valueStr);
        long n = ((Number)value).longValue();
        if (option.min() > n || n > option.max()) {
            throw new InvalidConfigurationException("Invalid value in configuration file: \"" + optionName + " = " + value + '\"' + " (not in range [" + option.min() + ", " + option.max() + "])");
        }
        return value;
    }

    @Override
    public <T> T convertDefaultValue(String pOptionName, T pValue, Class<T> pType, Type pGenericType, Annotation pSecondaryOption) {
        return pValue;
    }
}

