/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.io;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.sosy_lab.common.io.AbstractPathFactory;
import org.sosy_lab.common.io.FileSystemPath;
import org.sosy_lab.common.io.Path;

public class FileSystemPathFactory
implements AbstractPathFactory {
    @Override
    public Path getPath(@Nullable String pathName, String ... more) {
        return new FileSystemPath(pathName, more);
    }

    @Override
    public Path getTempPath(String prefix, @Nullable String suffix) throws IOException {
        Preconditions.checkNotNull(prefix);
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("The prefix must at least be three characters long.");
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        return this.getPath(File.createTempFile(prefix, suffix).getPath(), new String[0]);
    }
}

