/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.io;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.IllegalFormatException;
import java.util.concurrent.atomic.AtomicInteger;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;

public final class PathCounterTemplate {
    private final String template;
    private final AtomicInteger counter = new AtomicInteger();

    private PathCounterTemplate(String pTemplate) {
        Preconditions.checkArgument(!pTemplate.isEmpty());
        PathCounterTemplate.checkPatternValidity(pTemplate);
        this.template = pTemplate;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    private static void checkPatternValidity(String pTemplate) throws IllegalFormatException {
        String.format(pTemplate, 0);
    }

    public static PathCounterTemplate ofFormatString(String pTemplate) {
        return new PathCounterTemplate(pTemplate);
    }

    public Path getFreshPath() {
        return Paths.get(String.format(this.template, this.counter.getAndIncrement()), new String[0]);
    }

    public String getTemplate() {
        return this.template;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("template", this.template).add("counter", this.counter.get()).toString();
    }
}

