/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import org.sosy_lab.common.io.AbstractPathFactory;
import org.sosy_lab.common.io.FileSystemPathFactory;
import org.sosy_lab.common.io.Path;

public class Paths {
    @Nullable
    private static AbstractPathFactory factory = null;

    private Paths() {
    }

    public static Path get(File file) {
        return Paths.get(file.getPath(), new String[0]);
    }

    public static Path get(URI uri) {
        return Paths.get(new File(uri));
    }

    public static Path get(@Nullable String pathName, String ... more) {
        return Paths.getFactory().getPath(pathName, more);
    }

    public static void setFactory(@Nullable AbstractPathFactory pathFactory) {
        factory = pathFactory;
    }

    public static AbstractPathFactory getFactory() {
        if (factory == null) {
            factory = new FileSystemPathFactory();
        }
        return factory;
    }

    public static Path createTempPath(String prefix, @Nullable String suffix) throws IOException {
        return Paths.getFactory().getTempPath(prefix, suffix);
    }
}

