/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.log;

import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.ExtendedLogRecord;
import org.sosy_lab.common.log.LogUtils;

@Options(prefix="log")
public class ConsoleLogFormatter
extends Formatter {
    @Option(secure=true, description="use colors for log messages on console")
    private boolean useColors = true;

    public ConsoleLogFormatter(Configuration config) throws InvalidConfigurationException {
        config.inject(this);
        if (this.useColors && (System.console() == null || System.getProperty("os.name", "").startsWith("Windows"))) {
            this.useColors = false;
        }
    }

    @Override
    public String format(LogRecord lr) {
        String component;
        StringBuffer sb = new StringBuffer();
        if (this.useColors) {
            if (lr.getLevel().equals(Level.WARNING)) {
                sb.append("\u001b[1m");
            } else if (lr.getLevel().equals(Level.SEVERE)) {
                sb.append("\u001b[31;1m");
            }
        }
        sb.append(lr.getMessage());
        sb.append(" (");
        if (lr instanceof ExtendedLogRecord && !(component = ((ExtendedLogRecord)lr).getSourceComponentName()).isEmpty()) {
            sb.append(component);
            sb.append(":");
        }
        sb.append(LogUtils.extractSimpleClassName(lr));
        sb.append(".");
        sb.append(lr.getSourceMethodName());
        sb.append(", ");
        sb.append(lr.getLevel().toString());
        sb.append(")");
        if (this.useColors) {
            sb.append("\u001b[m");
        }
        sb.append("\n\n");
        return sb.toString();
    }
}

