/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.log;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;

@Options(prefix="log", description="Possible log levels in descending order \n(lower levels include higher ones):\nOFF:      no logs published\nSEVERE:   error messages\nWARNING:  warnings\nINFO:     messages\nFINE:     logs on main application level\nFINER:    logs on central CPA algorithm level\nFINEST:   logs published by specific CPAs\nALL:      debugging information\nCare must be taken with levels of FINER or lower, as output files may become quite large and memory usage might become an issue.")
final class LoggingOptions {
    @Option(secure=true, name="level", toUppercase=true, description="log level of file output")
    private Level fileLevel = Level.OFF;
    @Option(secure=true, toUppercase=true, description="log level of console output")
    private Level consoleLevel = Level.INFO;
    @Option(secure=true, toUppercase=true, description="single levels to be excluded from being logged")
    private List<Level> fileExclude = ImmutableList.of();
    @Option(secure=true, toUppercase=true, description="single levels to be excluded from being logged")
    private List<Level> consoleExclude = ImmutableList.of();
    @Option(secure=true, name="file", description="name of the log file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path outputFile = Paths.get("CPALog.txt", new String[0]);
    @Option(secure=true, description="maximum size of log output strings before they will be truncated")
    @IntegerOption(min=1L)
    private int truncateSize = 10000;

    LoggingOptions(Configuration config) throws InvalidConfigurationException {
        config.inject(this);
    }

    Level getFileLevel() {
        return this.fileLevel;
    }

    Level getConsoleLevel() {
        return this.consoleLevel;
    }

    List<Level> getFileExclude() {
        return this.fileExclude;
    }

    List<Level> getConsoleExclude() {
        return this.consoleExclude;
    }

    Path getOutputFile() {
        return this.outputFile;
    }

    int getTruncateSize() {
        return this.truncateSize;
    }
}

