/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.log;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.annotation.concurrent.GuardedBy;

public class StringBuildingLogHandler
extends Handler {
    @GuardedBy(value="this")
    private final StringBuilder sb = new StringBuilder();

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized void publish(LogRecord record) {
        String msg;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        try {
            this.sb.append(msg);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
    }

    public synchronized String getLog() {
        return this.sb.toString();
    }

    public synchronized void clear() {
        this.sb.setLength(0);
        this.sb.trimToSize();
    }
}

