/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.log;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.log.LogManager;

public enum TestLogManager implements LogManager
{
    INSTANCE;


    public static LogManager getInstance() {
        return INSTANCE;
    }

    @Override
    public LogManager withComponentName(String pName) {
        Preconditions.checkArgument(!pName.isEmpty());
        return this;
    }

    @Override
    public boolean wouldBeLogged(Level pPriority) {
        Preconditions.checkNotNull(pPriority);
        return true;
    }

    @Override
    public void log(Level pPriority, Object ... pArgs) {
        Preconditions.checkNotNull(pPriority);
        Preconditions.checkNotNull(pArgs);
        Preconditions.checkArgument(pArgs.length != 0);
        Preconditions.checkArgument(!Arrays.deepToString(pArgs).isEmpty());
    }

    @Override
    public void logf(Level pPriority, String pFormat, Object ... pArgs) {
        Preconditions.checkNotNull(pPriority);
        Preconditions.checkNotNull(pFormat);
        Preconditions.checkNotNull(pArgs);
        Preconditions.checkArgument(!String.format(pFormat, pArgs).isEmpty());
    }

    @Override
    public void logUserException(Level pPriority, Throwable pE, @Nullable String pAdditionalMessage) {
        Preconditions.checkNotNull(pPriority);
        Preconditions.checkNotNull(pE);
    }

    @Override
    public void logDebugException(Throwable pE, @Nullable String pAdditionalMessage) {
        Preconditions.checkNotNull(pE);
    }

    @Override
    public void logDebugException(Throwable pE) {
        Preconditions.checkNotNull(pE);
    }

    @Override
    public void logException(Level pPriority, Throwable pE, @Nullable String pAdditionalMessage) {
        Preconditions.checkNotNull(pPriority);
        Preconditions.checkNotNull(pE);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

