/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.time;

import com.google.common.base.Preconditions;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class TimeSpan
implements Comparable<TimeSpan> {
    private static final EnumHashBiMap<TimeUnit, String> TIME_UNITS = EnumHashBiMap.create(TimeUnit.class);
    private final long span;
    private final TimeUnit unit;

    private TimeSpan(long pSpan, TimeUnit pUnit) {
        this.span = pSpan;
        this.unit = Preconditions.checkNotNull(pUnit);
    }

    public static TimeSpan of(long pSpan, TimeUnit pUnit) {
        return new TimeSpan(pSpan, pUnit);
    }

    public static TimeSpan ofSeconds(long pSeconds) {
        return new TimeSpan(pSeconds, TimeUnit.SECONDS);
    }

    public static TimeSpan ofMillis(long pMillis) {
        return new TimeSpan(pMillis, TimeUnit.MILLISECONDS);
    }

    public static TimeSpan ofNanos(long pNanos) {
        return new TimeSpan(pNanos, TimeUnit.NANOSECONDS);
    }

    public static TimeSpan empty() {
        return new TimeSpan(0L, TimeUnit.DAYS);
    }

    public long get(TimeUnit dest) {
        return dest.convert(this.span, this.unit);
    }

    public TimeSpan to(TimeUnit dest) {
        if (dest.equals((Object)this.unit)) {
            return this;
        }
        return new TimeSpan(this.get(dest), dest);
    }

    public long asSeconds() {
        return this.get(TimeUnit.SECONDS);
    }

    public long asMillis() {
        return this.get(TimeUnit.MILLISECONDS);
    }

    public long asNanos() {
        return this.get(TimeUnit.NANOSECONDS);
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public String formatAs(TimeUnit dest) {
        if (dest.compareTo(this.unit) <= 0) {
            return this.to(dest).toString();
        }
        long scaleFactor = this.unit.convert(1L, dest);
        assert (scaleFactor > 0L);
        return String.format(Locale.US, "%9.3f%s", (double)this.span / (double)scaleFactor, TIME_UNITS.get((Object)dest));
    }

    public boolean isEmpty() {
        return this.span == 0L;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TimeSpan)) {
            return false;
        }
        TimeSpan other = (TimeSpan)obj;
        if (this.unit == other.unit) {
            return this.span == other.span;
        }
        TimeUnit leastCommonUnit = TimeSpan.leastCommonUnit(this, other);
        return this.get(leastCommonUnit) == other.get(leastCommonUnit);
    }

    public int hashCode() {
        return Longs.hashCode(this.unit.toNanos(this.span));
    }

    @Override
    public int compareTo(TimeSpan other) {
        if (this.unit == other.unit) {
            return Long.compare(this.span, other.span);
        }
        TimeUnit leastCommonUnit = TimeSpan.leastCommonUnit(this, other);
        return Long.compare(this.get(leastCommonUnit), other.get(leastCommonUnit));
    }

    private static TimeUnit leastCommonUnit(TimeSpan a, TimeSpan b) {
        return Ordering.natural().min(a.unit, b.unit);
    }

    public String toString() {
        return this.span + (String)TIME_UNITS.get((Object)this.unit);
    }

    public static TimeSpan sum(TimeSpan a, TimeSpan b) {
        TimeUnit leastCommonUnit = TimeSpan.leastCommonUnit(a, b);
        return new TimeSpan(a.get(leastCommonUnit) + b.get(leastCommonUnit), leastCommonUnit);
    }

    public static TimeSpan sum(TimeSpan ... t) {
        Preconditions.checkArgument(t.length > 0);
        TimeSpan result = t[0];
        for (int i = 1; i < t.length; ++i) {
            result = TimeSpan.sum(result, t[i]);
        }
        return result;
    }

    static {
        TIME_UNITS.put(TimeUnit.NANOSECONDS, "ns");
        TIME_UNITS.put(TimeUnit.MICROSECONDS, "\u00b5s");
        TIME_UNITS.put(TimeUnit.MILLISECONDS, "ms");
        TIME_UNITS.put(TimeUnit.SECONDS, "s");
        TIME_UNITS.put(TimeUnit.MINUTES, "min");
        TIME_UNITS.put(TimeUnit.HOURS, "h");
        TIME_UNITS.put(TimeUnit.DAYS, "d");
    }
}

