/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDBitVector;
import net.sf.javabdd.BDDDomain;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.BDDPairing;

public class CUDDFactory
extends BDDFactory {
    private static CUDDFactory INSTANCE;
    private static long zero;
    private static long one;
    public static final String REVISION = "$Revision: 1.6 $";

    public static BDDFactory init(int nodenum, int cachesize) {
        CUDDFactory f = new CUDDFactory();
        f.initialize(nodenum / 256, cachesize);
        return f;
    }

    private static native void registerNatives();

    private CUDDFactory() {
    }

    public BDD zero() {
        return new CUDDBDD(zero);
    }

    public BDD one() {
        return new CUDDBDD(one);
    }

    protected void initialize(int nodenum, int cachesize) {
        if (INSTANCE != null) {
            throw new InternalError("Error: CUDDFactory already initialized.");
        }
        INSTANCE = this;
        CUDDFactory.initialize0(nodenum, cachesize);
    }

    private static native void initialize0(int var0, int var1);

    public boolean isInitialized() {
        return CUDDFactory.isInitialized0();
    }

    private static native boolean isInitialized0();

    public void done() {
        INSTANCE = null;
        CUDDFactory.done0();
    }

    private static native void done0();

    public void setError(int code) {
    }

    public void clearError() {
    }

    public int setMaxNodeNum(int size) {
        System.err.println("Warning: setMaxNodeNum() not yet implemented");
        return 1000000;
    }

    public int setNodeTableSize(int size) {
        System.err.println("Warning: setNodeTableSize() not yet implemented");
        return this.getNodeTableSize();
    }

    public int setCacheSize(int size) {
        System.err.println("Warning: setCacheSize() not yet implemented");
        return 0;
    }

    public double setMinFreeNodes(double x) {
        System.err.println("Warning: setMinFreeNodes() not yet implemented");
        return 0.0;
    }

    public int setMaxIncrease(int x) {
        System.err.println("Warning: setMaxIncrease() not yet implemented");
        return 50000;
    }

    public double setCacheRatio(double x) {
        System.err.println("Warning: setCacheRatio() not yet implemented");
        return 0.0;
    }

    public double setIncreaseFactor(double x) {
        System.err.println("Warning: setIncreaseFactor() not yet implemented");
        return 0.0;
    }

    public int varNum() {
        return CUDDFactory.varNum0();
    }

    private static native int varNum0();

    public int setVarNum(int num) {
        return CUDDFactory.setVarNum0(num);
    }

    private static native int setVarNum0(int var0);

    public int duplicateVar(int var) {
        throw new UnsupportedOperationException();
    }

    public BDD ithVar(int var) {
        long id = CUDDFactory.ithVar0(var);
        return new CUDDBDD(id);
    }

    private static native long ithVar0(int var0);

    public BDD nithVar(int var) {
        BDD b = this.ithVar(var);
        BDD c = b.not();
        b.free();
        return c;
    }

    public void swapVar(int v1, int v2) {
        throw new UnsupportedOperationException();
    }

    public BDDPairing makePair() {
        return new CUDDBDDPairing();
    }

    public void printAll() {
        throw new UnsupportedOperationException();
    }

    public void printTable(BDD b) {
        throw new UnsupportedOperationException();
    }

    public int level2Var(int level) {
        return CUDDFactory.level2Var0(level);
    }

    private static native int level2Var0(int var0);

    public int var2Level(int var) {
        return CUDDFactory.var2Level0(var);
    }

    private static native int var2Level0(int var0);

    public void reorder(BDDFactory.ReorderMethod m) {
        throw new UnsupportedOperationException();
    }

    public void autoReorder(BDDFactory.ReorderMethod method) {
        throw new UnsupportedOperationException();
    }

    public void autoReorder(BDDFactory.ReorderMethod method, int max) {
        throw new UnsupportedOperationException();
    }

    public BDDFactory.ReorderMethod getReorderMethod() {
        throw new UnsupportedOperationException();
    }

    public int getReorderTimes() {
        throw new UnsupportedOperationException();
    }

    public void disableReorder() {
        System.err.println("Warning: disableReorder() not yet implemented");
    }

    public void enableReorder() {
        System.err.println("Warning: enableReorder() not yet implemented");
    }

    public int reorderVerbose(int v) {
        throw new UnsupportedOperationException();
    }

    public void setVarOrder(int[] neworder) {
        CUDDFactory.setVarOrder0(neworder);
    }

    private static native void setVarOrder0(int[] var0);

    public void addVarBlock(BDD var, boolean fixed) {
        throw new UnsupportedOperationException();
    }

    public void addVarBlock(int first, int last, boolean fixed) {
        throw new UnsupportedOperationException();
    }

    public void varBlockAll() {
        throw new UnsupportedOperationException();
    }

    public void clearVarBlocks() {
        throw new UnsupportedOperationException();
    }

    public void printOrder() {
        throw new UnsupportedOperationException();
    }

    public int nodeCount(Collection r) {
        throw new UnsupportedOperationException();
    }

    public int getNodeTableSize() {
        return CUDDFactory.getAllocNum0();
    }

    private static native int getAllocNum0();

    public int getNodeNum() {
        return CUDDFactory.getNodeNum0();
    }

    private static native int getNodeNum0();

    public int getCacheSize() {
        throw new UnsupportedOperationException();
    }

    public int reorderGain() {
        throw new UnsupportedOperationException();
    }

    public void printStat() {
        throw new UnsupportedOperationException();
    }

    protected BDDDomain createDomain(int a, BigInteger b) {
        return new CUDDBDDDomain(a, b);
    }

    protected BDDBitVector createBitVector(int a) {
        return new CUDDBDDBitVector(a);
    }

    public static void main(String[] args) {
        int i;
        BDDFactory bdd2 = CUDDFactory.init(1000000, 100000);
        System.out.println("One: " + one);
        System.out.println("Zero: " + zero);
        BDDDomain[] doms = bdd2.extDomain(new int[]{50, 10, 15, 20, 15});
        BDD b = bdd2.one();
        for (i = 0; i < doms.length - 1; ++i) {
            b.andWith(doms[i].ithVar(i));
        }
        for (i = 0; i < bdd2.numberOfDomains(); ++i) {
            BDDDomain d = bdd2.getDomain(i);
            int[] ivar = d.vars();
            System.out.print("Domain #" + i + ":");
            for (int j = 0; j < ivar.length; ++j) {
                System.out.print(' ');
                System.out.print(j);
                System.out.print(':');
                System.out.print(ivar[j]);
            }
            System.out.println();
        }
        BDDPairing p = bdd2.makePair(doms[2], doms[doms.length - 1]);
        System.out.println("Pairing: " + p);
        System.out.println("Before replace(): " + b);
        BDD c = b.replace(p);
        System.out.println("After replace(): " + c);
        c.printDot();
    }

    public String getVersion() {
        return "CUDD " + REVISION.substring(11, REVISION.length() - 2);
    }

    static {
        String libname = "cudd";
        try {
            System.loadLibrary(libname);
        }
        catch (UnsatisfiedLinkError x) {
            libname = System.mapLibraryName(libname);
            String currentdir = CUDDFactory.getProperty("user.dir", ".");
            String sep = CUDDFactory.getProperty("file.separator", "/");
            System.load(currentdir + sep + libname);
        }
        CUDDFactory.registerNatives();
    }

    private static class CUDDBDDBitVector
    extends BDDBitVector {
        private CUDDBDDBitVector(int a) {
            super(a);
        }

        public BDDFactory getFactory() {
            return INSTANCE;
        }
    }

    private static class CUDDBDDPairing
    extends BDDPairing {
        long _ptr = CUDDBDDPairing.alloc();

        private CUDDBDDPairing() {
        }

        private static native long alloc();

        public void set(int oldvar, int newvar) {
            CUDDBDDPairing.set0(this._ptr, oldvar, newvar);
        }

        private static native void set0(long var0, int var2, int var3);

        public void set(int oldvar, BDD newvar) {
            CUDDBDD c = (CUDDBDD)newvar;
            CUDDBDDPairing.set2(this._ptr, oldvar, c._ddnode_ptr);
        }

        private static native void set2(long var0, int var2, long var3);

        public void reset() {
            CUDDBDDPairing.reset0(this._ptr);
        }

        private static native void reset0(long var0);

        private static native void free0(long var0);
    }

    private static class CUDDBDDDomain
    extends BDDDomain {
        private CUDDBDDDomain(int index, BigInteger range) {
            super(index, range);
        }

        public BDDFactory getFactory() {
            return INSTANCE;
        }
    }

    private static class CUDDBDD
    extends BDD {
        private long _ddnode_ptr;
        static final long INVALID_BDD = -1L;
        static final boolean USE_FINALIZER = false;

        private CUDDBDD(long ddnode) {
            this._ddnode_ptr = ddnode;
            CUDDBDD.addRef(ddnode);
        }

        public BDDFactory getFactory() {
            return INSTANCE;
        }

        public boolean isZero() {
            return this._ddnode_ptr == zero;
        }

        public boolean isOne() {
            return this._ddnode_ptr == one;
        }

        public int var() {
            return CUDDBDD.var0(this._ddnode_ptr);
        }

        private static native int var0(long var0);

        public BDD high() {
            long b = CUDDBDD.high0(this._ddnode_ptr);
            return new CUDDBDD(b);
        }

        private static native long high0(long var0);

        public BDD low() {
            long b = CUDDBDD.low0(this._ddnode_ptr);
            return new CUDDBDD(b);
        }

        private static native long low0(long var0);

        public BDD id() {
            return new CUDDBDD(this._ddnode_ptr);
        }

        public BDD not() {
            long b = CUDDBDD.not0(this._ddnode_ptr);
            return new CUDDBDD(b);
        }

        private static native long not0(long var0);

        public BDD ite(BDD thenBDD, BDD elseBDD) {
            CUDDBDD c = (CUDDBDD)thenBDD;
            CUDDBDD d = (CUDDBDD)elseBDD;
            long b = CUDDBDD.ite0(this._ddnode_ptr, c._ddnode_ptr, d._ddnode_ptr);
            return new CUDDBDD(b);
        }

        private static native long ite0(long var0, long var2, long var4);

        public BDD relprod(BDD that, BDD var) {
            CUDDBDD c = (CUDDBDD)that;
            CUDDBDD d = (CUDDBDD)var;
            long b = CUDDBDD.relprod0(this._ddnode_ptr, c._ddnode_ptr, d._ddnode_ptr);
            return new CUDDBDD(b);
        }

        private static native long relprod0(long var0, long var2, long var4);

        public BDD compose(BDD that, int var) {
            CUDDBDD c = (CUDDBDD)that;
            long b = CUDDBDD.compose0(this._ddnode_ptr, c._ddnode_ptr, var);
            return new CUDDBDD(b);
        }

        private static native long compose0(long var0, long var2, int var4);

        public BDD constrain(BDD that) {
            throw new UnsupportedOperationException();
        }

        public BDD exist(BDD var) {
            CUDDBDD c = (CUDDBDD)var;
            long b = CUDDBDD.exist0(this._ddnode_ptr, c._ddnode_ptr);
            return new CUDDBDD(b);
        }

        private static native long exist0(long var0, long var2);

        public BDD forAll(BDD var) {
            CUDDBDD c = (CUDDBDD)var;
            long b = CUDDBDD.forAll0(this._ddnode_ptr, c._ddnode_ptr);
            return new CUDDBDD(b);
        }

        private static native long forAll0(long var0, long var2);

        public BDD unique(BDD var) {
            throw new UnsupportedOperationException();
        }

        public BDD restrict(BDD var) {
            CUDDBDD c = (CUDDBDD)var;
            long b = CUDDBDD.restrict0(this._ddnode_ptr, c._ddnode_ptr);
            return new CUDDBDD(b);
        }

        private static native long restrict0(long var0, long var2);

        public BDD restrictWith(BDD var) {
            CUDDBDD c = (CUDDBDD)var;
            long b = CUDDBDD.restrict0(this._ddnode_ptr, c._ddnode_ptr);
            CUDDBDD.addRef(b);
            CUDDBDD.delRef(this._ddnode_ptr);
            if (this != c) {
                CUDDBDD.delRef(c._ddnode_ptr);
                c._ddnode_ptr = -1L;
            }
            this._ddnode_ptr = b;
            return this;
        }

        public BDD simplify(BDD d) {
            throw new UnsupportedOperationException();
        }

        public BDD support() {
            long b = CUDDBDD.support0(this._ddnode_ptr);
            return new CUDDBDD(b);
        }

        private static native long support0(long var0);

        public BDD apply(BDD that, BDDFactory.BDDOp opr) {
            CUDDBDD c = (CUDDBDD)that;
            long b = CUDDBDD.apply0(this._ddnode_ptr, c._ddnode_ptr, opr.id);
            return new CUDDBDD(b);
        }

        private static native long apply0(long var0, long var2, int var4);

        public BDD applyWith(BDD that, BDDFactory.BDDOp opr) {
            CUDDBDD c = (CUDDBDD)that;
            long b = CUDDBDD.apply0(this._ddnode_ptr, c._ddnode_ptr, opr.id);
            CUDDBDD.addRef(b);
            CUDDBDD.delRef(this._ddnode_ptr);
            if (this != c) {
                CUDDBDD.delRef(c._ddnode_ptr);
                c._ddnode_ptr = -1L;
            }
            this._ddnode_ptr = b;
            return this;
        }

        public BDD applyAll(BDD that, BDDFactory.BDDOp opr, BDD var) {
            throw new UnsupportedOperationException();
        }

        public BDD applyEx(BDD that, BDDFactory.BDDOp opr, BDD var) {
            throw new UnsupportedOperationException();
        }

        public BDD applyUni(BDD that, BDDFactory.BDDOp opr, BDD var) {
            throw new UnsupportedOperationException();
        }

        public BDD satOne() {
            long b = CUDDBDD.satOne0(this._ddnode_ptr);
            return new CUDDBDD(b);
        }

        private static native long satOne0(long var0);

        public BDD fullSatOne() {
            throw new UnsupportedOperationException();
        }

        public BDD satOne(BDD var, boolean pol) {
            throw new UnsupportedOperationException();
        }

        public List allsat() {
            throw new UnsupportedOperationException();
        }

        public int nodeCount() {
            return CUDDBDD.nodeCount0(this._ddnode_ptr);
        }

        private static native int nodeCount0(long var0);

        public double pathCount() {
            return CUDDBDD.pathCount0(this._ddnode_ptr);
        }

        private static native double pathCount0(long var0);

        public double satCount() {
            return CUDDBDD.satCount0(this._ddnode_ptr);
        }

        private static native double satCount0(long var0);

        public int[] varProfile() {
            throw new UnsupportedOperationException();
        }

        private static native void addRef(long var0);

        private static native void delRef(long var0);

        public void free() {
            CUDDBDD.delRef(this._ddnode_ptr);
            this._ddnode_ptr = -1L;
        }

        public BDD veccompose(BDDPairing pair) {
            CUDDBDDPairing p = (CUDDBDDPairing)pair;
            long b = CUDDBDD.veccompose0(this._ddnode_ptr, p._ptr);
            return new CUDDBDD(b);
        }

        private static native long veccompose0(long var0, long var2);

        public BDD replace(BDDPairing pair) {
            CUDDBDDPairing p = (CUDDBDDPairing)pair;
            long b = CUDDBDD.replace0(this._ddnode_ptr, p._ptr);
            return new CUDDBDD(b);
        }

        private static native long replace0(long var0, long var2);

        public BDD replaceWith(BDDPairing pair) {
            CUDDBDDPairing p = (CUDDBDDPairing)pair;
            long b = CUDDBDD.replace0(this._ddnode_ptr, p._ptr);
            CUDDBDD.addRef(b);
            CUDDBDD.delRef(this._ddnode_ptr);
            this._ddnode_ptr = b;
            return this;
        }

        public boolean equals(BDD that) {
            return this._ddnode_ptr == ((CUDDBDD)that)._ddnode_ptr;
        }

        public int hashCode() {
            return (int)this._ddnode_ptr;
        }
    }
}

