/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDBitVector;
import net.sf.javabdd.BDDDomain;
import net.sf.javabdd.BDDException;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.BDDPairing;

public class JFactory
extends BDDFactory {
    static final boolean VERIFY_ASSERTIONS = false;
    public static final String REVISION = "$Revision: 1.21 $";
    static final boolean USE_FINALIZER = false;
    public static boolean FLUSH_CACHE_ON_GC = true;
    static final int REF_MASK = -4194304;
    static final int MARK_MASK = 0x200000;
    static final int LEV_MASK = 0x1FFFFF;
    static final int MAXVAR = 0x1FFFFF;
    static final int INVALID_BDD = -1;
    static final int REF_INC = 0x400000;
    static final int offset__refcou_and_level = 0;
    static final int offset__low = 1;
    static final int offset__high = 2;
    static final int offset__hash = 3;
    static final int offset__next = 4;
    static final int __node_size = 5;
    static final int bddtrue = 1;
    static final int bddfalse = 0;
    static final int BDDONE = 1;
    static final int BDDZERO = 0;
    boolean bddrunning;
    int bdderrorcond;
    int bddnodesize;
    int bddmaxnodesize;
    int bddmaxnodeincrease;
    int[] bddnodes;
    int bddfreepos;
    int bddfreenum;
    int bddproduced;
    int bddvarnum;
    int[] bddrefstack;
    int bddrefstacktop;
    int[] bddvar2level;
    int[] bddlevel2var;
    boolean bddresized;
    int minfreenodes = 20;
    int[] bddvarset;
    int gbcollectnum;
    int cachesize;
    long gbcclock;
    int usednodes_nextreorder;
    static final int BDD_MEMORY = -1;
    static final int BDD_VAR = -2;
    static final int BDD_RANGE = -3;
    static final int BDD_DEREF = -4;
    static final int BDD_RUNNING = -5;
    static final int BDD_FILE = -6;
    static final int BDD_FORMAT = -7;
    static final int BDD_ORDER = -8;
    static final int BDD_BREAK = -9;
    static final int BDD_VARNUM = -10;
    static final int BDD_NODES = -11;
    static final int BDD_OP = -12;
    static final int BDD_VARSET = -13;
    static final int BDD_VARBLK = -14;
    static final int BDD_DECVNUM = -15;
    static final int BDD_REPLACE = -16;
    static final int BDD_NODENUM = -17;
    static final int BDD_ILLBDD = -18;
    static final int BDD_SIZE = -19;
    static final int BVEC_SIZE = -20;
    static final int BVEC_SHIFT = -21;
    static final int BVEC_DIVZERO = -22;
    static final int BDD_ERRNUM = 24;
    static String[] errorstrings = new String[]{"", "Out of memory", "Unknown variable", "Value out of range", "Unknown BDD root dereferenced", "bdd_init() called twice", "File operation failed", "Incorrect file format", "Variables not in ascending order", "User called break", "Mismatch in size of variable sets", "Cannot allocate fewer nodes than already in use", "Unknown operator", "Illegal variable set", "Bad variable block operation", "Trying to decrease the number of variables", "Trying to replace with variables already in the bdd", "Number of nodes reached user defined maximum", "Unknown BDD - was not in node table", "Bad size argument", "Mismatch in bitvector size", "Illegal shift-left/right parameter", "Division by zero"};
    static final int DEFAULTMAXNODEINC = 50000;
    static final double M_LN2 = 0.6931471805599453;
    static final int bddop_and = 0;
    static final int bddop_xor = 1;
    static final int bddop_or = 2;
    static final int bddop_nand = 3;
    static final int bddop_nor = 4;
    static final int bddop_imp = 5;
    static final int bddop_biimp = 6;
    static final int bddop_diff = 7;
    static final int bddop_less = 8;
    static final int bddop_invimp = 9;
    static final int bddop_not = 10;
    static final int bddop_simplify = 11;
    static final int INT_MAX = Integer.MAX_VALUE;
    static int supportSize = 0;
    public static final boolean CACHESTATS = false;
    static final int CACHEID_CONSTRAIN = 0;
    static final int CACHEID_RESTRICT = 1;
    static final int CACHEID_SATCOU = 2;
    static final int CACHEID_SATCOULN = 3;
    static final int CACHEID_PATHCOU = 4;
    static final int CACHEID_REPLACE = 0;
    static final int CACHEID_COMPOSE = 1;
    static final int CACHEID_VECCOMPOSE = 2;
    static final int CACHEID_EXIST = 0;
    static final int CACHEID_FORALL = 1;
    static final int CACHEID_UNIQUE = 2;
    static final int CACHEID_APPEX = 3;
    static final int CACHEID_APPAL = 4;
    static final int CACHEID_APPUN = 5;
    static final int OPERATOR_NUM = 11;
    static int[][] oprres = new int[][]{{0, 0, 0, 1}, {0, 1, 1, 0}, {0, 1, 1, 1}, {1, 1, 1, 0}, {1, 0, 0, 0}, {1, 1, 0, 1}, {1, 0, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 0}, {1, 0, 1, 1}, {1, 1, 0, 0}};
    int applyop;
    int appexop;
    int appexid;
    int quantid;
    int[] quantvarset;
    int quantvarsetID;
    int quantlast;
    int replaceid;
    int[] replacepair;
    int replacelast;
    int composelevel;
    int miscid;
    int supportID;
    int supportMin;
    int supportMax;
    int[] supportSet;
    BddCache applycache;
    BddCache itecache;
    BddCache quantcache;
    BddCache appexcache;
    BddCache replacecache;
    BddCache misccache;
    BddCache countcache;
    int cacheratio;
    int satPolarity;
    int firstReorder;
    byte[] allsatProfile;
    bddPair pairs;
    int pairsid;
    double increasefactor;
    int bddreordermethod;
    int bddreordertimes;
    int reorderdisabled;
    BddTree vartree;
    int blockid;
    int[] extroots;
    int extrootsize;
    levelData[] levels;
    imatrix iactmtx;
    int verbose;
    int usednum_before;
    int usednum_after;
    static final int BDD_REORDER_NONE = 0;
    static final int BDD_REORDER_WIN2 = 1;
    static final int BDD_REORDER_WIN2ITE = 2;
    static final int BDD_REORDER_SIFT = 3;
    static final int BDD_REORDER_SIFTITE = 4;
    static final int BDD_REORDER_WIN3 = 5;
    static final int BDD_REORDER_WIN3ITE = 6;
    static final int BDD_REORDER_RANDOM = 7;
    static final int BDD_REORDER_FREE = 0;
    static final int BDD_REORDER_FIXED = 1;
    static long c1;
    public static final boolean SWAPCOUNT = false;
    boolean resizedInMakenode;
    int lh_nodenum;
    int lh_freepos;
    int[] loadvar2level;
    LoadHash[] lh_table;
    Random rng = new Random();
    static final int CHECKTIMES = 20;

    public String getVersion() {
        return "JFactory " + REVISION.substring(11, REVISION.length() - 2);
    }

    private JFactory() {
    }

    public static BDDFactory init(int nodenum, int cachesize) {
        JFactory f = new JFactory();
        ((BDDFactory)f).initialize(nodenum, cachesize);
        return f;
    }

    private bdd makeBDD(int id) {
        bdd b = new bdd(id);
        return b;
    }

    private final boolean HASREF(int node) {
        boolean r = (this.bddnodes[node * 5 + 0] & 0xFFC00000) != 0;
        return r;
    }

    private final void SETMAXREF(int node) {
        int n = node * 5 + 0;
        this.bddnodes[n] = this.bddnodes[n] | 0xFFC00000;
    }

    private final void CLEARREF(int node) {
        int n = node * 5 + 0;
        this.bddnodes[n] = this.bddnodes[n] & 0x3FFFFF;
    }

    private final void INCREF(int node) {
        if ((this.bddnodes[node * 5 + 0] & 0xFFC00000) != -4194304) {
            int n = node * 5 + 0;
            this.bddnodes[n] = this.bddnodes[n] + 0x400000;
        }
    }

    private final void DECREF(int node) {
        int rc = this.bddnodes[node * 5 + 0] & 0xFFC00000;
        if (rc != -4194304 && rc != 0) {
            int n = node * 5 + 0;
            this.bddnodes[n] = this.bddnodes[n] - 0x400000;
        }
    }

    private final int GETREF(int node) {
        return this.bddnodes[node * 5 + 0] >>> 22;
    }

    private final int LEVEL(int node) {
        return this.bddnodes[node * 5 + 0] & 0x1FFFFF;
    }

    private final int LEVELANDMARK(int node) {
        return this.bddnodes[node * 5 + 0] & 0x3FFFFF;
    }

    private final void SETLEVEL(int node, int val) {
        int n = node * 5 + 0;
        this.bddnodes[n] = this.bddnodes[n] & 0xFFE00000;
        int n2 = node * 5 + 0;
        this.bddnodes[n2] = this.bddnodes[n2] | val;
    }

    private final void SETLEVELANDMARK(int node, int val) {
        int n = node * 5 + 0;
        this.bddnodes[n] = this.bddnodes[n] & 0xFFC00000;
        int n2 = node * 5 + 0;
        this.bddnodes[n2] = this.bddnodes[n2] | val;
    }

    private final void SETMARK(int n) {
        int n2 = n * 5 + 0;
        this.bddnodes[n2] = this.bddnodes[n2] | 0x200000;
    }

    private final void UNMARK(int n) {
        int n2 = n * 5 + 0;
        this.bddnodes[n2] = this.bddnodes[n2] & 0xFFDFFFFF;
    }

    private final boolean MARKED(int n) {
        return (this.bddnodes[n * 5 + 0] & 0x200000) != 0;
    }

    private final int LOW(int r) {
        return this.bddnodes[r * 5 + 1];
    }

    private final void SETLOW(int r, int v) {
        this.bddnodes[r * 5 + 1] = v;
    }

    private final int HIGH(int r) {
        return this.bddnodes[r * 5 + 2];
    }

    private final void SETHIGH(int r, int v) {
        this.bddnodes[r * 5 + 2] = v;
    }

    private final int HASH(int r) {
        return this.bddnodes[r * 5 + 3];
    }

    private final void SETHASH(int r, int v) {
        this.bddnodes[r * 5 + 3] = v;
    }

    private final int NEXT(int r) {
        return this.bddnodes[r * 5 + 4];
    }

    private final void SETNEXT(int r, int v) {
        this.bddnodes[r * 5 + 4] = v;
    }

    private final int VARr(int n) {
        return this.LEVELANDMARK(n);
    }

    void SETVARr(int n, int val) {
        this.SETLEVELANDMARK(n, val);
    }

    static final void _assert(boolean b) {
        if (!b) {
            throw new InternalError();
        }
    }

    static final int PAIR(int a, int b) {
        return (a + b) * (a + b + 1) / 2 + a;
    }

    static final int TRIPLE(int a, int b, int c) {
        return JFactory.PAIR(c, JFactory.PAIR(a, b));
    }

    final int NODEHASH(int lvl, int l, int h) {
        return Math.abs(JFactory.TRIPLE(lvl, l, h) % this.bddnodesize);
    }

    public BDD zero() {
        return this.makeBDD(0);
    }

    public BDD one() {
        return this.makeBDD(1);
    }

    int bdd_ithvar(int var) {
        if (var < 0 || var >= this.bddvarnum) {
            JFactory.bdd_error(-2);
            return 0;
        }
        return this.bddvarset[var * 2];
    }

    int bdd_nithvar(int var) {
        if (var < 0 || var >= this.bddvarnum) {
            JFactory.bdd_error(-2);
            return 0;
        }
        return this.bddvarset[var * 2 + 1];
    }

    int bdd_varnum() {
        return this.bddvarnum;
    }

    static int bdd_error(int v) {
        throw new JavaBDDException(v);
    }

    static boolean ISZERO(int r) {
        return r == 0;
    }

    static boolean ISONE(int r) {
        return r == 1;
    }

    static boolean ISCONST(int r) {
        return r < 2;
    }

    void CHECK(int r) {
        if (!this.bddrunning) {
            JFactory.bdd_error(-5);
        } else if (r < 0 || r >= this.bddnodesize) {
            JFactory.bdd_error(-18);
        } else if (r >= 2 && this.LOW(r) == -1) {
            JFactory.bdd_error(-18);
        }
    }

    void CHECKa(int r, int x) {
        this.CHECK(r);
    }

    int bdd_var(int root) {
        this.CHECK(root);
        if (root < 2) {
            JFactory.bdd_error(-18);
        }
        return this.bddlevel2var[this.LEVEL(root)];
    }

    int bdd_low(int root) {
        this.CHECK(root);
        if (root < 2) {
            return JFactory.bdd_error(-18);
        }
        return this.LOW(root);
    }

    int bdd_high(int root) {
        this.CHECK(root);
        if (root < 2) {
            return JFactory.bdd_error(-18);
        }
        return this.HIGH(root);
    }

    void checkresize() {
        if (this.bddresized) {
            this.bdd_operator_noderesize();
        }
        this.bddresized = false;
    }

    static final int NOTHASH(int r) {
        return r;
    }

    static final int APPLYHASH(int l, int r, int op) {
        return JFactory.TRIPLE(l, r, op);
    }

    static final int ITEHASH(int f, int g, int h) {
        return JFactory.TRIPLE(f, g, h);
    }

    static final int RESTRHASH(int r, int var) {
        return JFactory.PAIR(r, var);
    }

    static final int CONSTRAINHASH(int f, int c) {
        return JFactory.PAIR(f, c);
    }

    static final int QUANTHASH(int r) {
        return r;
    }

    static final int REPLACEHASH(int r) {
        return r;
    }

    static final int VECCOMPOSEHASH(int f) {
        return f;
    }

    static final int COMPOSEHASH(int f, int g) {
        return JFactory.PAIR(f, g);
    }

    static final int SATCOUHASH(int r) {
        return r;
    }

    static final int PATHCOUHASH(int r) {
        return r;
    }

    static final int APPEXHASH(int l, int r, int op) {
        return JFactory.PAIR(l, r);
    }

    static double log1p(double a) {
        return Math.log(1.0 + a);
    }

    final boolean INVARSET(int a) {
        return this.quantvarset[a] == this.quantvarsetID;
    }

    final boolean INSVARSET(int a) {
        return Math.abs(this.quantvarset[a]) == this.quantvarsetID;
    }

    int bdd_not(int r) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(r, 0);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.not_rec(r);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int not_rec(int r) {
        if (JFactory.ISZERO(r)) {
            return 1;
        }
        if (JFactory.ISONE(r)) {
            return 0;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.applycache, JFactory.NOTHASH(r));
        if (entry.a == r && entry.c == 10) {
            return entry.res;
        }
        this.PUSHREF(this.not_rec(this.LOW(r)));
        this.PUSHREF(this.not_rec(this.HIGH(r)));
        int res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
        this.POPREF(2);
        entry.a = r;
        entry.c = 10;
        entry.res = res;
        return res;
    }

    int bdd_ite(int f, int g, int h) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(f, 0);
        this.CHECKa(g, 0);
        this.CHECKa(h, 0);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.ite_rec(f, g, h);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int ite_rec(int f, int g, int h) {
        int res;
        if (JFactory.ISONE(f)) {
            return g;
        }
        if (JFactory.ISZERO(f)) {
            return h;
        }
        if (g == h) {
            return g;
        }
        if (JFactory.ISONE(g) && JFactory.ISZERO(h)) {
            return f;
        }
        if (JFactory.ISZERO(g) && JFactory.ISONE(h)) {
            return this.not_rec(f);
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.itecache, JFactory.ITEHASH(f, g, h));
        if (entry.a == f && entry.b == g && entry.c == h) {
            return entry.res;
        }
        if (this.LEVEL(f) == this.LEVEL(g)) {
            if (this.LEVEL(f) == this.LEVEL(h)) {
                this.PUSHREF(this.ite_rec(this.LOW(f), this.LOW(g), this.LOW(h)));
                this.PUSHREF(this.ite_rec(this.HIGH(f), this.HIGH(g), this.HIGH(h)));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            } else if (this.LEVEL(f) < this.LEVEL(h)) {
                this.PUSHREF(this.ite_rec(this.LOW(f), this.LOW(g), h));
                this.PUSHREF(this.ite_rec(this.HIGH(f), this.HIGH(g), h));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            } else {
                this.PUSHREF(this.ite_rec(f, g, this.LOW(h)));
                this.PUSHREF(this.ite_rec(f, g, this.HIGH(h)));
                res = this.bdd_makenode(this.LEVEL(h), this.READREF(2), this.READREF(1));
            }
        } else if (this.LEVEL(f) < this.LEVEL(g)) {
            if (this.LEVEL(f) == this.LEVEL(h)) {
                this.PUSHREF(this.ite_rec(this.LOW(f), g, this.LOW(h)));
                this.PUSHREF(this.ite_rec(this.HIGH(f), g, this.HIGH(h)));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            } else if (this.LEVEL(f) < this.LEVEL(h)) {
                this.PUSHREF(this.ite_rec(this.LOW(f), g, h));
                this.PUSHREF(this.ite_rec(this.HIGH(f), g, h));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            } else {
                this.PUSHREF(this.ite_rec(f, g, this.LOW(h)));
                this.PUSHREF(this.ite_rec(f, g, this.HIGH(h)));
                res = this.bdd_makenode(this.LEVEL(h), this.READREF(2), this.READREF(1));
            }
        } else if (this.LEVEL(g) == this.LEVEL(h)) {
            this.PUSHREF(this.ite_rec(f, this.LOW(g), this.LOW(h)));
            this.PUSHREF(this.ite_rec(f, this.HIGH(g), this.HIGH(h)));
            res = this.bdd_makenode(this.LEVEL(g), this.READREF(2), this.READREF(1));
        } else if (this.LEVEL(g) < this.LEVEL(h)) {
            this.PUSHREF(this.ite_rec(f, this.LOW(g), h));
            this.PUSHREF(this.ite_rec(f, this.HIGH(g), h));
            res = this.bdd_makenode(this.LEVEL(g), this.READREF(2), this.READREF(1));
        } else {
            this.PUSHREF(this.ite_rec(f, g, this.LOW(h)));
            this.PUSHREF(this.ite_rec(f, g, this.HIGH(h)));
            res = this.bdd_makenode(this.LEVEL(h), this.READREF(2), this.READREF(1));
        }
        this.POPREF(2);
        entry.a = f;
        entry.b = g;
        entry.c = h;
        entry.res = res;
        return res;
    }

    int bdd_replace(int r, bddPair pair) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(r, 0);
        if (this.replacecache == null) {
            this.replacecache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.replacepair = pair.result;
                this.replacelast = pair.last;
                this.replaceid = pair.id << 2 | 0;
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.replace_rec(r);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int replace_rec(int r) {
        if (JFactory.ISCONST(r) || this.LEVEL(r) > this.replacelast) {
            return r;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.replacecache, JFactory.REPLACEHASH(r));
        if (entry.a == r && entry.c == this.replaceid) {
            return entry.res;
        }
        this.PUSHREF(this.replace_rec(this.LOW(r)));
        this.PUSHREF(this.replace_rec(this.HIGH(r)));
        int res = this.bdd_correctify(this.LEVEL(this.replacepair[this.LEVEL(r)]), this.READREF(2), this.READREF(1));
        this.POPREF(2);
        entry.a = r;
        entry.c = this.replaceid;
        entry.res = res;
        return res;
    }

    int bdd_correctify(int level, int l, int r) {
        int res;
        if (level < this.LEVEL(l) && level < this.LEVEL(r)) {
            return this.bdd_makenode(level, l, r);
        }
        if (level == this.LEVEL(l) || level == this.LEVEL(r)) {
            JFactory.bdd_error(-16);
            return 0;
        }
        if (this.LEVEL(l) == this.LEVEL(r)) {
            this.PUSHREF(this.bdd_correctify(level, this.LOW(l), this.LOW(r)));
            this.PUSHREF(this.bdd_correctify(level, this.HIGH(l), this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
        } else if (this.LEVEL(l) < this.LEVEL(r)) {
            this.PUSHREF(this.bdd_correctify(level, this.LOW(l), r));
            this.PUSHREF(this.bdd_correctify(level, this.HIGH(l), r));
            res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
        } else {
            this.PUSHREF(this.bdd_correctify(level, l, this.LOW(r)));
            this.PUSHREF(this.bdd_correctify(level, l, this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
        }
        this.POPREF(2);
        return res;
    }

    int bdd_apply(int l, int r, int op) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(l, 0);
        this.CHECKa(r, 0);
        if (op < 0 || op > 9) {
            JFactory.bdd_error(-12);
            return 0;
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.applyop = op;
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                switch (op) {
                    case 0: {
                        res = this.and_rec(l, r);
                        break;
                    }
                    case 2: {
                        res = this.or_rec(l, r);
                        break;
                    }
                    default: {
                        res = this.apply_rec(l, r);
                    }
                }
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int apply_rec(int l, int r) {
        int res;
        switch (this.applyop) {
            case 1: {
                if (l == r) {
                    return 0;
                }
                if (JFactory.ISZERO(l)) {
                    return r;
                }
                if (!JFactory.ISZERO(r)) break;
                return l;
            }
            case 3: {
                if (!JFactory.ISZERO(l) && !JFactory.ISZERO(r)) break;
                return 1;
            }
            case 4: {
                if (!JFactory.ISONE(l) && !JFactory.ISONE(r)) break;
                return 0;
            }
            case 5: {
                if (JFactory.ISZERO(l)) {
                    return 1;
                }
                if (JFactory.ISONE(l)) {
                    return r;
                }
                if (!JFactory.ISONE(r)) break;
                return 1;
            }
        }
        if (JFactory.ISCONST(l) && JFactory.ISCONST(r)) {
            res = oprres[this.applyop][l << 1 | r];
        } else {
            BddCacheDataI entry = this.BddCache_lookupI(this.applycache, JFactory.APPLYHASH(l, r, this.applyop));
            if (entry.a == l && entry.b == r && entry.c == this.applyop) {
                return entry.res;
            }
            if (this.LEVEL(l) == this.LEVEL(r)) {
                this.PUSHREF(this.apply_rec(this.LOW(l), this.LOW(r)));
                this.PUSHREF(this.apply_rec(this.HIGH(l), this.HIGH(r)));
                res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
            } else if (this.LEVEL(l) < this.LEVEL(r)) {
                this.PUSHREF(this.apply_rec(this.LOW(l), r));
                this.PUSHREF(this.apply_rec(this.HIGH(l), r));
                res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
            } else {
                this.PUSHREF(this.apply_rec(l, this.LOW(r)));
                this.PUSHREF(this.apply_rec(l, this.HIGH(r)));
                res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
            }
            this.POPREF(2);
            entry.a = l;
            entry.b = r;
            entry.c = this.applyop;
            entry.res = res;
        }
        return res;
    }

    int and_rec(int l, int r) {
        int res;
        if (l == r) {
            return l;
        }
        if (JFactory.ISZERO(l) || JFactory.ISZERO(r)) {
            return 0;
        }
        if (JFactory.ISONE(l)) {
            return r;
        }
        if (JFactory.ISONE(r)) {
            return l;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.applycache, JFactory.APPLYHASH(l, r, 0));
        if (entry.a == l && entry.b == r && entry.c == 0) {
            return entry.res;
        }
        if (this.LEVEL(l) == this.LEVEL(r)) {
            this.PUSHREF(this.and_rec(this.LOW(l), this.LOW(r)));
            this.PUSHREF(this.and_rec(this.HIGH(l), this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
        } else if (this.LEVEL(l) < this.LEVEL(r)) {
            this.PUSHREF(this.and_rec(this.LOW(l), r));
            this.PUSHREF(this.and_rec(this.HIGH(l), r));
            res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
        } else {
            this.PUSHREF(this.and_rec(l, this.LOW(r)));
            this.PUSHREF(this.and_rec(l, this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
        }
        this.POPREF(2);
        entry.a = l;
        entry.b = r;
        entry.c = 0;
        entry.res = res;
        return res;
    }

    int or_rec(int l, int r) {
        int res;
        if (l == r) {
            return l;
        }
        if (JFactory.ISONE(l) || JFactory.ISONE(r)) {
            return 1;
        }
        if (JFactory.ISZERO(l)) {
            return r;
        }
        if (JFactory.ISZERO(r)) {
            return l;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.applycache, JFactory.APPLYHASH(l, r, 2));
        if (entry.a == l && entry.b == r && entry.c == 2) {
            return entry.res;
        }
        if (this.LEVEL(l) == this.LEVEL(r)) {
            this.PUSHREF(this.or_rec(this.LOW(l), this.LOW(r)));
            this.PUSHREF(this.or_rec(this.HIGH(l), this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
        } else if (this.LEVEL(l) < this.LEVEL(r)) {
            this.PUSHREF(this.or_rec(this.LOW(l), r));
            this.PUSHREF(this.or_rec(this.HIGH(l), r));
            res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
        } else {
            this.PUSHREF(this.or_rec(l, this.LOW(r)));
            this.PUSHREF(this.or_rec(l, this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
        }
        this.POPREF(2);
        entry.a = l;
        entry.b = r;
        entry.c = 2;
        entry.res = res;
        return res;
    }

    int relprod_rec(int l, int r) {
        int res;
        if (l == 0 || r == 0) {
            return 0;
        }
        if (l == r) {
            return this.quant_rec(l);
        }
        if (l == 1) {
            return this.quant_rec(r);
        }
        if (r == 1) {
            return this.quant_rec(l);
        }
        int LEVEL_l = this.LEVEL(l);
        int LEVEL_r = this.LEVEL(r);
        if (LEVEL_l > this.quantlast && LEVEL_r > this.quantlast) {
            this.applyop = 0;
            res = this.and_rec(l, r);
            this.applyop = 2;
        } else {
            BddCacheDataI entry = this.BddCache_lookupI(this.appexcache, JFactory.APPEXHASH(l, r, 0));
            if (entry.a == l && entry.b == r && entry.c == this.appexid) {
                return entry.res;
            }
            if (LEVEL_l == LEVEL_r) {
                this.PUSHREF(this.relprod_rec(this.LOW(l), this.LOW(r)));
                this.PUSHREF(this.relprod_rec(this.HIGH(l), this.HIGH(r)));
                res = this.INVARSET(LEVEL_l) ? this.or_rec(this.READREF(2), this.READREF(1)) : this.bdd_makenode(LEVEL_l, this.READREF(2), this.READREF(1));
            } else if (LEVEL_l < LEVEL_r) {
                this.PUSHREF(this.relprod_rec(this.LOW(l), r));
                this.PUSHREF(this.relprod_rec(this.HIGH(l), r));
                res = this.INVARSET(LEVEL_l) ? this.or_rec(this.READREF(2), this.READREF(1)) : this.bdd_makenode(LEVEL_l, this.READREF(2), this.READREF(1));
            } else {
                this.PUSHREF(this.relprod_rec(l, this.LOW(r)));
                this.PUSHREF(this.relprod_rec(l, this.HIGH(r)));
                res = this.INVARSET(LEVEL_r) ? this.or_rec(this.READREF(2), this.READREF(1)) : this.bdd_makenode(LEVEL_r, this.READREF(2), this.READREF(1));
            }
            this.POPREF(2);
            entry.a = l;
            entry.b = r;
            entry.c = this.appexid;
            entry.res = res;
        }
        return res;
    }

    int bdd_relprod(int a, int b, int var) {
        return this.bdd_appex(a, b, 0, var);
    }

    int bdd_appex(int l, int r, int opr, int var) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(l, 0);
        this.CHECKa(r, 0);
        this.CHECKa(var, 0);
        if (opr < 0 || opr > 9) {
            JFactory.bdd_error(-12);
            return 0;
        }
        if (var < 2) {
            return this.bdd_apply(l, r, opr);
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.appexcache == null) {
            this.appexcache = this.BddCacheI_init(this.cachesize);
        }
        if (this.quantcache == null) {
            this.quantcache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            if (this.varset2vartable(var) < 0) {
                return 0;
            }
            try {
                this.INITREF();
                this.applyop = 2;
                this.appexop = opr;
                this.appexid = var << 5 | this.appexop << 1;
                this.quantid = this.appexid << 3 | 3;
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                int n = res = opr == 0 ? this.relprod_rec(l, r) : this.appquant_rec(l, r);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int varset2vartable(int r) {
        if (r < 2) {
            return JFactory.bdd_error(-13);
        }
        ++this.quantvarsetID;
        if (this.quantvarsetID == Integer.MAX_VALUE) {
            for (int i = 0; i < this.bddvarnum; ++i) {
                this.quantvarset[i] = 0;
            }
            this.quantvarsetID = 1;
        }
        this.quantlast = -1;
        int n = r;
        while (n > 1) {
            this.quantvarset[this.LEVEL((int)n)] = this.quantvarsetID;
            this.quantlast = this.LEVEL(n);
            n = this.HIGH(n);
        }
        return 0;
    }

    int varset2svartable(int r) {
        if (r < 2) {
            return JFactory.bdd_error(-13);
        }
        ++this.quantvarsetID;
        if (this.quantvarsetID == 0x3FFFFFFF) {
            for (int i = 0; i < this.bddvarnum; ++i) {
                this.quantvarset[i] = 0;
            }
            this.quantvarsetID = 1;
        }
        this.quantlast = 0;
        int n = r;
        while (!JFactory.ISCONST(n)) {
            if (JFactory.ISZERO(this.LOW(n))) {
                this.quantvarset[this.LEVEL((int)n)] = this.quantvarsetID;
                n = this.HIGH(n);
            } else {
                this.quantvarset[this.LEVEL((int)n)] = -this.quantvarsetID;
                n = this.LOW(n);
            }
            this.quantlast = this.LEVEL(n);
        }
        return 0;
    }

    int appquant_rec(int l, int r) {
        int res;
        switch (this.appexop) {
            case 2: {
                if (l == 1 || r == 1) {
                    return 1;
                }
                if (l == r) {
                    return this.quant_rec(l);
                }
                if (l == 0) {
                    return this.quant_rec(r);
                }
                if (r != 0) break;
                return this.quant_rec(l);
            }
            case 1: {
                if (l == r) {
                    return 0;
                }
                if (l == 0) {
                    return this.quant_rec(r);
                }
                if (r != 0) break;
                return this.quant_rec(l);
            }
            case 3: {
                if (l != 0 && r != 0) break;
                return 1;
            }
            case 4: {
                if (l != 1 && r != 1) break;
                return 0;
            }
        }
        if (JFactory.ISCONST(l) && JFactory.ISCONST(r)) {
            res = oprres[this.appexop][l << 1 | r];
        } else if (this.LEVEL(l) > this.quantlast && this.LEVEL(r) > this.quantlast) {
            int oldop = this.applyop;
            this.applyop = this.appexop;
            switch (this.applyop) {
                case 0: {
                    res = this.and_rec(l, r);
                    break;
                }
                case 2: {
                    res = this.or_rec(l, r);
                    break;
                }
                default: {
                    res = this.apply_rec(l, r);
                }
            }
            this.applyop = oldop;
        } else {
            int lev;
            BddCacheDataI entry = this.BddCache_lookupI(this.appexcache, JFactory.APPEXHASH(l, r, this.appexop));
            if (entry.a == l && entry.b == r && entry.c == this.appexid) {
                return entry.res;
            }
            if (this.LEVEL(l) == this.LEVEL(r)) {
                this.PUSHREF(this.appquant_rec(this.LOW(l), this.LOW(r)));
                this.PUSHREF(this.appquant_rec(this.HIGH(l), this.HIGH(r)));
                lev = this.LEVEL(l);
            } else if (this.LEVEL(l) < this.LEVEL(r)) {
                this.PUSHREF(this.appquant_rec(this.LOW(l), r));
                this.PUSHREF(this.appquant_rec(this.HIGH(l), r));
                lev = this.LEVEL(l);
            } else {
                this.PUSHREF(this.appquant_rec(l, this.LOW(r)));
                this.PUSHREF(this.appquant_rec(l, this.HIGH(r)));
                lev = this.LEVEL(r);
            }
            if (this.INVARSET(lev)) {
                int r2 = this.READREF(2);
                int r1 = this.READREF(1);
                switch (this.applyop) {
                    case 0: {
                        res = this.and_rec(r2, r1);
                        break;
                    }
                    case 2: {
                        res = this.or_rec(r2, r1);
                        break;
                    }
                    default: {
                        res = this.apply_rec(r2, r1);
                        break;
                    }
                }
            } else {
                res = this.bdd_makenode(lev, this.READREF(2), this.READREF(1));
            }
            this.POPREF(2);
            entry.a = l;
            entry.b = r;
            entry.c = this.appexid;
            entry.res = res;
        }
        return res;
    }

    int appuni_rec(int l, int r, int var) {
        int res;
        int LEVEL_l = this.LEVEL(l);
        int LEVEL_r = this.LEVEL(r);
        int LEVEL_var = this.LEVEL(var);
        if (LEVEL_l > LEVEL_var && LEVEL_r > LEVEL_var) {
            return 0;
        }
        if (JFactory.ISCONST(l) && JFactory.ISCONST(r)) {
            res = oprres[this.appexop][l << 1 | r];
        } else if (JFactory.ISCONST(var)) {
            int oldop = this.applyop;
            this.applyop = this.appexop;
            switch (this.applyop) {
                case 0: {
                    res = this.and_rec(l, r);
                    break;
                }
                case 2: {
                    res = this.or_rec(l, r);
                    break;
                }
                default: {
                    res = this.apply_rec(l, r);
                }
            }
            this.applyop = oldop;
        } else {
            int lev;
            BddCacheDataI entry = this.BddCache_lookupI(this.appexcache, JFactory.APPEXHASH(l, r, this.appexop));
            if (entry.a == l && entry.b == r && entry.c == this.appexid) {
                return entry.res;
            }
            if (LEVEL_l == LEVEL_r) {
                if (LEVEL_l == LEVEL_var) {
                    lev = -1;
                    var = this.HIGH(var);
                } else {
                    lev = LEVEL_l;
                }
                this.PUSHREF(this.appuni_rec(this.LOW(l), this.LOW(r), var));
                this.PUSHREF(this.appuni_rec(this.HIGH(l), this.HIGH(r), var));
                lev = LEVEL_l;
            } else if (LEVEL_l < LEVEL_r) {
                if (LEVEL_l == LEVEL_var) {
                    lev = -1;
                    var = this.HIGH(var);
                } else {
                    lev = LEVEL_l;
                }
                this.PUSHREF(this.appuni_rec(this.LOW(l), r, var));
                this.PUSHREF(this.appuni_rec(this.HIGH(l), r, var));
            } else {
                if (LEVEL_r == LEVEL_var) {
                    lev = -1;
                    var = this.HIGH(var);
                } else {
                    lev = LEVEL_r;
                }
                this.PUSHREF(this.appuni_rec(l, this.LOW(r), var));
                this.PUSHREF(this.appuni_rec(l, this.HIGH(r), var));
            }
            if (lev == -1) {
                int r2 = this.READREF(2);
                int r1 = this.READREF(1);
                switch (this.applyop) {
                    case 0: {
                        res = this.and_rec(r2, r1);
                        break;
                    }
                    case 2: {
                        res = this.or_rec(r2, r1);
                        break;
                    }
                    default: {
                        res = this.apply_rec(r2, r1);
                        break;
                    }
                }
            } else {
                res = this.bdd_makenode(lev, this.READREF(2), this.READREF(1));
            }
            this.POPREF(2);
            entry.a = l;
            entry.b = r;
            entry.c = this.appexid;
            entry.res = res;
        }
        return res;
    }

    int unique_rec(int r, int q) {
        int res;
        int LEVEL_q;
        int LEVEL_r = this.LEVEL(r);
        if (LEVEL_r > (LEVEL_q = this.LEVEL(q))) {
            return 0;
        }
        if (r < 2 || q < 2) {
            return r;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.quantcache, JFactory.QUANTHASH(r));
        if (entry.a == r && entry.c == this.quantid) {
            return entry.res;
        }
        if (LEVEL_r == LEVEL_q) {
            this.PUSHREF(this.unique_rec(this.LOW(r), this.HIGH(q)));
            this.PUSHREF(this.unique_rec(this.HIGH(r), this.HIGH(q)));
            res = this.apply_rec(this.READREF(2), this.READREF(1));
        } else {
            this.PUSHREF(this.unique_rec(this.LOW(r), q));
            this.PUSHREF(this.unique_rec(this.HIGH(r), q));
            res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
        }
        this.POPREF(2);
        entry.a = r;
        entry.c = this.quantid;
        entry.res = res;
        return res;
    }

    int quant_rec(int r) {
        int res;
        if (r < 2 || this.LEVEL(r) > this.quantlast) {
            return r;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.quantcache, JFactory.QUANTHASH(r));
        if (entry.a == r && entry.c == this.quantid) {
            return entry.res;
        }
        this.PUSHREF(this.quant_rec(this.LOW(r)));
        this.PUSHREF(this.quant_rec(this.HIGH(r)));
        if (this.INVARSET(this.LEVEL(r))) {
            int r2 = this.READREF(2);
            int r1 = this.READREF(1);
            switch (this.applyop) {
                case 0: {
                    res = this.and_rec(r2, r1);
                    break;
                }
                case 2: {
                    res = this.or_rec(r2, r1);
                    break;
                }
                default: {
                    res = this.apply_rec(r2, r1);
                    break;
                }
            }
        } else {
            res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
        }
        this.POPREF(2);
        entry.a = r;
        entry.c = this.quantid;
        entry.res = res;
        return res;
    }

    int bdd_constrain(int f, int c) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(f, 0);
        this.CHECKa(c, 0);
        if (this.misccache == null) {
            this.misccache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.miscid = 0;
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.constrain_rec(f, c);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int constrain_rec(int f, int c) {
        int res;
        if (JFactory.ISONE(c)) {
            return f;
        }
        if (JFactory.ISCONST(f)) {
            return f;
        }
        if (c == f) {
            return 1;
        }
        if (JFactory.ISZERO(c)) {
            return 0;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.misccache, JFactory.CONSTRAINHASH(f, c));
        if (entry.a == f && entry.b == c && entry.c == this.miscid) {
            return entry.res;
        }
        if (this.LEVEL(f) == this.LEVEL(c)) {
            if (JFactory.ISZERO(this.LOW(c))) {
                res = this.constrain_rec(this.HIGH(f), this.HIGH(c));
            } else if (JFactory.ISZERO(this.HIGH(c))) {
                res = this.constrain_rec(this.LOW(f), this.LOW(c));
            } else {
                this.PUSHREF(this.constrain_rec(this.LOW(f), this.LOW(c)));
                this.PUSHREF(this.constrain_rec(this.HIGH(f), this.HIGH(c)));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        } else if (this.LEVEL(f) < this.LEVEL(c)) {
            this.PUSHREF(this.constrain_rec(this.LOW(f), c));
            this.PUSHREF(this.constrain_rec(this.HIGH(f), c));
            res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else if (JFactory.ISZERO(this.LOW(c))) {
            res = this.constrain_rec(f, this.HIGH(c));
        } else if (JFactory.ISZERO(this.HIGH(c))) {
            res = this.constrain_rec(f, this.LOW(c));
        } else {
            this.PUSHREF(this.constrain_rec(f, this.LOW(c)));
            this.PUSHREF(this.constrain_rec(f, this.HIGH(c)));
            res = this.bdd_makenode(this.LEVEL(c), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        }
        entry.a = f;
        entry.b = c;
        entry.c = this.miscid;
        entry.res = res;
        return res;
    }

    int bdd_compose(int f, int g, int var) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(f, 0);
        this.CHECKa(g, 0);
        if (var < 0 || var >= this.bddvarnum) {
            JFactory.bdd_error(-2);
            return 0;
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.composelevel = this.bddvar2level[var];
                this.replaceid = this.composelevel << 2 | 1;
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.compose_rec(f, g);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int compose_rec(int f, int g) {
        int res;
        if (this.LEVEL(f) > this.composelevel) {
            return f;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.replacecache, JFactory.COMPOSEHASH(f, g));
        if (entry.a == f && entry.b == g && entry.c == this.replaceid) {
            return entry.res;
        }
        if (this.LEVEL(f) < this.composelevel) {
            if (this.LEVEL(f) == this.LEVEL(g)) {
                this.PUSHREF(this.compose_rec(this.LOW(f), this.LOW(g)));
                this.PUSHREF(this.compose_rec(this.HIGH(f), this.HIGH(g)));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            } else if (this.LEVEL(f) < this.LEVEL(g)) {
                this.PUSHREF(this.compose_rec(this.LOW(f), g));
                this.PUSHREF(this.compose_rec(this.HIGH(f), g));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            } else {
                this.PUSHREF(this.compose_rec(f, this.LOW(g)));
                this.PUSHREF(this.compose_rec(f, this.HIGH(g)));
                res = this.bdd_makenode(this.LEVEL(g), this.READREF(2), this.READREF(1));
            }
            this.POPREF(2);
        } else {
            res = this.ite_rec(g, this.HIGH(f), this.LOW(f));
        }
        entry.a = f;
        entry.b = g;
        entry.c = this.replaceid;
        entry.res = res;
        return res;
    }

    int bdd_veccompose(int f, bddPair pair) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(f, 0);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        if (this.replacecache == null) {
            this.replacecache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.replacepair = pair.result;
                this.replaceid = pair.id << 2 | 2;
                this.replacelast = pair.last;
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.veccompose_rec(f);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int veccompose_rec(int f) {
        if (this.LEVEL(f) > this.replacelast) {
            return f;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.replacecache, JFactory.VECCOMPOSEHASH(f));
        if (entry.a == f && entry.c == this.replaceid) {
            return entry.res;
        }
        this.PUSHREF(this.veccompose_rec(this.LOW(f)));
        this.PUSHREF(this.veccompose_rec(this.HIGH(f)));
        int res = this.ite_rec(this.replacepair[this.LEVEL(f)], this.READREF(1), this.READREF(2));
        this.POPREF(2);
        entry.a = f;
        entry.c = this.replaceid;
        entry.res = res;
        return res;
    }

    int bdd_exist(int r, int var) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(r, 0);
        this.CHECKa(var, 0);
        if (var < 2) {
            return r;
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.quantcache == null) {
            this.quantcache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            if (this.varset2vartable(var) < 0) {
                return 0;
            }
            try {
                this.INITREF();
                this.quantid = var << 3 | 0;
                this.applyop = 2;
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.quant_rec(r);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int bdd_forall(int r, int var) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(r, 0);
        this.CHECKa(var, 0);
        if (var < 2) {
            return r;
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.quantcache == null) {
            this.quantcache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            if (this.varset2vartable(var) < 0) {
                return 0;
            }
            try {
                this.INITREF();
                this.quantid = var << 3 | 1;
                this.applyop = 0;
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.quant_rec(r);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int bdd_unique(int r, int var) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(r, 0);
        this.CHECKa(var, 0);
        if (var < 2) {
            return r;
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.quantcache == null) {
            this.quantcache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.quantid = var << 3 | 2;
                this.applyop = 1;
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.unique_rec(r, var);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int bdd_restrict(int r, int var) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(r, 0);
        this.CHECKa(var, 0);
        if (var < 2) {
            return r;
        }
        if (this.misccache == null) {
            this.misccache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            if (this.varset2svartable(var) < 0) {
                return 0;
            }
            try {
                this.INITREF();
                this.miscid = var << 3 | 1;
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.restrict_rec(r);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int restrict_rec(int r) {
        int res;
        if (JFactory.ISCONST(r) || this.LEVEL(r) > this.quantlast) {
            return r;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.misccache, JFactory.RESTRHASH(r, this.miscid));
        if (entry.a == r && entry.c == this.miscid) {
            return entry.res;
        }
        if (this.INSVARSET(this.LEVEL(r))) {
            res = this.quantvarset[this.LEVEL(r)] > 0 ? this.restrict_rec(this.HIGH(r)) : this.restrict_rec(this.LOW(r));
        } else {
            this.PUSHREF(this.restrict_rec(this.LOW(r)));
            this.PUSHREF(this.restrict_rec(this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        }
        entry.a = r;
        entry.c = this.miscid;
        entry.res = res;
        return res;
    }

    int bdd_simplify(int f, int d) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(f, 0);
        this.CHECKa(d, 0);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.applyop = 2;
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.simplify_rec(f, d);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int simplify_rec(int f, int d) {
        int res;
        if (JFactory.ISONE(d) || JFactory.ISCONST(f)) {
            return f;
        }
        if (d == f) {
            return 1;
        }
        if (JFactory.ISZERO(d)) {
            return 0;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.applycache, JFactory.APPLYHASH(f, d, 11));
        if (entry.a == f && entry.b == d && entry.c == 11) {
            return entry.res;
        }
        if (this.LEVEL(f) == this.LEVEL(d)) {
            if (JFactory.ISZERO(this.LOW(d))) {
                res = this.simplify_rec(this.HIGH(f), this.HIGH(d));
            } else if (JFactory.ISZERO(this.HIGH(d))) {
                res = this.simplify_rec(this.LOW(f), this.LOW(d));
            } else {
                this.PUSHREF(this.simplify_rec(this.LOW(f), this.LOW(d)));
                this.PUSHREF(this.simplify_rec(this.HIGH(f), this.HIGH(d)));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        } else if (this.LEVEL(f) < this.LEVEL(d)) {
            this.PUSHREF(this.simplify_rec(this.LOW(f), d));
            this.PUSHREF(this.simplify_rec(this.HIGH(f), d));
            res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else {
            this.PUSHREF(this.or_rec(this.LOW(d), this.HIGH(d)));
            res = this.simplify_rec(f, this.READREF(1));
            this.POPREF(1);
        }
        entry.a = f;
        entry.b = d;
        entry.c = 11;
        entry.res = res;
        return res;
    }

    int bdd_support(int r) {
        int res = 1;
        this.CHECKa(r, 0);
        if (r < 2) {
            return 1;
        }
        if (supportSize < this.bddvarnum) {
            this.supportSet = new int[this.bddvarnum];
            supportSize = this.bddvarnum;
            this.supportID = 0;
        }
        if (this.supportID == 0xFFFFFFF) {
            for (int i = 0; i < this.bddvarnum; ++i) {
                this.supportSet[i] = 0;
            }
            this.supportID = 0;
        }
        ++this.supportID;
        this.supportMax = this.supportMin = this.LEVEL(r);
        this.support_rec(r, this.supportSet);
        this.bdd_unmark(r);
        this.bdd_disable_reorder();
        for (int n = this.supportMax; n >= this.supportMin; --n) {
            if (this.supportSet[n] != this.supportID) continue;
            this.bdd_addref(res);
            int tmp = this.bdd_makenode(n, 0, res);
            this.bdd_delref(res);
            res = tmp;
        }
        this.bdd_enable_reorder();
        return res;
    }

    void support_rec(int r, int[] support) {
        if (r < 2) {
            return;
        }
        if (this.MARKED(r) || this.LOW(r) == -1) {
            return;
        }
        support[this.LEVEL((int)r)] = this.supportID;
        if (this.LEVEL(r) > this.supportMax) {
            this.supportMax = this.LEVEL(r);
        }
        this.SETMARK(r);
        this.support_rec(this.LOW(r), support);
        this.support_rec(this.HIGH(r), support);
    }

    int bdd_appall(int l, int r, int opr, int var) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(l, 0);
        this.CHECKa(r, 0);
        this.CHECKa(var, 0);
        if (opr < 0 || opr > 9) {
            JFactory.bdd_error(-12);
            return 0;
        }
        if (var < 2) {
            return this.bdd_apply(l, r, opr);
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.appexcache == null) {
            this.appexcache = this.BddCacheI_init(this.cachesize);
        }
        if (this.quantcache == null) {
            this.quantcache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            if (this.varset2vartable(var) < 0) {
                return 0;
            }
            try {
                this.INITREF();
                this.applyop = 0;
                this.appexop = opr;
                this.appexid = var << 5 | this.appexop << 1 | 1;
                this.quantid = this.appexid << 3 | 4;
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.appquant_rec(l, r);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int bdd_appuni(int l, int r, int opr, int var) {
        int res;
        this.firstReorder = 1;
        this.CHECKa(l, 0);
        this.CHECKa(r, 0);
        this.CHECKa(var, 0);
        if (opr < 0 || opr > 9) {
            JFactory.bdd_error(-12);
            return 0;
        }
        if (var < 2) {
            return this.bdd_apply(l, r, opr);
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.appexcache == null) {
            this.appexcache = this.BddCacheI_init(this.cachesize);
        }
        if (this.quantcache == null) {
            this.quantcache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.applyop = 1;
                this.appexop = opr;
                this.appexid = var << 5 | this.appexop << 1 | 1;
                this.quantid = this.appexid << 3 | 5;
                if (this.firstReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.appuni_rec(l, r, var);
                if (this.firstReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                if (this.firstReorder-- == 1) continue;
                res = 0;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int bdd_satone(int r) {
        this.CHECKa(r, 0);
        if (r < 2) {
            return r;
        }
        this.bdd_disable_reorder();
        this.INITREF();
        int res = this.satone_rec(r);
        this.bdd_enable_reorder();
        this.checkresize();
        return res;
    }

    int satone_rec(int r) {
        if (JFactory.ISCONST(r)) {
            return r;
        }
        if (JFactory.ISZERO(this.LOW(r))) {
            int res = this.satone_rec(this.HIGH(r));
            int m = this.bdd_makenode(this.LEVEL(r), 0, res);
            this.PUSHREF(m);
            return m;
        }
        int res = this.satone_rec(this.LOW(r));
        int m = this.bdd_makenode(this.LEVEL(r), res, 0);
        this.PUSHREF(m);
        return m;
    }

    int bdd_satoneset(int r, int var, int pol) {
        this.CHECKa(r, 0);
        if (JFactory.ISZERO(r)) {
            return r;
        }
        if (!JFactory.ISCONST(pol)) {
            JFactory.bdd_error(-18);
            return 0;
        }
        this.bdd_disable_reorder();
        this.INITREF();
        this.satPolarity = pol;
        int res = this.satoneset_rec(r, var);
        this.bdd_enable_reorder();
        this.checkresize();
        return res;
    }

    int satoneset_rec(int r, int var) {
        if (JFactory.ISCONST(r) && JFactory.ISCONST(var)) {
            return r;
        }
        if (this.LEVEL(r) < this.LEVEL(var)) {
            if (JFactory.ISZERO(this.LOW(r))) {
                int res = this.satoneset_rec(this.HIGH(r), var);
                int m = this.bdd_makenode(this.LEVEL(r), 0, res);
                this.PUSHREF(m);
                return m;
            }
            int res = this.satoneset_rec(this.LOW(r), var);
            int m = this.bdd_makenode(this.LEVEL(r), res, 0);
            this.PUSHREF(m);
            return m;
        }
        if (this.LEVEL(var) < this.LEVEL(r)) {
            int res = this.satoneset_rec(r, this.HIGH(var));
            if (this.satPolarity == 1) {
                int m = this.bdd_makenode(this.LEVEL(var), 0, res);
                this.PUSHREF(m);
                return m;
            }
            int m = this.bdd_makenode(this.LEVEL(var), res, 0);
            this.PUSHREF(m);
            return m;
        }
        if (JFactory.ISZERO(this.LOW(r))) {
            int res = this.satoneset_rec(this.HIGH(r), this.HIGH(var));
            int m = this.bdd_makenode(this.LEVEL(r), 0, res);
            this.PUSHREF(m);
            return m;
        }
        int res = this.satoneset_rec(this.LOW(r), this.HIGH(var));
        int m = this.bdd_makenode(this.LEVEL(r), res, 0);
        this.PUSHREF(m);
        return m;
    }

    int bdd_fullsatone(int r) {
        this.CHECKa(r, 0);
        if (r == 0) {
            return 0;
        }
        this.bdd_disable_reorder();
        this.INITREF();
        int res = this.fullsatone_rec(r);
        for (int v = this.LEVEL(r) - 1; v >= 0; --v) {
            res = this.PUSHREF(this.bdd_makenode(v, res, 0));
        }
        this.bdd_enable_reorder();
        this.checkresize();
        return res;
    }

    int fullsatone_rec(int r) {
        if (r < 2) {
            return r;
        }
        if (this.LOW(r) != 0) {
            int res = this.fullsatone_rec(this.LOW(r));
            for (int v = this.LEVEL(this.LOW(r)) - 1; v > this.LEVEL(r); --v) {
                res = this.PUSHREF(this.bdd_makenode(v, res, 0));
            }
            return this.PUSHREF(this.bdd_makenode(this.LEVEL(r), res, 0));
        }
        int res = this.fullsatone_rec(this.HIGH(r));
        for (int v = this.LEVEL(this.HIGH(r)) - 1; v > this.LEVEL(r); --v) {
            res = this.PUSHREF(this.bdd_makenode(v, res, 0));
        }
        return this.PUSHREF(this.bdd_makenode(this.LEVEL(r), 0, res));
    }

    void bdd_gbc_rehash() {
        this.bddfreepos = 0;
        this.bddfreenum = 0;
        for (int n = this.bddnodesize - 1; n >= 2; --n) {
            if (this.LOW(n) != -1) {
                int hash2 = this.NODEHASH(this.LEVEL(n), this.LOW(n), this.HIGH(n));
                this.SETNEXT(n, this.HASH(hash2));
                this.SETHASH(hash2, n);
                continue;
            }
            this.SETNEXT(n, this.bddfreepos);
            this.bddfreepos = n;
            ++this.bddfreenum;
        }
    }

    long clock() {
        return System.currentTimeMillis();
    }

    void INITREF() {
        this.bddrefstacktop = 0;
    }

    int PUSHREF(int a) {
        this.bddrefstack[this.bddrefstacktop++] = a;
        return a;
    }

    int READREF(int a) {
        return this.bddrefstack[this.bddrefstacktop - a];
    }

    void POPREF(int a) {
        this.bddrefstacktop -= a;
    }

    int bdd_nodecount(int r) {
        int[] num = new int[1];
        this.CHECK(r);
        this.bdd_markcount(r, num);
        this.bdd_unmark(r);
        return num[0];
    }

    int bdd_anodecount(int[] r) {
        int n;
        int[] cou = new int[1];
        for (n = 0; n < r.length; ++n) {
            this.bdd_markcount(r[n], cou);
        }
        for (n = 0; n < r.length; ++n) {
            this.bdd_unmark(r[n]);
        }
        return cou[0];
    }

    int[] bdd_varprofile(int r) {
        this.CHECK(r);
        int[] varprofile = new int[this.bddvarnum];
        this.varprofile_rec(r, varprofile);
        this.bdd_unmark(r);
        return varprofile;
    }

    void varprofile_rec(int r, int[] varprofile) {
        if (r < 2) {
            return;
        }
        if (this.MARKED(r)) {
            return;
        }
        int n = this.bddlevel2var[this.LEVEL(r)];
        varprofile[n] = varprofile[n] + 1;
        this.SETMARK(r);
        this.varprofile_rec(this.LOW(r), varprofile);
        this.varprofile_rec(this.HIGH(r), varprofile);
    }

    double bdd_pathcount(int r) {
        this.CHECK(r);
        this.miscid = 4;
        if (this.countcache == null) {
            this.countcache = this.BddCacheD_init(this.cachesize);
        }
        return this.bdd_pathcount_rec(r);
    }

    double bdd_pathcount_rec(int r) {
        if (JFactory.ISZERO(r)) {
            return 0.0;
        }
        if (JFactory.ISONE(r)) {
            return 1.0;
        }
        BddCacheDataD entry = this.BddCache_lookupD(this.countcache, JFactory.PATHCOUHASH(r));
        if (entry.a == r && entry.c == this.miscid) {
            return entry.dres;
        }
        double size = this.bdd_pathcount_rec(this.LOW(r)) + this.bdd_pathcount_rec(this.HIGH(r));
        entry.a = r;
        entry.c = this.miscid;
        entry.dres = size;
        return size;
    }

    void bdd_allsat(int r, List result) {
        this.CHECK(r);
        this.allsatProfile = new byte[this.bddvarnum];
        for (int v = this.LEVEL(r) - 1; v >= 0; --v) {
            this.allsatProfile[this.bddlevel2var[v]] = -1;
        }
        this.INITREF();
        this.allsat_rec(r, result);
        JFactory.free(this.allsatProfile);
        this.allsatProfile = null;
    }

    void allsat_rec(int r, List result) {
        int v;
        if (JFactory.ISONE(r)) {
            byte[] b = new byte[this.bddvarnum];
            System.arraycopy(this.allsatProfile, 0, b, 0, this.bddvarnum);
            result.add(b);
            return;
        }
        if (JFactory.ISZERO(r)) {
            return;
        }
        if (!JFactory.ISZERO(this.LOW(r))) {
            this.allsatProfile[this.bddlevel2var[this.LEVEL((int)r)]] = 0;
            for (v = this.LEVEL(this.LOW(r)) - 1; v > this.LEVEL(r); --v) {
                this.allsatProfile[this.bddlevel2var[v]] = -1;
            }
            this.allsat_rec(this.LOW(r), result);
        }
        if (!JFactory.ISZERO(this.HIGH(r))) {
            this.allsatProfile[this.bddlevel2var[this.LEVEL((int)r)]] = 1;
            for (v = this.LEVEL(this.HIGH(r)) - 1; v > this.LEVEL(r); --v) {
                this.allsatProfile[this.bddlevel2var[v]] = -1;
            }
            this.allsat_rec(this.HIGH(r), result);
        }
    }

    double bdd_satcount(int r) {
        double size = 1.0;
        this.CHECK(r);
        if (this.countcache == null) {
            this.countcache = this.BddCacheD_init(this.cachesize);
        }
        this.miscid = 2;
        size = Math.pow(2.0, this.LEVEL(r));
        return size * this.satcount_rec(r);
    }

    double bdd_satcountset(int r, int varset) {
        double unused = this.bddvarnum;
        if (JFactory.ISCONST(varset) || JFactory.ISZERO(r)) {
            return 0.0;
        }
        int n = varset;
        while (!JFactory.ISCONST(n)) {
            unused -= 1.0;
            n = this.HIGH(n);
        }
        unused = this.bdd_satcount(r) / Math.pow(2.0, unused);
        return unused >= 1.0 ? unused : 1.0;
    }

    double satcount_rec(int root) {
        if (root < 2) {
            return root;
        }
        BddCacheDataD entry = this.BddCache_lookupD(this.countcache, JFactory.SATCOUHASH(root));
        if (entry.a == root && entry.c == this.miscid) {
            return entry.dres;
        }
        double size = 0.0;
        double s = 1.0;
        size += (s *= Math.pow(2.0, this.LEVEL(this.LOW(root)) - this.LEVEL(root) - 1)) * this.satcount_rec(this.LOW(root));
        s = 1.0;
        entry.a = root;
        entry.c = this.miscid;
        entry.dres = size += (s *= Math.pow(2.0, this.LEVEL(this.HIGH(root)) - this.LEVEL(root) - 1)) * this.satcount_rec(this.HIGH(root));
        return size;
    }

    void bdd_gbc() {
        int n;
        long c1 = this.clock();
        this.gcstats.nodes = this.bddnodesize;
        this.gcstats.freenodes = this.bddfreenum;
        this.gcstats.time = 0L;
        this.gcstats.sumtime = this.gbcclock;
        this.gcstats.num = this.gbcollectnum;
        this.gbc_handler(true, this.gcstats);
        for (int r = 0; r < this.bddrefstacktop; ++r) {
            this.bdd_mark(this.bddrefstack[r]);
        }
        for (n = 0; n < this.bddnodesize; ++n) {
            if (this.HASREF(n)) {
                this.bdd_mark(n);
            }
            this.SETHASH(n, 0);
        }
        this.bddfreepos = 0;
        this.bddfreenum = 0;
        for (n = this.bddnodesize - 1; n >= 2; --n) {
            if (this.MARKED(n) && this.LOW(n) != -1) {
                this.UNMARK(n);
                int hash2 = this.NODEHASH(this.LEVEL(n), this.LOW(n), this.HIGH(n));
                this.SETNEXT(n, this.HASH(hash2));
                this.SETHASH(hash2, n);
                continue;
            }
            this.SETLOW(n, -1);
            this.SETNEXT(n, this.bddfreepos);
            this.bddfreepos = n;
            ++this.bddfreenum;
        }
        if (FLUSH_CACHE_ON_GC) {
            this.bdd_operator_reset();
        } else {
            this.bdd_operator_clean();
        }
        long c2 = this.clock();
        this.gbcclock += c2 - c1;
        ++this.gbcollectnum;
        this.gcstats.nodes = this.bddnodesize;
        this.gcstats.freenodes = this.bddfreenum;
        this.gcstats.time = c2 - c1;
        this.gcstats.sumtime = this.gbcclock;
        this.gcstats.num = this.gbcollectnum;
        this.gbc_handler(false, this.gcstats);
    }

    int bdd_addref(int root) {
        if (root == -1) {
            JFactory.bdd_error(-9);
        }
        if (root < 2 || !this.bddrunning) {
            return root;
        }
        if (root >= this.bddnodesize) {
            return JFactory.bdd_error(-18);
        }
        if (this.LOW(root) == -1) {
            return JFactory.bdd_error(-18);
        }
        this.INCREF(root);
        return root;
    }

    int bdd_delref(int root) {
        if (root == -1) {
            JFactory.bdd_error(-9);
        }
        if (root < 2 || !this.bddrunning) {
            return root;
        }
        if (root >= this.bddnodesize) {
            return JFactory.bdd_error(-18);
        }
        if (this.LOW(root) == -1) {
            return JFactory.bdd_error(-18);
        }
        if (!this.HASREF(root)) {
            JFactory.bdd_error(-9);
        }
        this.DECREF(root);
        return root;
    }

    void bdd_mark(int i) {
        if (i < 2) {
            return;
        }
        if (this.MARKED(i) || this.LOW(i) == -1) {
            return;
        }
        this.SETMARK(i);
        this.bdd_mark(this.LOW(i));
        this.bdd_mark(this.HIGH(i));
    }

    void bdd_markcount(int i, int[] cou) {
        if (i < 2) {
            return;
        }
        if (this.MARKED(i) || this.LOW(i) == -1) {
            return;
        }
        this.SETMARK(i);
        cou[0] = cou[0] + 1;
        this.bdd_markcount(this.LOW(i), cou);
        this.bdd_markcount(this.HIGH(i), cou);
    }

    void bdd_unmark(int i) {
        if (i < 2) {
            return;
        }
        if (!this.MARKED(i) || this.LOW(i) == -1) {
            return;
        }
        this.UNMARK(i);
        this.bdd_unmark(this.LOW(i));
        this.bdd_unmark(this.HIGH(i));
    }

    int bdd_makenode(int level, int low, int high) {
        if (low == high) {
            return low;
        }
        int hash2 = this.NODEHASH(level, low, high);
        int res = this.HASH(hash2);
        while (res != 0) {
            if (this.LEVEL(res) == level && this.LOW(res) == low && this.HIGH(res) == high) {
                return res;
            }
            res = this.NEXT(res);
        }
        if (this.bddfreepos == 0) {
            if (this.bdderrorcond != 0) {
                return 0;
            }
            this.bdd_gbc();
            if (this.bddnodesize - this.bddfreenum >= this.usednodes_nextreorder && this.bdd_reorder_ready()) {
                throw new ReorderException();
            }
            if (this.bddfreenum * 100 / this.bddnodesize <= this.minfreenodes) {
                this.bdd_noderesize(true);
                hash2 = this.NODEHASH(level, low, high);
            }
            if (this.bddfreepos == 0) {
                JFactory.bdd_error(-17);
                this.bdderrorcond = Math.abs(-17);
                return 0;
            }
        }
        res = this.bddfreepos;
        this.bddfreepos = this.NEXT(this.bddfreepos);
        --this.bddfreenum;
        ++this.bddproduced;
        this.SETLEVELANDMARK(res, level);
        this.SETLOW(res, low);
        this.SETHIGH(res, high);
        this.SETNEXT(res, this.HASH(hash2));
        this.SETHASH(hash2, res);
        return res;
    }

    int bdd_noderesize(boolean doRehash) {
        int oldsize = this.bddnodesize;
        int newsize = this.bddnodesize;
        if (this.bddmaxnodesize > 0 && newsize >= this.bddmaxnodesize) {
            return -1;
        }
        newsize = this.increasefactor > 0.0 ? (newsize += (int)((double)newsize * this.increasefactor)) : (newsize <<= 1);
        if (this.bddmaxnodeincrease > 0 && newsize > oldsize + this.bddmaxnodeincrease) {
            newsize = oldsize + this.bddmaxnodeincrease;
        }
        if (this.bddmaxnodesize > 0 && newsize > this.bddmaxnodesize) {
            newsize = this.bddmaxnodesize;
        }
        return this.doResize(doRehash, oldsize, newsize);
    }

    public int setNodeTableSize(int size) {
        int old = this.bddnodesize;
        this.doResize(true, old, size);
        return old;
    }

    int doResize(boolean doRehash, int oldsize, int newsize) {
        int n;
        if (oldsize > (newsize = this.bdd_prime_lte(newsize))) {
            return 0;
        }
        this.resize_handler(oldsize, newsize);
        int[] newnodes = new int[newsize * 5];
        System.arraycopy(this.bddnodes, 0, newnodes, 0, this.bddnodes.length);
        this.bddnodes = newnodes;
        this.bddnodesize = newsize;
        if (doRehash) {
            for (n = 0; n < oldsize; ++n) {
                this.SETHASH(n, 0);
            }
        }
        for (n = oldsize; n < this.bddnodesize; ++n) {
            this.SETLOW(n, -1);
            this.SETNEXT(n, n + 1);
        }
        this.SETNEXT(this.bddnodesize - 1, this.bddfreepos);
        this.bddfreepos = oldsize;
        this.bddfreenum += this.bddnodesize - oldsize;
        if (doRehash) {
            this.bdd_gbc_rehash();
        }
        this.bddresized = true;
        return 0;
    }

    protected void initialize(int initnodesize, int cs) {
        if (this.bddrunning) {
            JFactory.bdd_error(-5);
        }
        this.bddnodesize = this.bdd_prime_gte(initnodesize);
        this.bddnodes = new int[this.bddnodesize * 5];
        this.bddresized = false;
        for (int n = 0; n < this.bddnodesize; ++n) {
            this.SETLOW(n, -1);
            this.SETNEXT(n, n + 1);
        }
        this.SETNEXT(this.bddnodesize - 1, 0);
        this.SETMAXREF(0);
        this.SETMAXREF(1);
        this.SETLOW(0, 0);
        this.SETHIGH(0, 0);
        this.SETLOW(1, 1);
        this.SETHIGH(1, 1);
        this.bdd_operator_init(cs);
        this.bddfreepos = 2;
        this.bddfreenum = this.bddnodesize - 2;
        this.bddrunning = true;
        this.bddvarnum = 0;
        this.gbcollectnum = 0;
        this.gbcclock = 0L;
        this.cachesize = cs;
        this.usednodes_nextreorder = this.bddnodesize;
        this.bddmaxnodeincrease = 50000;
        this.bdderrorcond = 0;
        this.bdd_pairs_init();
        this.bdd_reorder_init();
    }

    void bdd_operator_init(int cachesize) {
        this.quantvarsetID = 0;
        this.quantvarset = null;
        this.cacheratio = 0;
        this.supportSet = null;
    }

    void bdd_operator_done() {
        if (this.quantvarset != null) {
            JFactory.free(this.quantvarset);
            this.quantvarset = null;
        }
        this.BddCache_done(this.applycache);
        this.applycache = null;
        this.BddCache_done(this.itecache);
        this.itecache = null;
        this.BddCache_done(this.quantcache);
        this.quantcache = null;
        this.BddCache_done(this.appexcache);
        this.appexcache = null;
        this.BddCache_done(this.replacecache);
        this.replacecache = null;
        this.BddCache_done(this.misccache);
        this.misccache = null;
        this.BddCache_done(this.countcache);
        this.countcache = null;
        if (this.supportSet != null) {
            JFactory.free(this.supportSet);
            this.supportSet = null;
        }
    }

    void bdd_operator_reset() {
        this.BddCache_reset(this.applycache);
        this.BddCache_reset(this.itecache);
        this.BddCache_reset(this.quantcache);
        this.BddCache_reset(this.appexcache);
        this.BddCache_reset(this.replacecache);
        this.BddCache_reset(this.misccache);
        this.BddCache_reset(this.countcache);
    }

    void bdd_operator_clean() {
        this.BddCache_clean_ab(this.applycache);
        this.BddCache_clean_abc(this.itecache);
        this.BddCache_clean_a(this.quantcache);
        this.BddCache_clean_ab(this.appexcache);
        this.BddCache_clean_ab(this.replacecache);
        this.BddCache_clean_ab(this.misccache);
        this.BddCache_clean_d(this.countcache);
    }

    void bdd_operator_varresize() {
        if (this.quantvarset != null) {
            JFactory.free(this.quantvarset);
        }
        this.quantvarset = new int[this.bddvarnum];
        this.quantvarsetID = 0;
        this.BddCache_reset(this.countcache);
    }

    public int setCacheSize(int newcachesize) {
        int old = this.cachesize;
        this.BddCache_resize(this.applycache, newcachesize);
        this.BddCache_resize(this.itecache, newcachesize);
        this.BddCache_resize(this.quantcache, newcachesize);
        this.BddCache_resize(this.appexcache, newcachesize);
        this.BddCache_resize(this.replacecache, newcachesize);
        this.BddCache_resize(this.misccache, newcachesize);
        this.BddCache_resize(this.countcache, newcachesize);
        return old;
    }

    void bdd_operator_noderesize() {
        if (this.cacheratio > 0) {
            int newcachesize = this.bddnodesize / this.cacheratio;
            this.BddCache_resize(this.applycache, newcachesize);
            this.BddCache_resize(this.itecache, newcachesize);
            this.BddCache_resize(this.quantcache, newcachesize);
            this.BddCache_resize(this.appexcache, newcachesize);
            this.BddCache_resize(this.replacecache, newcachesize);
            this.BddCache_resize(this.misccache, newcachesize);
            this.BddCache_resize(this.countcache, newcachesize);
        }
    }

    BddCache BddCacheI_init(int size) {
        size = this.bdd_prime_gte(size);
        BddCache cache = new BddCache();
        cache.table = new BddCacheDataI[size];
        for (int n = 0; n < size; ++n) {
            cache.table[n] = new BddCacheDataI();
            cache.table[n].a = -1;
        }
        cache.tablesize = size;
        return cache;
    }

    BddCache BddCacheD_init(int size) {
        size = this.bdd_prime_gte(size);
        BddCache cache = new BddCache();
        cache.table = new BddCacheDataD[size];
        for (int n = 0; n < size; ++n) {
            cache.table[n] = new BddCacheDataD();
            cache.table[n].a = -1;
        }
        cache.tablesize = size;
        return cache;
    }

    void BddCache_done(BddCache cache) {
        if (cache == null) {
            return;
        }
        JFactory.free(cache.table);
        cache.table = null;
        cache.tablesize = 0;
    }

    int BddCache_resize(BddCache cache, int newsize) {
        if (cache == null) {
            return 0;
        }
        boolean is_d = cache.table instanceof BddCacheDataD[];
        JFactory.free(cache.table);
        cache.table = null;
        newsize = this.bdd_prime_gte(newsize);
        cache.table = is_d ? new BddCacheDataD[newsize] : new BddCacheDataI[newsize];
        for (int n = 0; n < newsize; ++n) {
            cache.table[n] = is_d ? new BddCacheDataD() : new BddCacheDataI();
            cache.table[n].a = -1;
        }
        cache.tablesize = newsize;
        return 0;
    }

    BddCacheDataI BddCache_lookupI(BddCache cache, int hash) {
        return (BddCacheDataI)cache.table[Math.abs(hash % cache.tablesize)];
    }

    BddCacheDataD BddCache_lookupD(BddCache cache, int hash) {
        return (BddCacheDataD)cache.table[Math.abs(hash % cache.tablesize)];
    }

    void BddCache_reset(BddCache cache) {
        if (cache == null) {
            return;
        }
        for (int n = 0; n < cache.tablesize; ++n) {
            cache.table[n].a = -1;
        }
    }

    void BddCache_clean_d(BddCache cache) {
        if (cache == null) {
            return;
        }
        for (int n = 0; n < cache.tablesize; ++n) {
            int a = cache.table[n].a;
            if (a < 0 || this.LOW(a) != -1) continue;
            cache.table[n].a = -1;
        }
    }

    void BddCache_clean_a(BddCache cache) {
        if (cache == null) {
            return;
        }
        for (int n = 0; n < cache.tablesize; ++n) {
            int a = cache.table[n].a;
            if (a < 0 || this.LOW(a) != -1 && this.LOW(((BddCacheDataI)cache.table[n]).res) != -1) continue;
            cache.table[n].a = -1;
        }
    }

    void BddCache_clean_ab(BddCache cache) {
        if (cache == null) {
            return;
        }
        for (int n = 0; n < cache.tablesize; ++n) {
            int a = cache.table[n].a;
            if (a < 0 || this.LOW(a) != -1 && (cache.table[n].b == 0 || this.LOW(cache.table[n].b) != -1) && this.LOW(((BddCacheDataI)cache.table[n]).res) != -1) continue;
            cache.table[n].a = -1;
        }
    }

    void BddCache_clean_abc(BddCache cache) {
        if (cache == null) {
            return;
        }
        for (int n = 0; n < cache.tablesize; ++n) {
            int a = cache.table[n].a;
            if (a < 0 || this.LOW(a) != -1 && this.LOW(cache.table[n].b) != -1 && this.LOW(cache.table[n].c) != -1 && this.LOW(((BddCacheDataI)cache.table[n]).res) != -1) continue;
            cache.table[n].a = -1;
        }
    }

    void bdd_setpair(bddPair pair, int oldvar, int newvar) {
        if (pair == null) {
            return;
        }
        if (oldvar < 0 || oldvar > this.bddvarnum - 1) {
            JFactory.bdd_error(-2);
        }
        if (newvar < 0 || newvar > this.bddvarnum - 1) {
            JFactory.bdd_error(-2);
        }
        this.bdd_delref(pair.result[this.bddvar2level[oldvar]]);
        pair.result[this.bddvar2level[oldvar]] = this.bdd_ithvar(newvar);
        pair.id = this.update_pairsid();
        if (this.bddvar2level[oldvar] > pair.last) {
            pair.last = this.bddvar2level[oldvar];
        }
    }

    void bdd_setbddpair(bddPair pair, int oldvar, int newvar) {
        if (pair == null) {
            return;
        }
        this.CHECK(newvar);
        if (oldvar < 0 || oldvar >= this.bddvarnum) {
            JFactory.bdd_error(-2);
        }
        int oldlevel = this.bddvar2level[oldvar];
        this.bdd_delref(pair.result[oldlevel]);
        pair.result[oldlevel] = this.bdd_addref(newvar);
        pair.id = this.update_pairsid();
        if (oldlevel > pair.last) {
            pair.last = oldlevel;
        }
    }

    void bdd_resetpair(bddPair p) {
        for (int n = 0; n < this.bddvarnum; ++n) {
            p.result[n] = this.bdd_ithvar(this.bddlevel2var[n]);
        }
        p.last = 0;
    }

    static final void free(Object o) {
    }

    void bdd_pairs_init() {
        this.pairsid = 0;
        this.pairs = null;
    }

    void bdd_pairs_done() {
        bddPair p = this.pairs;
        while (p != null) {
            bddPair next = p.next;
            for (int n = 0; n < this.bddvarnum; ++n) {
                this.bdd_delref(p.result[n]);
            }
            p.result = null;
            JFactory.free(p.result);
            JFactory.free(p);
            p = next;
        }
    }

    int update_pairsid() {
        ++this.pairsid;
        if (this.pairsid == 0x1FFFFFFF) {
            this.pairsid = 0;
            bddPair p = this.pairs;
            while (p != null) {
                ++this.pairsid;
                p.id = p.id;
                p = p.next;
            }
            this.BddCache_reset(this.replacecache);
        }
        return this.pairsid;
    }

    void bdd_register_pair(bddPair p) {
        p.next = this.pairs;
        this.pairs = p;
    }

    void bdd_pairs_vardown(int level) {
        bddPair p = this.pairs;
        while (p != null) {
            int tmp = p.result[level];
            p.result[level] = p.result[level + 1];
            p.result[level + 1] = tmp;
            if (p.last == level) {
                ++p.last;
            }
            p = p.next;
        }
    }

    int bdd_pairs_resize(int oldsize, int newsize) {
        bddPair p = this.pairs;
        while (p != null) {
            int[] new_result = new int[newsize];
            System.arraycopy(p.result, 0, new_result, 0, oldsize);
            p.result = new_result;
            for (int n = oldsize; n < newsize; ++n) {
                p.result[n] = this.bdd_ithvar(this.bddlevel2var[n]);
            }
            p = p.next;
        }
        return 0;
    }

    void bdd_disable_reorder() {
        this.reorderdisabled = 1;
    }

    void bdd_enable_reorder() {
        this.reorderdisabled = 0;
    }

    void bdd_checkreorder() {
        this.bdd_reorder_auto();
        this.usednodes_nextreorder = 2 * (this.bddnodesize - this.bddfreenum);
        if (this.bdd_reorder_gain() < 20) {
            this.usednodes_nextreorder += this.usednodes_nextreorder * (20 - this.bdd_reorder_gain()) / 20;
        }
    }

    boolean bdd_reorder_ready() {
        return this.bddreordermethod != 0 && this.vartree != null && this.bddreordertimes != 0 && this.reorderdisabled == 0;
    }

    void bdd_reorder(int method) {
        int savemethod = this.bddreordermethod;
        int savetimes = this.bddreordertimes;
        this.bddreordermethod = method;
        this.bddreordertimes = 1;
        BddTree top = this.bddtree_new(-1);
        if (top != null && this.reorder_init() >= 0) {
            this.usednum_before = this.bddnodesize - this.bddfreenum;
            top.first = 0;
            top.last = this.bdd_varnum() - 1;
            top.fixed = false;
            top.next = null;
            top.nextlevel = this.vartree;
            this.reorder_block(top, method);
            this.vartree = top.nextlevel;
            JFactory.free(top);
            this.usednum_after = this.bddnodesize - this.bddfreenum;
            this.reorder_done();
            this.bddreordermethod = savemethod;
            this.bddreordertimes = savetimes;
        }
    }

    BddTree bddtree_new(int id) {
        BddTree t = new BddTree();
        t.last = -1;
        t.first = -1;
        t.fixed = true;
        t.nextlevel = null;
        t.prev = null;
        t.next = null;
        t.seq = null;
        t.id = id;
        return t;
    }

    BddTree reorder_block(BddTree t, int method) {
        if (t == null) {
            return null;
        }
        if (!t.fixed && t.nextlevel != null) {
            switch (method) {
                case 1: {
                    t.nextlevel = this.reorder_win2(t.nextlevel);
                    break;
                }
                case 2: {
                    t.nextlevel = this.reorder_win2ite(t.nextlevel);
                    break;
                }
                case 3: {
                    t.nextlevel = this.reorder_sift(t.nextlevel);
                    break;
                }
                case 4: {
                    t.nextlevel = this.reorder_siftite(t.nextlevel);
                    break;
                }
                case 5: {
                    t.nextlevel = this.reorder_win3(t.nextlevel);
                    break;
                }
                case 6: {
                    t.nextlevel = this.reorder_win3ite(t.nextlevel);
                    break;
                }
                case 7: {
                    t.nextlevel = this.reorder_random(t.nextlevel);
                }
            }
        }
        BddTree dis = t.nextlevel;
        while (dis != null) {
            this.reorder_block(dis, method);
            dis = dis.next;
        }
        if (t.seq != null) {
            this.varseq_qsort(t.seq, 0, t.last - t.first + 1);
        }
        return t;
    }

    void varseq_qsort(int[] target, int from, int to) {
        switch (to - from) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                if (this.bddvar2level[target[from]] <= this.bddvar2level[target[from + 1]]) {
                    return;
                }
                int x = target[from];
                target[from] = target[from + 1];
                target[from + 1] = x;
                return;
            }
        }
        int r = target[from];
        int s = target[(from + to) / 2];
        int t = target[to - 1];
        if (this.bddvar2level[r] <= this.bddvar2level[s]) {
            if (this.bddvar2level[s] > this.bddvar2level[t]) {
                if (this.bddvar2level[r] <= this.bddvar2level[t]) {
                    target[to - 1] = s;
                    target[(from + to) / 2] = t;
                } else {
                    target[to - 1] = s;
                    target[from] = t;
                    target[(from + to) / 2] = r;
                }
            }
        } else if (this.bddvar2level[r] <= this.bddvar2level[t]) {
            target[(from + to) / 2] = r;
            target[from] = s;
        } else if (this.bddvar2level[s] <= this.bddvar2level[t]) {
            target[to - 1] = r;
            target[(from + to) / 2] = t;
            target[from] = s;
        } else {
            target[to - 1] = r;
            target[from] = t;
        }
        int mid = target[(from + to) / 2];
        int i = from + 1;
        int j = to - 1;
        while (i + 1 != j) {
            int x;
            if (target[i] == mid) {
                target[i] = target[i + 1];
                target[i + 1] = mid;
            }
            if ((x = target[i]) <= mid) {
                ++i;
                continue;
            }
            x = target[--j];
            target[j] = target[i];
            target[i] = x;
        }
        this.varseq_qsort(target, from, i);
        this.varseq_qsort(target, i + 1, to);
    }

    BddTree reorder_win2(BddTree t) {
        BddTree dis = t;
        BddTree first = t;
        if (t == null) {
            return t;
        }
        if (this.verbose > 1) {
            System.out.println("Win2 start: " + this.reorder_nodenum() + " nodes");
            System.out.flush();
        }
        while (dis.next != null) {
            int best = this.reorder_nodenum();
            this.blockdown(dis);
            if (best < this.reorder_nodenum()) {
                this.blockdown(dis.prev);
                dis = dis.next;
            } else if (first == dis) {
                first = dis.prev;
            }
            if (this.verbose <= 1) continue;
            System.out.print(".");
            System.out.flush();
        }
        if (this.verbose > 1) {
            System.out.println();
            System.out.println("Win2 end: " + this.reorder_nodenum() + " nodes");
            System.out.flush();
        }
        return first;
    }

    BddTree reorder_win3(BddTree t) {
        BddTree dis = t;
        BddTree first = t;
        if (t == null) {
            return t;
        }
        if (this.verbose > 1) {
            System.out.println("Win3 start: " + this.reorder_nodenum() + " nodes");
            System.out.flush();
        }
        while (dis.next != null) {
            BddTree[] f = new BddTree[]{first};
            dis = this.reorder_swapwin3(dis, f);
            first = f[0];
            if (this.verbose <= 1) continue;
            System.out.print(".");
            System.out.flush();
        }
        if (this.verbose > 1) {
            System.out.println();
            System.out.println("Win3 end: " + this.reorder_nodenum() + " nodes");
            System.out.flush();
        }
        return first;
    }

    BddTree reorder_win3ite(BddTree t) {
        int lastsize;
        BddTree dis = t;
        BddTree first = t;
        if (t == null) {
            return t;
        }
        if (this.verbose > 1) {
            System.out.println("Win3ite start: " + this.reorder_nodenum() + " nodes");
        }
        do {
            lastsize = this.reorder_nodenum();
            dis = first;
            while (dis.next != null && dis.next.next != null) {
                BddTree[] f = new BddTree[]{first};
                dis = this.reorder_swapwin3(dis, f);
                first = f[0];
                if (this.verbose <= 1) continue;
                System.out.print(".");
                System.out.flush();
            }
            if (this.verbose <= 1) continue;
            System.out.println(" " + this.reorder_nodenum() + " nodes");
        } while (this.reorder_nodenum() != lastsize);
        if (this.verbose > 1) {
            System.out.println("Win3ite end: " + this.reorder_nodenum() + " nodes");
        }
        return first;
    }

    BddTree reorder_swapwin3(BddTree dis, BddTree[] first) {
        boolean setfirst = dis.prev == null;
        BddTree next = dis;
        int best = this.reorder_nodenum();
        if (dis.next.next == null) {
            this.blockdown(dis.prev);
            if (best < this.reorder_nodenum()) {
                this.blockdown(dis.prev);
                next = dis.next;
            } else {
                next = dis;
                if (setfirst) {
                    first[0] = dis.prev;
                }
            }
        } else {
            int pos = 0;
            this.blockdown(dis);
            ++pos;
            if (best > this.reorder_nodenum()) {
                pos = 0;
                best = this.reorder_nodenum();
            }
            this.blockdown(dis);
            ++pos;
            if (best > this.reorder_nodenum()) {
                pos = 0;
                best = this.reorder_nodenum();
            }
            dis = dis.prev.prev;
            this.blockdown(dis);
            ++pos;
            if (best > this.reorder_nodenum()) {
                pos = 0;
                best = this.reorder_nodenum();
            }
            this.blockdown(dis);
            ++pos;
            if (best > this.reorder_nodenum()) {
                pos = 0;
                best = this.reorder_nodenum();
            }
            dis = dis.prev.prev;
            this.blockdown(dis);
            ++pos;
            if (best > this.reorder_nodenum()) {
                pos = 0;
                best = this.reorder_nodenum();
            }
            if (pos >= 1) {
                dis = dis.prev;
                this.blockdown(dis);
                next = dis;
                if (setfirst) {
                    first[0] = dis.prev;
                }
            }
            if (pos >= 2) {
                this.blockdown(dis);
                next = dis.prev;
                if (setfirst) {
                    first[0] = dis.prev.prev;
                }
            }
            if (pos >= 3) {
                dis = dis.prev.prev;
                this.blockdown(dis);
                next = dis;
                if (setfirst) {
                    first[0] = dis.prev;
                }
            }
            if (pos >= 4) {
                this.blockdown(dis);
                next = dis.prev;
                if (setfirst) {
                    first[0] = dis.prev.prev;
                }
            }
            if (pos >= 5) {
                dis = dis.prev.prev;
                this.blockdown(dis);
                next = dis;
                if (setfirst) {
                    first[0] = dis.prev;
                }
            }
        }
        return next;
    }

    BddTree reorder_sift_seq(BddTree t, BddTree[] seq, int num) {
        if (t == null) {
            return t;
        }
        for (int n = 0; n < num; ++n) {
            long c1 = this.clock();
            if (this.verbose > 1) {
                System.out.print("Sift ");
                System.out.print(seq[n].id);
                System.out.print(": ");
            }
            this.reorder_sift_bestpos(seq[n], num / 2);
            if (this.verbose > 1) {
                System.out.println();
                System.out.print("> " + this.reorder_nodenum() + " nodes");
            }
            long c2 = this.clock();
            if (this.verbose <= 1) continue;
            System.out.println(" (" + (float)(c2 - c1) / 1000.0f + " sec)\n");
        }
        BddTree dis = t;
        while (dis.prev != null) {
            dis = dis.prev;
        }
        return dis;
    }

    void reorder_sift_bestpos(BddTree blk, int middlePos) {
        int best = this.reorder_nodenum();
        int bestpos = 0;
        boolean dirIsUp = true;
        int maxAllowed = this.bddmaxnodesize > 0 ? JFactory.MIN(best / 5 + best, this.bddmaxnodesize - this.bddmaxnodeincrease - 2) : best / 5 + best;
        if (blk.pos > middlePos) {
            dirIsUp = false;
        }
        for (int n = 0; n < 2; ++n) {
            boolean first = true;
            if (dirIsUp) {
                while (blk.prev != null && (this.reorder_nodenum() <= maxAllowed || first)) {
                    first = false;
                    this.blockdown(blk.prev);
                    --bestpos;
                    if (this.verbose > 1) {
                        System.out.print("-");
                        System.out.flush();
                    }
                    if (this.reorder_nodenum() >= best) continue;
                    best = this.reorder_nodenum();
                    bestpos = 0;
                    if (this.bddmaxnodesize > 0) {
                        maxAllowed = JFactory.MIN(best / 5 + best, this.bddmaxnodesize - this.bddmaxnodeincrease - 2);
                        continue;
                    }
                    maxAllowed = best / 5 + best;
                }
            } else {
                while (blk.next != null && (this.reorder_nodenum() <= maxAllowed || first)) {
                    first = false;
                    this.blockdown(blk);
                    ++bestpos;
                    if (this.verbose > 1) {
                        System.out.print("+");
                        System.out.flush();
                    }
                    if (this.reorder_nodenum() >= best) continue;
                    best = this.reorder_nodenum();
                    bestpos = 0;
                    if (this.bddmaxnodesize > 0) {
                        maxAllowed = JFactory.MIN(best / 5 + best, this.bddmaxnodesize - this.bddmaxnodeincrease - 2);
                        continue;
                    }
                    maxAllowed = best / 5 + best;
                }
            }
            if (this.reorder_nodenum() > maxAllowed && this.verbose > 1) {
                System.out.print("!");
                System.out.flush();
            }
            dirIsUp = !dirIsUp;
        }
        while (bestpos < 0) {
            this.blockdown(blk);
            ++bestpos;
        }
        while (bestpos > 0) {
            this.blockdown(blk.prev);
            --bestpos;
        }
    }

    BddTree reorder_random(BddTree t) {
        int num = 0;
        if (t == null) {
            return t;
        }
        BddTree dis = t;
        while (dis != null) {
            ++num;
            dis = dis.next;
        }
        BddTree[] seq = new BddTree[num];
        dis = t;
        num = 0;
        while (dis != null) {
            seq[num++] = dis;
            dis = dis.next;
        }
        for (int n = 0; n < 4 * num; ++n) {
            int blk = this.rng.nextInt(num);
            if (seq[blk].next == null) continue;
            this.blockdown(seq[blk]);
        }
        dis = t;
        while (dis.prev != null) {
            dis = dis.prev;
        }
        JFactory.free(seq);
        if (this.verbose != 0) {
            System.out.println("Random order: " + this.reorder_nodenum() + " nodes");
        }
        return dis;
    }

    static int siftTestCmp(Object aa, Object bb) {
        sizePair a = (sizePair)aa;
        sizePair b = (sizePair)bb;
        if (a.val < b.val) {
            return -1;
        }
        if (a.val > b.val) {
            return 1;
        }
        return 0;
    }

    BddTree reorder_sift(BddTree t) {
        BddTree dis = t;
        int num = 0;
        while (dis != null) {
            dis.pos = num++;
            dis = dis.next;
        }
        sizePair[] p = new sizePair[num];
        BddTree[] seq = new BddTree[num];
        dis = t;
        int n = 0;
        while (dis != null) {
            p[n].val = 0;
            for (int v = dis.first; v <= dis.last; ++v) {
                p[n].val -= this.levels[v].nodenum;
            }
            p[n].block = dis;
            dis = dis.next;
            ++n;
        }
        Arrays.sort(p, 0, num, new Comparator(){

            public int compare(Object o1, Object o2) {
                return JFactory.siftTestCmp(o1, o2);
            }
        });
        for (n = 0; n < num; ++n) {
            seq[n] = p[n].block;
        }
        t = this.reorder_sift_seq(t, seq, num);
        JFactory.free(seq);
        JFactory.free(p);
        return t;
    }

    BddTree reorder_siftite(BddTree t) {
        int lastsize;
        BddTree first = t;
        int c = 1;
        if (t == null) {
            return t;
        }
        do {
            if (this.verbose > 1) {
                System.out.println("Reorder " + c++ + "\n");
            }
            lastsize = this.reorder_nodenum();
            first = this.reorder_sift(first);
        } while (this.reorder_nodenum() != lastsize);
        return first;
    }

    void blockdown(BddTree left) {
        int n;
        BddTree right = left.next;
        int leftsize = left.last - left.first;
        int rightsize = right.last - right.first;
        int leftstart = this.bddvar2level[left.seq[0]];
        int[] lseq = left.seq;
        int[] rseq = right.seq;
        while (this.bddvar2level[lseq[0]] < this.bddvar2level[rseq[rightsize]]) {
            for (n = 0; n < leftsize; ++n) {
                if (this.bddvar2level[lseq[n]] + 1 == this.bddvar2level[lseq[n + 1]] || this.bddvar2level[lseq[n]] >= this.bddvar2level[rseq[rightsize]]) continue;
                this.reorder_vardown(lseq[n]);
            }
            if (this.bddvar2level[lseq[leftsize]] >= this.bddvar2level[rseq[rightsize]]) continue;
            this.reorder_vardown(lseq[leftsize]);
        }
        while (this.bddvar2level[rseq[0]] > leftstart) {
            for (n = rightsize; n > 0; --n) {
                if (this.bddvar2level[rseq[n]] - 1 == this.bddvar2level[rseq[n - 1]] || this.bddvar2level[rseq[n]] <= leftstart) continue;
                this.reorder_varup(rseq[n]);
            }
            if (this.bddvar2level[rseq[0]] <= leftstart) continue;
            this.reorder_varup(rseq[0]);
        }
        left.next = right.next;
        right.prev = left.prev;
        left.prev = right;
        right.next = left;
        if (right.prev != null) {
            right.prev.next = right;
        }
        if (left.next != null) {
            left.next.prev = left;
        }
        n = left.pos;
        left.pos = right.pos;
        right.pos = n;
    }

    BddTree reorder_win2ite(BddTree t) {
        int lastsize;
        BddTree first = t;
        int c = 1;
        if (t == null) {
            return t;
        }
        if (this.verbose > 1) {
            System.out.println("Win2ite start: " + this.reorder_nodenum() + " nodes");
        }
        do {
            lastsize = this.reorder_nodenum();
            BddTree dis = t;
            while (dis.next != null) {
                int best = this.reorder_nodenum();
                this.blockdown(dis);
                if (best < this.reorder_nodenum()) {
                    this.blockdown(dis.prev);
                    dis = dis.next;
                } else if (first == dis) {
                    first = dis.prev;
                }
                if (this.verbose <= 1) continue;
                System.out.print(".");
                System.out.flush();
            }
            if (this.verbose > 1) {
                System.out.println(" " + this.reorder_nodenum() + " nodes");
            }
            ++c;
        } while (this.reorder_nodenum() != lastsize);
        return first;
    }

    void bdd_reorder_auto() {
        if (!this.bdd_reorder_ready()) {
            return;
        }
        this.bdd_reorder(this.bddreordermethod);
        --this.bddreordertimes;
    }

    int bdd_reorder_gain() {
        if (this.usednum_before == 0) {
            return 0;
        }
        return 100 * (this.usednum_before - this.usednum_after) / this.usednum_before;
    }

    public boolean isInitialized() {
        return this.bddrunning;
    }

    public void done() {
        this.bdd_done();
    }

    void bdd_done() {
        this.bdd_pairs_done();
        JFactory.free(this.bddnodes);
        JFactory.free(this.bddrefstack);
        JFactory.free(this.bddvarset);
        JFactory.free(this.bddvar2level);
        JFactory.free(this.bddlevel2var);
        this.bddnodes = null;
        this.bddrefstack = null;
        this.bddvarset = null;
        this.bddvar2level = null;
        this.bddlevel2var = null;
        this.bdd_operator_done();
        this.bddrunning = false;
        this.bddnodesize = 0;
        this.bddmaxnodesize = 0;
        this.bddvarnum = 0;
        this.bddproduced = 0;
    }

    public void setError(int code) {
        this.bdderrorcond = code;
    }

    public void clearError() {
        this.bdderrorcond = 0;
    }

    public int setMaxNodeNum(int size) {
        return this.bdd_setmaxnodenum(size);
    }

    int bdd_setmaxnodenum(int size) {
        if (size > this.bddnodesize || size == 0) {
            int old = this.bddmaxnodesize;
            this.bddmaxnodesize = size;
            return old;
        }
        return JFactory.bdd_error(-11);
    }

    public double setMinFreeNodes(double x) {
        return (double)this.bdd_setminfreenodes((int)(x * 100.0)) / 100.0;
    }

    int bdd_setminfreenodes(int mf) {
        int old = this.minfreenodes;
        if (mf < 0 || mf > 100) {
            return JFactory.bdd_error(-3);
        }
        this.minfreenodes = mf;
        return old;
    }

    public int setMaxIncrease(int x) {
        return this.bdd_setmaxincrease(x);
    }

    int bdd_setmaxincrease(int size) {
        int old = this.bddmaxnodeincrease;
        if (size < 0) {
            return JFactory.bdd_error(-19);
        }
        this.bddmaxnodeincrease = size;
        return old;
    }

    public double setIncreaseFactor(double x) {
        if (x < 0.0) {
            return JFactory.bdd_error(-3);
        }
        double old = this.increasefactor;
        this.increasefactor = x;
        return old;
    }

    public double setCacheRatio(double x) {
        return (double)this.bdd_setcacheratio((int)(x * 100.0)) / 100.0;
    }

    int bdd_setcacheratio(int r) {
        int old = this.cacheratio;
        if (r <= 0) {
            return JFactory.bdd_error(-3);
        }
        if (this.bddnodesize == 0) {
            return old;
        }
        this.cacheratio = r;
        this.bdd_operator_noderesize();
        return old;
    }

    public int varNum() {
        return this.bdd_varnum();
    }

    public int setVarNum(int num) {
        return this.bdd_setvarnum(num);
    }

    public int duplicateVar(int var) {
        int i;
        if (var < 0 || var >= this.bddvarnum) {
            JFactory.bdd_error(-2);
            return 0;
        }
        this.bdd_disable_reorder();
        int newVar = this.bddvarnum;
        int lev = this.bddvar2level[var];
        this.bdd_setvarnum(this.bddvarnum + 1);
        this.insert_level(lev);
        this.dup_level(lev, 0);
        for (i = 0; i < this.bddvarnum; ++i) {
            if (this.bddvar2level[i] <= lev || this.bddvar2level[i] >= this.bddvarnum) continue;
            int n = i;
            this.bddvar2level[n] = this.bddvar2level[n] + 1;
        }
        this.bddvar2level[newVar] = lev + 1;
        for (i = this.bddvarnum - 2; i > lev; --i) {
            this.bddlevel2var[i + 1] = this.bddlevel2var[i];
        }
        this.bddlevel2var[lev + 1] = newVar;
        for (int bdv = 0; bdv < this.bddvarnum; ++bdv) {
            this.bddvarset[bdv * 2] = this.PUSHREF(this.bdd_makenode(this.bddvar2level[bdv], 0, 1));
            this.bddvarset[bdv * 2 + 1] = this.bdd_makenode(this.bddvar2level[bdv], 1, 0);
            this.POPREF(1);
            this.SETMAXREF(this.bddvarset[bdv * 2]);
            this.SETMAXREF(this.bddvarset[bdv * 2 + 1]);
        }
        bddPair pair = this.pairs;
        while (pair != null) {
            this.bdd_delref(pair.result[this.bddvarnum - 1]);
            for (int i2 = this.bddvarnum - 1; i2 > lev + 1; --i2) {
                pair.result[i2] = pair.result[i2 - 1];
                if (i2 == this.LEVEL(pair.result[i2]) || i2 <= pair.last) continue;
                pair.last = i2;
            }
            pair.result[lev + 1] = this.bdd_ithvar(newVar);
            pair = pair.next;
        }
        this.bdd_enable_reorder();
        return newVar;
    }

    int bdd_setvarnum(int num) {
        int oldbddvarnum = this.bddvarnum;
        if (num < 1 || num > 0x1FFFFF) {
            JFactory.bdd_error(-3);
            return 0;
        }
        if (num < this.bddvarnum) {
            return JFactory.bdd_error(-15);
        }
        if (num == this.bddvarnum) {
            return 0;
        }
        this.bdd_disable_reorder();
        if (this.bddvarset == null) {
            this.bddvarset = new int[num * 2];
            this.bddlevel2var = new int[num + 1];
            this.bddvar2level = new int[num + 1];
        } else {
            int[] bddvarset2 = new int[num * 2];
            System.arraycopy(this.bddvarset, 0, bddvarset2, 0, this.bddvarset.length);
            this.bddvarset = bddvarset2;
            int[] bddlevel2var2 = new int[num + 1];
            System.arraycopy(this.bddlevel2var, 0, bddlevel2var2, 0, this.bddlevel2var.length);
            this.bddlevel2var = bddlevel2var2;
            int[] bddvar2level2 = new int[num + 1];
            System.arraycopy(this.bddvar2level, 0, bddvar2level2, 0, this.bddvar2level.length);
            this.bddvar2level = bddvar2level2;
        }
        if (this.bddrefstack != null) {
            JFactory.free(this.bddrefstack);
        }
        this.bddrefstack = new int[num * 2 + 1];
        this.bddrefstacktop = 0;
        int bdv = this.bddvarnum;
        while (this.bddvarnum < num) {
            this.bddvarset[this.bddvarnum * 2] = this.PUSHREF(this.bdd_makenode(this.bddvarnum, 0, 1));
            this.bddvarset[this.bddvarnum * 2 + 1] = this.bdd_makenode(this.bddvarnum, 1, 0);
            this.POPREF(1);
            if (this.bdderrorcond != 0) {
                this.bddvarnum = bdv;
                return -this.bdderrorcond;
            }
            this.SETMAXREF(this.bddvarset[this.bddvarnum * 2]);
            this.SETMAXREF(this.bddvarset[this.bddvarnum * 2 + 1]);
            this.bddlevel2var[this.bddvarnum] = this.bddvarnum;
            this.bddvar2level[this.bddvarnum] = this.bddvarnum;
            ++this.bddvarnum;
        }
        this.SETLEVELANDMARK(0, num);
        this.SETLEVELANDMARK(1, num);
        this.bddvar2level[num] = num;
        this.bddlevel2var[num] = num;
        this.bdd_pairs_resize(oldbddvarnum, this.bddvarnum);
        this.bdd_operator_varresize();
        this.bdd_enable_reorder();
        return 0;
    }

    public BDD ithVar(int var) {
        return this.makeBDD(this.bdd_ithvar(var));
    }

    public BDD nithVar(int var) {
        return this.makeBDD(this.bdd_nithvar(var));
    }

    public void printAll() {
        this.bdd_fprintall(System.out);
    }

    public void printTable(BDD b) {
        int x = ((bdd)b)._index;
        this.bdd_fprinttable(System.out, x);
    }

    public BDD load(BufferedReader in) throws IOException {
        int result = this.bdd_load(in);
        return this.makeBDD(result);
    }

    public void save(BufferedWriter out, BDD b) throws IOException {
        int x = ((bdd)b)._index;
        this.bdd_save(out, x);
    }

    public int level2Var(int level) {
        return this.bddlevel2var[level];
    }

    public int var2Level(int var) {
        return this.bddvar2level[var];
    }

    public void reorder(BDDFactory.ReorderMethod m) {
        int x = m.id;
        this.bdd_reorder(x);
    }

    public void autoReorder(BDDFactory.ReorderMethod method) {
        int x = method.id;
        this.bdd_autoreorder(x);
    }

    public void autoReorder(BDDFactory.ReorderMethod method, int max) {
        int x = method.id;
        this.bdd_autoreorder_times(x, max);
    }

    public BDDFactory.ReorderMethod getReorderMethod() {
        switch (this.bddreordermethod) {
            case 0: {
                return REORDER_NONE;
            }
            case 1: {
                return REORDER_WIN2;
            }
            case 2: {
                return REORDER_WIN2ITE;
            }
            case 5: {
                return REORDER_WIN3;
            }
            case 6: {
                return REORDER_WIN3ITE;
            }
            case 3: {
                return REORDER_SIFT;
            }
            case 4: {
                return REORDER_SIFTITE;
            }
            case 7: {
                return REORDER_RANDOM;
            }
        }
        throw new BDDException();
    }

    public int getReorderTimes() {
        return this.bddreordertimes;
    }

    public void disableReorder() {
        this.bdd_disable_reorder();
    }

    public void enableReorder() {
        this.bdd_enable_reorder();
    }

    public int reorderVerbose(int v) {
        return this.bdd_reorder_verbose(v);
    }

    public void setVarOrder(int[] neworder) {
        this.bdd_setvarorder(neworder);
    }

    void bdd_reorder_init() {
        this.reorderdisabled = 0;
        this.vartree = null;
        this.bdd_clrvarblocks();
        this.bdd_reorder_verbose(0);
        this.bdd_autoreorder_times(0, 0);
        this.usednum_after = 0;
        this.usednum_before = 0;
        this.blockid = 0;
    }

    int reorder_nodenum() {
        return this.bdd_getnodenum();
    }

    int bdd_getnodenum() {
        return this.bddnodesize - this.bddfreenum;
    }

    int bdd_reorder_verbose(int v) {
        int tmp = this.verbose;
        this.verbose = v;
        return tmp;
    }

    int bdd_autoreorder(int method) {
        int tmp = this.bddreordermethod;
        this.bddreordermethod = method;
        this.bddreordertimes = -1;
        return tmp;
    }

    int bdd_autoreorder_times(int method, int num) {
        int tmp = this.bddreordermethod;
        this.bddreordermethod = method;
        this.bddreordertimes = num;
        return tmp;
    }

    void bdd_reorder_done() {
        this.bddtree_del(this.vartree);
        this.bdd_operator_reset();
        this.vartree = null;
    }

    void bddtree_del(BddTree t) {
        if (t == null) {
            return;
        }
        this.bddtree_del(t.nextlevel);
        this.bddtree_del(t.next);
        if (t.seq != null) {
            JFactory.free(t.seq);
        }
        t.seq = null;
        JFactory.free(t);
    }

    void bdd_clrvarblocks() {
        this.bddtree_del(this.vartree);
        this.vartree = null;
        this.blockid = 0;
    }

    int NODEHASHr(int var, int l, int h) {
        return Math.abs(JFactory.PAIR(l, h) % this.levels[var].size) + this.levels[var].start;
    }

    void bdd_setvarorder(int[] neworder) {
        if (this.vartree != null) {
            JFactory.bdd_error(-14);
            return;
        }
        this.reorder_init();
        for (int level = 0; level < this.bddvarnum; ++level) {
            int lowvar = neworder[level];
            while (this.bddvar2level[lowvar] > level) {
                this.reorder_varup(lowvar);
            }
        }
        this.reorder_done();
    }

    int reorder_varup(int var) {
        if (var < 0 || var >= this.bddvarnum) {
            return JFactory.bdd_error(-2);
        }
        if (this.bddvar2level[var] == 0) {
            return 0;
        }
        return this.reorder_vardown(this.bddlevel2var[this.bddvar2level[var] - 1]);
    }

    int reorder_vardown(int var) {
        if (var < 0 || var >= this.bddvarnum) {
            return JFactory.bdd_error(-2);
        }
        int level = this.bddvar2level[var];
        if (level >= this.bddvarnum - 1) {
            return 0;
        }
        this.resizedInMakenode = false;
        if (this.imatrixDepends(this.iactmtx, var, this.bddlevel2var[level + 1])) {
            int toBeProcessed = this.reorder_downSimple(var);
            levelData l = this.levels[var];
            if (l.nodenum < l.size / 3 || l.nodenum >= l.size * 3 / 2 && l.size < l.maxsize) {
                this.reorder_swapResize(toBeProcessed, var);
                this.reorder_localGbcResize(toBeProcessed, var);
            } else {
                this.reorder_swap(toBeProcessed, var);
                this.reorder_localGbc(var);
            }
        }
        int n = this.bddlevel2var[level];
        this.bddlevel2var[level] = this.bddlevel2var[level + 1];
        this.bddlevel2var[level + 1] = n;
        n = this.bddvar2level[var];
        this.bddvar2level[var] = this.bddvar2level[this.bddlevel2var[level]];
        this.bddvar2level[this.bddlevel2var[level]] = n;
        this.bdd_pairs_vardown(level);
        if (this.resizedInMakenode) {
            this.reorder_rehashAll();
        }
        return 0;
    }

    boolean imatrixDepends(imatrix mtx, int a, int b) {
        return (mtx.rows[a][b / 8] & 1 << b % 8) != 0;
    }

    void reorder_setLevellookup() {
        for (int n = 0; n < this.bddvarnum; ++n) {
            this.levels[n].maxsize = this.bddnodesize / this.bddvarnum;
            this.levels[n].start = n * this.levels[n].maxsize;
            this.levels[n].size = Math.min(this.levels[n].maxsize, this.levels[n].nodenum * 5 / 4);
            if (this.levels[n].size < 4) continue;
            this.levels[n].size = this.bdd_prime_lte(this.levels[n].size);
        }
    }

    void reorder_rehashAll() {
        int n;
        this.reorder_setLevellookup();
        this.bddfreepos = 0;
        for (n = this.bddnodesize - 1; n >= 0; --n) {
            this.SETHASH(n, 0);
        }
        for (n = this.bddnodesize - 1; n >= 2; --n) {
            if (this.HASREF(n)) {
                int hash2 = this.NODEHASH2(this.VARr(n), this.LOW(n), this.HIGH(n));
                this.SETNEXT(n, hash2);
                this.SETHASH(hash2, n);
                continue;
            }
            this.SETNEXT(n, this.bddfreepos);
            this.bddfreepos = n;
        }
    }

    void reorder_localGbc(int var0) {
        int var1 = this.bddlevel2var[this.bddvar2level[var0] + 1];
        int vl1 = this.levels[var1].start;
        int size1 = this.levels[var1].size;
        for (int n = 0; n < size1; ++n) {
            int hash = n + vl1;
            int r = this.HASH(hash);
            this.SETHASH(hash, 0);
            while (r != 0) {
                int next = this.NEXT(r);
                if (this.HASREF(r)) {
                    this.SETNEXT(r, this.HASH(hash));
                    this.SETHASH(hash, r);
                } else {
                    this.DECREF(this.LOW(r));
                    this.DECREF(this.HIGH(r));
                    this.SETLOW(r, -1);
                    this.SETNEXT(r, this.bddfreepos);
                    this.bddfreepos = r;
                    --this.levels[var1].nodenum;
                    ++this.bddfreenum;
                }
                r = next;
            }
        }
    }

    int reorder_downSimple(int var0) {
        int toBeProcessed = 0;
        int var1 = this.bddlevel2var[this.bddvar2level[var0] + 1];
        int vl0 = this.levels[var0].start;
        int size0 = this.levels[var0].size;
        this.levels[var0].nodenum = 0;
        for (int n = 0; n < size0; ++n) {
            int r = this.HASH(n + vl0);
            this.SETHASH(n + vl0, 0);
            while (r != 0) {
                int next = this.NEXT(r);
                if (this.VARr(this.LOW(r)) != var1 && this.VARr(this.HIGH(r)) != var1) {
                    this.SETNEXT(r, this.HASH(n + vl0));
                    this.SETHASH(n + vl0, r);
                    ++this.levels[var0].nodenum;
                } else {
                    this.SETNEXT(r, toBeProcessed);
                    toBeProcessed = r;
                }
                r = next;
            }
        }
        return toBeProcessed;
    }

    void reorder_swapResize(int toBeProcessed, int var0) {
        int var1 = this.bddlevel2var[this.bddvar2level[var0] + 1];
        while (toBeProcessed != 0) {
            int f11;
            int f10;
            int f01;
            int f00;
            int next = this.NEXT(toBeProcessed);
            int f0 = this.LOW(toBeProcessed);
            int f1 = this.HIGH(toBeProcessed);
            if (this.VARr(f0) == var1) {
                f00 = this.LOW(f0);
                f01 = this.HIGH(f0);
            } else {
                f00 = f01 = f0;
            }
            if (this.VARr(f1) == var1) {
                f10 = this.LOW(f1);
                f11 = this.HIGH(f1);
            } else {
                f10 = f11 = f1;
            }
            f0 = this.reorder_makenode(var0, f00, f10);
            f1 = this.reorder_makenode(var0, f01, f11);
            this.DECREF(this.LOW(toBeProcessed));
            this.DECREF(this.HIGH(toBeProcessed));
            this.SETVARr(toBeProcessed, var1);
            this.SETLOW(toBeProcessed, f0);
            this.SETHIGH(toBeProcessed, f1);
            ++this.levels[var1].nodenum;
            toBeProcessed = next;
        }
    }

    static final int MIN(int a, int b) {
        return Math.min(a, b);
    }

    void reorder_localGbcResize(int toBeProcessed, int var0) {
        int var1 = this.bddlevel2var[this.bddvar2level[var0] + 1];
        int vl1 = this.levels[var1].start;
        int size1 = this.levels[var1].size;
        for (int n = 0; n < size1; ++n) {
            int hash = n + vl1;
            int r = this.HASH(hash);
            this.SETHASH(hash, 0);
            while (r != 0) {
                int next = this.NEXT(r);
                if (this.HASREF(r)) {
                    this.SETNEXT(r, toBeProcessed);
                    toBeProcessed = r;
                } else {
                    this.DECREF(this.LOW(r));
                    this.DECREF(this.HIGH(r));
                    this.SETLOW(r, -1);
                    this.SETNEXT(r, this.bddfreepos);
                    this.bddfreepos = r;
                    --this.levels[var1].nodenum;
                    ++this.bddfreenum;
                }
                r = next;
            }
        }
        this.levels[var1].size = this.levels[var1].nodenum < this.levels[var1].size ? JFactory.MIN(this.levels[var1].maxsize, this.levels[var1].size / 2) : JFactory.MIN(this.levels[var1].maxsize, this.levels[var1].size * 2);
        if (this.levels[var1].size >= 4) {
            this.levels[var1].size = this.bdd_prime_lte(this.levels[var1].size);
        }
        while (toBeProcessed != 0) {
            int next = this.NEXT(toBeProcessed);
            int hash = this.NODEHASH2(this.VARr(toBeProcessed), this.LOW(toBeProcessed), this.HIGH(toBeProcessed));
            this.SETNEXT(toBeProcessed, this.HASH(hash));
            this.SETHASH(hash, toBeProcessed);
            toBeProcessed = next;
        }
    }

    void reorder_swap(int toBeProcessed, int var0) {
        int var1 = this.bddlevel2var[this.bddvar2level[var0] + 1];
        while (toBeProcessed != 0) {
            int f11;
            int f10;
            int f01;
            int f00;
            int next = this.NEXT(toBeProcessed);
            int f0 = this.LOW(toBeProcessed);
            int f1 = this.HIGH(toBeProcessed);
            if (this.VARr(f0) == var1) {
                f00 = this.LOW(f0);
                f01 = this.HIGH(f0);
            } else {
                f00 = f01 = f0;
            }
            if (this.VARr(f1) == var1) {
                f10 = this.LOW(f1);
                f11 = this.HIGH(f1);
            } else {
                f10 = f11 = f1;
            }
            f0 = this.reorder_makenode(var0, f00, f10);
            f1 = this.reorder_makenode(var0, f01, f11);
            this.DECREF(this.LOW(toBeProcessed));
            this.DECREF(this.HIGH(toBeProcessed));
            this.SETVARr(toBeProcessed, var1);
            this.SETLOW(toBeProcessed, f0);
            this.SETHIGH(toBeProcessed, f1);
            ++this.levels[var1].nodenum;
            int hash = this.NODEHASH2(this.VARr(toBeProcessed), this.LOW(toBeProcessed), this.HIGH(toBeProcessed));
            this.SETNEXT(toBeProcessed, this.HASH(hash));
            this.SETHASH(hash, toBeProcessed);
            toBeProcessed = next;
        }
    }

    int NODEHASH2(int var, int l, int h) {
        return Math.abs(JFactory.PAIR(l, h) % this.levels[var].size) + this.levels[var].start;
    }

    int reorder_makenode(int var, int low, int high) {
        if (low == high) {
            this.INCREF(low);
            return low;
        }
        int hash = this.NODEHASH2(var, low, high);
        int res = this.HASH(hash);
        while (res != 0) {
            if (this.LOW(res) == low && this.HIGH(res) == high) {
                this.INCREF(res);
                return res;
            }
            res = this.NEXT(res);
        }
        if (this.bddfreepos == 0) {
            if (this.bdderrorcond != 0) {
                return 0;
            }
            this.bdd_noderesize(false);
            this.resizedInMakenode = true;
            if (this.bddfreepos == 0) {
                JFactory.bdd_error(-17);
                this.bdderrorcond = Math.abs(-17);
                return 0;
            }
        }
        res = this.bddfreepos;
        this.bddfreepos = this.NEXT(this.bddfreepos);
        ++this.levels[var].nodenum;
        ++this.bddproduced;
        --this.bddfreenum;
        this.SETVARr(res, var);
        this.SETLOW(res, low);
        this.SETHIGH(res, high);
        this.SETNEXT(res, this.HASH(hash));
        this.SETHASH(hash, res);
        this.CLEARREF(res);
        this.INCREF(res);
        this.INCREF(this.LOW(res));
        this.INCREF(this.HIGH(res));
        return res;
    }

    int reorder_init() {
        this.reorder_handler(true, this.reorderstats);
        this.levels = new levelData[this.bddvarnum];
        for (int n = 0; n < this.bddvarnum; ++n) {
            this.levels[n] = new levelData();
            this.levels[n].start = -1;
            this.levels[n].size = 0;
            this.levels[n].nodenum = 0;
        }
        if (this.mark_roots() < 0) {
            return -1;
        }
        this.reorder_setLevellookup();
        this.reorder_gbc();
        return 0;
    }

    void insert_level(int levToInsert) {
        for (int n = 2; n < this.bddnodesize; ++n) {
            int lev;
            if (this.LOW(n) == -1 || (lev = this.LEVEL(n)) <= levToInsert || lev == this.bddvarnum - 1) continue;
            int lo = this.LOW(n);
            int hi = this.HIGH(n);
            int newLev = lev + 1;
            int hash = this.NODEHASH(lev, lo, hi);
            int r = this.HASH(hash);
            int r2 = 0;
            while (r != n && r != 0) {
                r2 = r;
                r = this.NEXT(r);
            }
            if (r == 0) {
                throw new InternalError();
            }
            int NEXT_r = this.NEXT(r);
            if (r2 == 0) {
                this.SETHASH(hash, NEXT_r);
            } else {
                this.SETNEXT(r2, NEXT_r);
            }
            this.SETLEVEL(n, newLev);
            lo = this.LOW(n);
            hi = this.HIGH(n);
            hash = this.NODEHASH(newLev, lo, hi);
            r = this.HASH(hash);
            this.SETHASH(hash, n);
            this.SETNEXT(n, r);
        }
    }

    void dup_level(int levToInsert, int val) {
        for (int n = 2; n < this.bddnodesize; ++n) {
            int lev;
            if (this.LOW(n) == -1 || (lev = this.LEVEL(n)) != levToInsert || lev == this.bddvarnum - 1) continue;
            int lo = this.LOW(n);
            int hi = this.HIGH(n);
            JFactory._assert(this.LEVEL(lo) > levToInsert + 1);
            JFactory._assert(this.LEVEL(hi) > levToInsert + 1);
            this.bdd_addref(n);
            int n_low = this.bdd_makenode(levToInsert + 1, val <= 0 ? lo : 0, val <= 0 ? 0 : lo);
            int n_high = this.bdd_makenode(levToInsert + 1, val == 0 ? hi : 0, val == 0 ? 0 : hi);
            this.bdd_delref(n);
            int newLev = lev;
            this.SETLOW(n, n_low);
            this.SETHIGH(n, n_high);
            int hash = this.NODEHASH(lev, lo, hi);
            int r = this.HASH(hash);
            int r2 = 0;
            while (r != n && r != 0) {
                r2 = r;
                r = this.NEXT(r);
            }
            if (r == 0) {
                throw new InternalError();
            }
            int NEXT_r = this.NEXT(r);
            if (r2 == 0) {
                this.SETHASH(hash, NEXT_r);
            } else {
                this.SETNEXT(r2, NEXT_r);
            }
            this.SETLEVEL(n, newLev);
            lo = this.LOW(n);
            hi = this.HIGH(n);
            hash = this.NODEHASH(newLev, lo, hi);
            r = this.HASH(hash);
            this.SETHASH(hash, n);
            this.SETNEXT(n, r);
        }
    }

    int mark_roots() {
        int n;
        boolean[] dep = new boolean[this.bddvarnum];
        this.extrootsize = 0;
        for (n = 2; n < this.bddnodesize; ++n) {
            this.SETLEVELANDMARK(n, this.bddlevel2var[this.LEVELANDMARK(n)]);
            if (!this.HASREF(n)) continue;
            this.SETMARK(n);
            ++this.extrootsize;
        }
        this.extroots = new int[this.extrootsize];
        this.iactmtx = this.imatrixNew(this.bddvarnum);
        this.extrootsize = 0;
        for (n = 2; n < this.bddnodesize; ++n) {
            if (this.MARKED(n)) {
                this.UNMARK(n);
                this.extroots[this.extrootsize++] = n;
                for (int i = 0; i < this.bddvarnum; ++i) {
                    dep[i] = false;
                }
                dep[this.VARr((int)n)] = true;
                ++this.levels[this.VARr((int)n)].nodenum;
                this.addref_rec(this.LOW(n), dep);
                this.addref_rec(this.HIGH(n), dep);
                this.addDependencies(dep);
            }
            this.SETHASH(n, 0);
        }
        this.SETHASH(0, 0);
        this.SETHASH(1, 0);
        JFactory.free(dep);
        return 0;
    }

    imatrix imatrixNew(int size) {
        imatrix mtx = new imatrix();
        mtx.rows = new byte[size][];
        for (int n = 0; n < size; ++n) {
            mtx.rows[n] = new byte[size / 8 + 1];
        }
        mtx.size = size;
        return mtx;
    }

    void addref_rec(int r, boolean[] dep) {
        if (r < 2) {
            return;
        }
        if (!this.HASREF(r) || this.MARKED(r)) {
            --this.bddfreenum;
            dep[this.VARr((int)r) & 0xFFDFFFFF] = true;
            ++this.levels[this.VARr((int)r) & 0xFFDFFFFF].nodenum;
            this.addref_rec(this.LOW(r), dep);
            this.addref_rec(this.HIGH(r), dep);
        } else {
            for (int n = 0; n < this.bddvarnum; ++n) {
                int n2 = n;
                dep[n2] = dep[n2] | this.imatrixDepends(this.iactmtx, this.VARr(r) & 0xFFDFFFFF, n);
            }
        }
        this.INCREF(r);
    }

    void addDependencies(boolean[] dep) {
        for (int n = 0; n < this.bddvarnum; ++n) {
            for (int m = n; m < this.bddvarnum; ++m) {
                if (!dep[n] || !dep[m]) continue;
                this.imatrixSet(this.iactmtx, n, m);
                this.imatrixSet(this.iactmtx, m, n);
            }
        }
    }

    void imatrixSet(imatrix mtx, int a, int b) {
        byte[] byArray = mtx.rows[a];
        int n = b / 8;
        byArray[n] = (byte)(byArray[n] | 1 << b % 8);
    }

    void reorder_gbc() {
        this.bddfreepos = 0;
        this.bddfreenum = 0;
        for (int n = this.bddnodesize - 1; n >= 2; --n) {
            if (this.HASREF(n)) {
                int hash = this.NODEHASH2(this.VARr(n), this.LOW(n), this.HIGH(n));
                this.SETNEXT(n, this.HASH(hash));
                this.SETHASH(hash, n);
                continue;
            }
            this.SETLOW(n, -1);
            this.SETNEXT(n, this.bddfreepos);
            this.bddfreepos = n;
            ++this.bddfreenum;
        }
    }

    void reorder_done() {
        int n;
        for (n = 0; n < this.extrootsize; ++n) {
            this.SETMARK(this.extroots[n]);
        }
        for (n = 2; n < this.bddnodesize; ++n) {
            if (this.MARKED(n)) {
                this.UNMARK(n);
            } else {
                this.CLEARREF(n);
            }
            this.SETLEVELANDMARK(n, this.bddvar2level[this.LEVELANDMARK(n)]);
        }
        JFactory.free(this.extroots);
        JFactory.free(this.levels);
        this.imatrixDelete(this.iactmtx);
        this.bdd_gbc();
        this.reorder_handler(false, this.reorderstats);
    }

    void imatrixDelete(imatrix mtx) {
        for (int n = 0; n < mtx.size; ++n) {
            JFactory.free(mtx.rows[n]);
            mtx.rows[n] = null;
        }
        JFactory.free(mtx.rows);
        mtx.rows = null;
        JFactory.free(mtx);
    }

    public void addVarBlock(BDD var, boolean fixed) {
        int[] set = var.scanSet();
        this.bdd_addvarblock(set, fixed);
    }

    public void addVarBlock(int first, int last, boolean fixed) {
        this.bdd_intaddvarblock(first, last, fixed);
    }

    public void varBlockAll() {
        this.bdd_varblockall();
    }

    public void clearVarBlocks() {
        this.bdd_clrvarblocks();
    }

    public void printOrder() {
        this.bdd_fprintorder(System.out);
    }

    public int nodeCount(Collection r) {
        int[] a = new int[r.size()];
        int j = 0;
        Iterator i = r.iterator();
        while (i.hasNext()) {
            bdd b = (bdd)i.next();
            a[j++] = b._index;
        }
        return this.bdd_anodecount(a);
    }

    public int getNodeTableSize() {
        return this.bdd_getallocnum();
    }

    int bdd_getallocnum() {
        return this.bddnodesize;
    }

    public int getNodeNum() {
        return this.bdd_getnodenum();
    }

    public int getCacheSize() {
        return this.cachesize;
    }

    public int reorderGain() {
        return this.bdd_reorder_gain();
    }

    public void printStat() {
        this.bdd_fprintstat(System.out);
    }

    public BDDPairing makePair() {
        bddPair p = new bddPair();
        p.result = new int[this.bddvarnum];
        for (int n = 0; n < this.bddvarnum; ++n) {
            p.result[n] = this.bdd_ithvar(this.bddlevel2var[n]);
        }
        p.id = this.update_pairsid();
        p.last = -1;
        this.bdd_register_pair(p);
        return p;
    }

    public void swapVar(int v1, int v2) {
        this.bdd_swapvar(v1, v2);
    }

    int bdd_swapvar(int v1, int v2) {
        if (this.vartree != null) {
            return JFactory.bdd_error(-14);
        }
        if (v1 == v2) {
            return 0;
        }
        if (v1 < 0 || v1 >= this.bddvarnum || v2 < 0 || v2 >= this.bddvarnum) {
            return JFactory.bdd_error(-2);
        }
        int l1 = this.bddvar2level[v1];
        int l2 = this.bddvar2level[v2];
        if (l1 > l2) {
            int tmp = v1;
            v1 = v2;
            v2 = tmp;
            l1 = this.bddvar2level[v1];
            l2 = this.bddvar2level[v2];
        }
        this.reorder_init();
        while (this.bddvar2level[v1] < l2) {
            this.reorder_vardown(v1);
        }
        while (this.bddvar2level[v2] > l1) {
            this.reorder_varup(v2);
        }
        this.reorder_done();
        return 0;
    }

    void bdd_fprintall(PrintStream out) {
        for (int n = 0; n < this.bddnodesize; ++n) {
            if (this.LOW(n) == -1) continue;
            out.print("[" + JFactory.right(n, 5) + " - " + JFactory.right(this.GETREF(n), 2) + "] ");
            out.print(JFactory.right(this.bddlevel2var[this.LEVEL(n)], 3));
            out.print(": " + JFactory.right(this.LOW(n), 3));
            out.println(" " + JFactory.right(this.HIGH(n), 3));
        }
    }

    void bdd_fprinttable(PrintStream out, int r) {
        out.println("ROOT: " + r);
        if (r < 2) {
            return;
        }
        this.bdd_mark(r);
        for (int n = 0; n < this.bddnodesize; ++n) {
            if (!this.MARKED(n)) continue;
            this.UNMARK(n);
            out.print("[" + JFactory.right(n, 5) + "] ");
            out.print(JFactory.right(this.bddlevel2var[this.LEVEL(n)], 3));
            out.print(": " + JFactory.right(this.LOW(n), 3));
            out.println(" " + JFactory.right(this.HIGH(n), 3));
        }
    }

    int bdd_load(BufferedReader ifile) throws IOException {
        int n;
        this.lh_nodenum = Integer.parseInt(this.readNext(ifile));
        int vnum = Integer.parseInt(this.readNext(ifile));
        if (this.lh_nodenum == 0 && vnum == 0) {
            int root = Integer.parseInt(this.readNext(ifile));
            return root;
        }
        this.loadvar2level = new int[vnum];
        for (n = 0; n < vnum; ++n) {
            this.loadvar2level[n] = Integer.parseInt(this.readNext(ifile));
        }
        if (vnum > this.bddvarnum) {
            this.bdd_setvarnum(vnum);
        }
        this.lh_table = new LoadHash[this.lh_nodenum];
        for (n = 0; n < this.lh_nodenum; ++n) {
            this.lh_table[n] = new LoadHash();
            this.lh_table[n].first = -1;
            this.lh_table[n].next = n + 1;
        }
        this.lh_table[this.lh_nodenum - 1].next = -1;
        this.lh_freepos = 0;
        int tmproot = this.bdd_loaddata(ifile);
        for (n = 0; n < this.lh_nodenum; ++n) {
            this.bdd_delref(this.lh_table[n].data);
        }
        JFactory.free(this.lh_table);
        this.lh_table = null;
        JFactory.free(this.loadvar2level);
        this.loadvar2level = null;
        int root = tmproot;
        return root;
    }

    int bdd_loaddata(BufferedReader ifile) throws IOException {
        int root = 0;
        for (int n = 0; n < this.lh_nodenum; ++n) {
            int key = Integer.parseInt(this.readNext(ifile));
            int var = Integer.parseInt(this.readNext(ifile));
            int low = Integer.parseInt(this.readNext(ifile));
            int high = Integer.parseInt(this.readNext(ifile));
            if (low >= 2) {
                low = this.loadhash_get(low);
            }
            if (high >= 2) {
                high = this.loadhash_get(high);
            }
            if (low < 0 || high < 0 || var < 0) {
                return JFactory.bdd_error(-7);
            }
            root = this.bdd_addref(this.bdd_ite(this.bdd_ithvar(var), high, low));
            this.loadhash_add(key, root);
        }
        return root;
    }

    void loadhash_add(int key, int data) {
        int hash = key % this.lh_nodenum;
        int pos = this.lh_freepos;
        this.lh_freepos = this.lh_table[pos].next;
        this.lh_table[pos].next = this.lh_table[hash].first;
        this.lh_table[hash].first = pos;
        this.lh_table[pos].key = key;
        this.lh_table[pos].data = data;
    }

    int loadhash_get(int key) {
        int hash = this.lh_table[key % this.lh_nodenum].first;
        while (hash != -1 && this.lh_table[hash].key != key) {
            hash = this.lh_table[hash].next;
        }
        if (hash == -1) {
            return -1;
        }
        return this.lh_table[hash].data;
    }

    void bdd_save(BufferedWriter out, int r) throws IOException {
        int[] n = new int[1];
        if (r < 2) {
            out.write("0 0 " + r + "\n");
            return;
        }
        this.bdd_markcount(r, n);
        this.bdd_unmark(r);
        out.write(n[0] + " " + this.bddvarnum + "\n");
        for (int x = 0; x < this.bddvarnum; ++x) {
            out.write(this.bddvar2level[x] + " ");
        }
        out.write("\n");
        this.bdd_save_rec(out, r);
        this.bdd_unmark(r);
        out.flush();
    }

    void bdd_save_rec(BufferedWriter out, int root) throws IOException {
        if (root < 2) {
            return;
        }
        if (this.MARKED(root)) {
            return;
        }
        this.SETMARK(root);
        this.bdd_save_rec(out, this.LOW(root));
        this.bdd_save_rec(out, this.HIGH(root));
        out.write(root + " ");
        out.write(this.bddlevel2var[this.LEVEL(root)] + " ");
        out.write(this.LOW(root) + " ");
        out.write(this.HIGH(root) + "\n");
    }

    static String right(int x, int w) {
        return JFactory.right(Integer.toString(x), w);
    }

    static String right(String s, int w) {
        int n = s.length();
        StringBuffer b = new StringBuffer(w);
        for (int i = n; i < w; ++i) {
            b.append(' ');
        }
        b.append(s);
        return b.toString();
    }

    int bdd_addvarblock(int[] v, boolean fixed) {
        int last;
        if (v.length < 1) {
            return JFactory.bdd_error(-14);
        }
        int first = last = v[0];
        for (int n = 0; n < v.length; ++n) {
            if (v[n] < first) {
                first = v[n];
            }
            if (v[n] <= last) continue;
            last = v[n];
        }
        BddTree t = this.bddtree_addrange(this.vartree, first, last, fixed, this.blockid);
        if (t == null) {
            return JFactory.bdd_error(-14);
        }
        this.vartree = t;
        return this.blockid++;
    }

    int bdd_intaddvarblock(int first, int last, boolean fixed) {
        if (first < 0 || first >= this.bddvarnum || last < 0 || last >= this.bddvarnum) {
            return JFactory.bdd_error(-2);
        }
        BddTree t = this.bddtree_addrange(this.vartree, first, last, fixed, this.blockid);
        if (t == null) {
            return JFactory.bdd_error(-14);
        }
        this.vartree = t;
        return this.blockid++;
    }

    BddTree bddtree_addrange_rec(BddTree t, BddTree prev, int first, int last, boolean fixed, int id) {
        if (first < 0 || last < 0 || last < first) {
            return null;
        }
        if (t == null) {
            t = this.bddtree_new(id);
            if (t == null) {
                return null;
            }
            t.first = first;
            t.fixed = fixed;
            t.seq = new int[last - first + 1];
            t.last = last;
            this.update_seq(t);
            t.prev = prev;
            return t;
        }
        if (first == t.first && last == t.last) {
            return t;
        }
        if (last < t.first) {
            BddTree tnew = this.bddtree_new(id);
            if (tnew == null) {
                return null;
            }
            tnew.first = first;
            tnew.last = last;
            tnew.fixed = fixed;
            tnew.seq = new int[last - first + 1];
            this.update_seq(tnew);
            tnew.next = t;
            tnew.prev = t.prev;
            t.prev = tnew;
            return tnew;
        }
        if (first > t.last) {
            t.next = this.bddtree_addrange_rec(t.next, t, first, last, fixed, id);
            return t;
        }
        if (first >= t.first && last <= t.last) {
            t.nextlevel = this.bddtree_addrange_rec(t.nextlevel, null, first, last, fixed, id);
            return t;
        }
        if (first <= t.first) {
            BddTree dis = t;
            while (true) {
                if (last >= dis.first && last < dis.last) {
                    return null;
                }
                if (dis.next == null || last < dis.next.first) {
                    BddTree tnew = this.bddtree_new(id);
                    if (tnew == null) {
                        return null;
                    }
                    tnew.first = first;
                    tnew.last = last;
                    tnew.fixed = fixed;
                    tnew.seq = new int[last - first + 1];
                    this.update_seq(tnew);
                    tnew.nextlevel = t;
                    tnew.next = dis.next;
                    tnew.prev = t.prev;
                    if (dis.next != null) {
                        dis.next.prev = tnew;
                    }
                    dis.next = null;
                    t.prev = null;
                    return tnew;
                }
                dis = dis.next;
            }
        }
        return null;
    }

    void update_seq(BddTree t) {
        int n;
        int low = t.first;
        for (n = t.first; n <= t.last; ++n) {
            if (this.bddvar2level[n] >= this.bddvar2level[low]) continue;
            low = n;
        }
        for (n = t.first; n <= t.last; ++n) {
            t.seq[this.bddvar2level[n] - this.bddvar2level[low]] = n;
        }
    }

    BddTree bddtree_addrange(BddTree t, int first, int last, boolean fixed, int id) {
        return this.bddtree_addrange_rec(t, null, first, last, fixed, id);
    }

    void bdd_varblockall() {
        for (int n = 0; n < this.bddvarnum; ++n) {
            this.bdd_intaddvarblock(n, n, true);
        }
    }

    void print_order_rec(PrintStream o, BddTree t, int level) {
        if (t == null) {
            return;
        }
        if (t.nextlevel != null) {
            int i;
            for (i = 0; i < level; ++i) {
                o.print("   ");
            }
            o.print(JFactory.right(t.id, 3));
            o.println("{\n");
            this.print_order_rec(o, t.nextlevel, level + 1);
            for (i = 0; i < level; ++i) {
                o.print("   ");
            }
            o.print(JFactory.right(t.id, 3));
            o.println("}\n");
            this.print_order_rec(o, t.next, level);
        } else {
            for (int i = 0; i < level; ++i) {
                o.print("   ");
            }
            o.println(JFactory.right(t.id, 3));
            this.print_order_rec(o, t.next, level);
        }
    }

    void bdd_fprintorder(PrintStream ofile) {
        this.print_order_rec(ofile, this.vartree, 0);
    }

    void bdd_fprintstat(PrintStream out) {
        BDDFactory.CacheStats s = this.cachestats;
        out.print(s.toString());
    }

    public void validateAll() {
        this.validate_all();
    }

    public void validateBDD(BDD b) {
        this.validate(((bdd)b)._index);
    }

    void validate_all() {
        for (int n = this.bddnodesize - 1; n >= 2; --n) {
            if (!this.HASREF(n)) continue;
            this.validate(n);
        }
    }

    void validate(int k) {
        this.validate(k, -1);
    }

    void validate(int k, int lastLevel) {
        if (k < 2) {
            return;
        }
        int lev = this.LEVEL(k);
        if (lev <= lastLevel) {
            throw new BDDException(lev + " <= " + lastLevel);
        }
        this.validate(this.LOW(k), lev);
        this.validate(this.HIGH(k), lev);
    }

    protected BDDDomain createDomain(int a, BigInteger b) {
        return new bddDomain(a, b);
    }

    protected BDDBitVector createBitVector(int a) {
        return new bvec(a);
    }

    final int Random(int i) {
        return this.rng.nextInt(i) + 1;
    }

    static boolean isEven(int src) {
        return (src & 1) == 0;
    }

    static boolean hasFactor(int src, int n) {
        return src != n && src % n == 0;
    }

    static boolean BitIsSet(int src, int b) {
        return (src & 1 << b) != 0;
    }

    static final int u64_mulmod(int a, int b, int c) {
        return (int)((long)a * (long)b % (long)c);
    }

    static int numberOfBits(int src) {
        if (src == 0) {
            return 0;
        }
        for (int b = 31; b > 0; --b) {
            if (!JFactory.BitIsSet(src, b)) continue;
            return b + 1;
        }
        return 1;
    }

    static boolean isWitness(int witness, int src) {
        int bitNum = JFactory.numberOfBits(src - 1) - 1;
        int d = 1;
        for (int i = bitNum; i >= 0; --i) {
            int x = d;
            if ((d = JFactory.u64_mulmod(d, d, src)) == 1 && x != 1 && x != src - 1) {
                return true;
            }
            if (!JFactory.BitIsSet(src - 1, i)) continue;
            d = JFactory.u64_mulmod(d, witness, src);
        }
        return d != 1;
    }

    boolean isMillerRabinPrime(int src) {
        for (int n = 0; n < 20; ++n) {
            int witness = this.Random(src - 1);
            if (!JFactory.isWitness(witness, src)) continue;
            return false;
        }
        return true;
    }

    static boolean hasEasyFactors(int src) {
        return JFactory.hasFactor(src, 3) || JFactory.hasFactor(src, 5) || JFactory.hasFactor(src, 7) || JFactory.hasFactor(src, 11) || JFactory.hasFactor(src, 13);
    }

    boolean isPrime(int src) {
        if (JFactory.hasEasyFactors(src)) {
            return false;
        }
        return this.isMillerRabinPrime(src);
    }

    int bdd_prime_gte(int src) {
        if (JFactory.isEven(src)) {
            ++src;
        }
        while (!this.isPrime(src)) {
            src += 2;
        }
        return src;
    }

    int bdd_prime_lte(int src) {
        if (JFactory.isEven(src)) {
            --src;
        }
        while (!this.isPrime(src)) {
            src -= 2;
        }
        return src;
    }

    public JFactory cloneFactory() {
        JFactory INSTANCE = new JFactory();
        if (this.applycache != null) {
            INSTANCE.applycache = this.applycache.copy();
        }
        if (this.itecache != null) {
            INSTANCE.itecache = this.itecache.copy();
        }
        if (this.quantcache != null) {
            INSTANCE.quantcache = this.quantcache.copy();
        }
        INSTANCE.appexcache = this.appexcache.copy();
        if (this.replacecache != null) {
            INSTANCE.replacecache = this.replacecache.copy();
        }
        if (this.misccache != null) {
            INSTANCE.misccache = this.misccache.copy();
        }
        if (this.countcache != null) {
            INSTANCE.countcache = this.countcache.copy();
        }
        INSTANCE.rng = new Random();
        INSTANCE.verbose = this.verbose;
        INSTANCE.cachestats.copyFrom(this.cachestats);
        INSTANCE.bddrunning = this.bddrunning;
        INSTANCE.bdderrorcond = this.bdderrorcond;
        INSTANCE.bddnodesize = this.bddnodesize;
        INSTANCE.bddmaxnodesize = this.bddmaxnodesize;
        INSTANCE.bddmaxnodeincrease = this.bddmaxnodeincrease;
        INSTANCE.bddfreepos = this.bddfreepos;
        INSTANCE.bddfreenum = this.bddfreenum;
        INSTANCE.bddproduced = this.bddproduced;
        INSTANCE.bddvarnum = this.bddvarnum;
        INSTANCE.gbcollectnum = this.gbcollectnum;
        INSTANCE.cachesize = this.cachesize;
        INSTANCE.gbcclock = this.gbcclock;
        INSTANCE.usednodes_nextreorder = this.usednodes_nextreorder;
        INSTANCE.bddrefstacktop = this.bddrefstacktop;
        INSTANCE.bddresized = this.bddresized;
        INSTANCE.minfreenodes = this.minfreenodes;
        INSTANCE.bddnodes = new int[this.bddnodes.length];
        System.arraycopy(this.bddnodes, 0, INSTANCE.bddnodes, 0, this.bddnodes.length);
        INSTANCE.bddrefstack = new int[this.bddrefstack.length];
        System.arraycopy(this.bddrefstack, 0, INSTANCE.bddrefstack, 0, this.bddrefstack.length);
        INSTANCE.bddvar2level = new int[this.bddvar2level.length];
        System.arraycopy(this.bddvar2level, 0, INSTANCE.bddvar2level, 0, this.bddvar2level.length);
        INSTANCE.bddlevel2var = new int[this.bddlevel2var.length];
        System.arraycopy(this.bddlevel2var, 0, INSTANCE.bddlevel2var, 0, this.bddlevel2var.length);
        INSTANCE.bddvarset = new int[this.bddvarset.length];
        System.arraycopy(this.bddvarset, 0, INSTANCE.bddvarset, 0, this.bddvarset.length);
        INSTANCE.domain = new BDDDomain[this.domain.length];
        for (int i = 0; i < INSTANCE.domain.length; ++i) {
            INSTANCE.domain[i] = INSTANCE.createDomain(i, this.domain[i].realsize);
        }
        return INSTANCE;
    }

    public BDD copyNode(BDD that) {
        bdd b = (bdd)that;
        return this.makeBDD(b._index);
    }

    private class bvec
    extends BDDBitVector {
        protected bvec(int bitnum) {
            super(bitnum);
        }

        public BDDFactory getFactory() {
            return JFactory.this;
        }
    }

    private class bddDomain
    extends BDDDomain {
        bddDomain(int a, BigInteger b) {
            super(a, b);
        }

        public BDDFactory getFactory() {
            return JFactory.this;
        }
    }

    static class LoadHash {
        int key;
        int data;
        int first;
        int next;

        LoadHash() {
        }
    }

    static class imatrix {
        byte[][] rows;
        int size;

        imatrix() {
        }
    }

    static class levelData {
        int start;
        int size;
        int maxsize;
        int nodenum;

        levelData() {
        }
    }

    static class BddTree {
        int first;
        int last;
        int pos;
        int[] seq;
        boolean fixed;
        int id;
        BddTree next;
        BddTree prev;
        BddTree nextlevel;

        BddTree() {
        }
    }

    static class sizePair {
        int val;
        BddTree block;

        sizePair() {
        }
    }

    class bddPair
    extends BDDPairing {
        int[] result;
        int last;
        int id;
        bddPair next;

        bddPair() {
        }

        public void set(int oldvar, int newvar) {
            JFactory.this.bdd_setpair(this, oldvar, newvar);
        }

        public void set(int oldvar, BDD newvar) {
            JFactory.this.bdd_setbddpair(this, oldvar, ((bdd)newvar)._index);
        }

        public void reset() {
            JFactory.this.bdd_resetpair(this);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            boolean any = false;
            for (int i = 0; i < this.result.length; ++i) {
                if (this.result[i] == JFactory.this.bdd_ithvar(JFactory.this.bddlevel2var[i])) continue;
                if (any) {
                    sb.append(", ");
                }
                any = true;
                sb.append(JFactory.this.bddlevel2var[i]);
                sb.append('=');
                bdd b = new bdd(this.result[i]);
                sb.append(b);
                b.free();
            }
            sb.append('}');
            return sb.toString();
        }
    }

    private static class ReorderException
    extends RuntimeException {
        private static final long serialVersionUID = 3256727264505772345L;

        private ReorderException() {
        }
    }

    private static class JavaBDDException
    extends BDDException {
        private static final long serialVersionUID = 3257289144995952950L;

        public JavaBDDException(int x) {
            super(errorstrings[-x]);
        }
    }

    private static class BddCache {
        BddCacheData[] table;
        int tablesize;

        private BddCache() {
        }

        BddCache copy() {
            BddCache that = new BddCache();
            boolean is_d = this.table instanceof BddCacheDataD[];
            that.table = is_d ? new BddCacheDataD[this.table.length] : new BddCacheDataI[this.table.length];
            that.tablesize = this.tablesize;
            for (int i = 0; i < this.table.length; ++i) {
                that.table[i] = this.table[i].copy();
            }
            return that;
        }
    }

    private static class BddCacheDataD
    extends BddCacheData {
        double dres;

        private BddCacheDataD() {
        }

        BddCacheData copy() {
            BddCacheDataD that = new BddCacheDataD();
            that.a = this.a;
            that.b = this.b;
            that.c = this.c;
            that.dres = this.dres;
            return that;
        }
    }

    private static class BddCacheDataI
    extends BddCacheData {
        int res;

        private BddCacheDataI() {
        }

        BddCacheData copy() {
            BddCacheDataI that = new BddCacheDataI();
            that.a = this.a;
            that.b = this.b;
            that.c = this.c;
            that.res = this.res;
            return that;
        }
    }

    private static abstract class BddCacheData {
        int a;
        int b;
        int c;

        private BddCacheData() {
        }

        abstract BddCacheData copy();
    }

    private class bddWithFinalizer
    extends bdd {
        bddWithFinalizer(int id) {
            super(id);
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }
    }

    private class bdd
    extends BDD {
        int _index;

        bdd(int index) {
            this._index = index;
            JFactory.this.bdd_addref(this._index);
        }

        public BDDFactory getFactory() {
            return JFactory.this;
        }

        public boolean isZero() {
            return this._index == 0;
        }

        public boolean isOne() {
            return this._index == 1;
        }

        public int var() {
            return JFactory.this.bdd_var(this._index);
        }

        public BDD high() {
            return JFactory.this.makeBDD(JFactory.this.HIGH(this._index));
        }

        public BDD low() {
            return JFactory.this.makeBDD(JFactory.this.LOW(this._index));
        }

        public BDD id() {
            return JFactory.this.makeBDD(this._index);
        }

        public BDD not() {
            return JFactory.this.makeBDD(JFactory.this.bdd_not(this._index));
        }

        public BDD ite(BDD thenBDD, BDD elseBDD) {
            int x = this._index;
            int y = ((bdd)thenBDD)._index;
            int z = ((bdd)elseBDD)._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_ite(x, y, z));
        }

        public BDD relprod(BDD that, BDD var) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int z = ((bdd)var)._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_relprod(x, y, z));
        }

        public BDD compose(BDD g, int var) {
            int x = this._index;
            int y = ((bdd)g)._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_compose(x, y, var));
        }

        public BDD veccompose(BDDPairing pair) {
            int x = this._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_veccompose(x, (bddPair)pair));
        }

        public BDD constrain(BDD that) {
            int x = this._index;
            int y = ((bdd)that)._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_constrain(x, y));
        }

        public BDD exist(BDD var) {
            int x = this._index;
            int y = ((bdd)var)._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_exist(x, y));
        }

        public BDD forAll(BDD var) {
            int x = this._index;
            int y = ((bdd)var)._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_forall(x, y));
        }

        public BDD unique(BDD var) {
            int x = this._index;
            int y = ((bdd)var)._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_unique(x, y));
        }

        public BDD restrict(BDD var) {
            int x = this._index;
            int y = ((bdd)var)._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_restrict(x, y));
        }

        public BDD restrictWith(BDD that) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int a = JFactory.this.bdd_restrict(x, y);
            JFactory.this.bdd_delref(x);
            if (this != that) {
                that.free();
            }
            JFactory.this.bdd_addref(a);
            this._index = a;
            return this;
        }

        public BDD simplify(BDD d) {
            int x = this._index;
            int y = ((bdd)d)._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_simplify(x, y));
        }

        public BDD support() {
            int x = this._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_support(x));
        }

        public BDD apply(BDD that, BDDFactory.BDDOp opr) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int z = opr.id;
            return JFactory.this.makeBDD(JFactory.this.bdd_apply(x, y, z));
        }

        public BDD applyWith(BDD that, BDDFactory.BDDOp opr) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int z = opr.id;
            int a = JFactory.this.bdd_apply(x, y, z);
            JFactory.this.bdd_delref(x);
            if (this != that) {
                that.free();
            }
            JFactory.this.bdd_addref(a);
            this._index = a;
            return this;
        }

        public BDD applyAll(BDD that, BDDFactory.BDDOp opr, BDD var) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int z = opr.id;
            int a = ((bdd)var)._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_appall(x, y, z, a));
        }

        public BDD applyEx(BDD that, BDDFactory.BDDOp opr, BDD var) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int z = opr.id;
            int a = ((bdd)var)._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_appex(x, y, z, a));
        }

        public BDD applyUni(BDD that, BDDFactory.BDDOp opr, BDD var) {
            int x = this._index;
            int y = ((bdd)that)._index;
            int z = opr.id;
            int a = ((bdd)var)._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_appuni(x, y, z, a));
        }

        public BDD satOne() {
            int x = this._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_satone(x));
        }

        public BDD fullSatOne() {
            int x = this._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_fullsatone(x));
        }

        public BDD satOne(BDD var, boolean pol) {
            int x = this._index;
            int y = ((bdd)var)._index;
            int z = pol ? 1 : 0;
            return JFactory.this.makeBDD(JFactory.this.bdd_satoneset(x, y, z));
        }

        public List allsat() {
            int x = this._index;
            LinkedList result = new LinkedList();
            JFactory.this.bdd_allsat(x, result);
            return result;
        }

        public BDD replace(BDDPairing pair) {
            int x = this._index;
            return JFactory.this.makeBDD(JFactory.this.bdd_replace(x, (bddPair)pair));
        }

        public BDD replaceWith(BDDPairing pair) {
            int x = this._index;
            int y = JFactory.this.bdd_replace(x, (bddPair)pair);
            JFactory.this.bdd_delref(x);
            JFactory.this.bdd_addref(y);
            this._index = y;
            return this;
        }

        public int nodeCount() {
            return JFactory.this.bdd_nodecount(this._index);
        }

        public double pathCount() {
            return JFactory.this.bdd_pathcount(this._index);
        }

        public double satCount() {
            return JFactory.this.bdd_satcount(this._index);
        }

        public int[] varProfile() {
            int x = this._index;
            return JFactory.this.bdd_varprofile(x);
        }

        public boolean equals(BDD that) {
            boolean b = this._index == ((bdd)that)._index;
            return b;
        }

        public int hashCode() {
            return this._index;
        }

        public void free() {
            JFactory.this.bdd_delref(this._index);
            this._index = -1;
        }
    }
}

