/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.bcel.PreorderDetector;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Method;

public class DontUseEnum
extends PreorderDetector {
    BugReporter bugReporter;

    public DontUseEnum(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Method obj) {
        if (this.isReservedName(obj.getName())) {
            BugInstance bug = new BugInstance(this, "NM_FUTURE_KEYWORD_USED_AS_MEMBER_IDENTIFIER", this.isVisible((FieldOrMethod)obj) ? 1 : 2).addClassAndMethod(this);
            this.bugReporter.reportBug(bug);
        }
    }

    private boolean isVisible(FieldOrMethod obj) {
        return (obj.getAccessFlags() & 1) != 0 || (obj.getAccessFlags() & 4) != 0;
    }

    private boolean isReservedName(String name) {
        return name.equals("enum") || name.equals("assert");
    }

    @Override
    public void visit(Field obj) {
        if (this.isReservedName(obj.getName())) {
            BugInstance bug = new BugInstance(this, "NM_FUTURE_KEYWORD_USED_AS_MEMBER_IDENTIFIER", this.isVisible((FieldOrMethod)obj) ? 1 : 2).addClass(this).addField(this);
            this.bugReporter.reportBug(bug);
        }
    }

    @Override
    public void visit(LocalVariable obj) {
        if (this.isReservedName(obj.getName())) {
            LocalVariableAnnotation var = new LocalVariableAnnotation(obj.getName(), obj.getIndex(), obj.getStartPC());
            SourceLineAnnotation source = SourceLineAnnotation.fromVisitedInstruction(this.getClassContext(), this, obj.getStartPC());
            BugInstance bug = new BugInstance(this, "NM_FUTURE_KEYWORD_USED_AS_IDENTIFIER", 2).addClassAndMethod(this).add(var).add(source);
            this.bugReporter.reportBug(bug);
        }
    }
}

