/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.util.List;

public class InstantiateStaticClass
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;

    public InstantiateStaticClass(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 183 && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().equals("()V")) {
            XClass xClass = this.getXClassOperand();
            if (xClass == null) {
                return;
            }
            String clsName = this.getClassConstantOperand();
            if (clsName.equals("java/lang/Object")) {
                return;
            }
            if (this.getMethodName().equals("<init>") && this.getPC() == 1) {
                return;
            }
            if (this.getMethodName().equals("<clinit>") && this.getClassName().equals(clsName)) {
                return;
            }
            if (this.isStaticOnlyClass(xClass)) {
                this.bugReporter.reportBug(new BugInstance(this, "ISC_INSTANTIATE_STATIC_CLASS", 3).addClassAndMethod(this).addSourceLine(this));
            }
        }
    }

    private boolean isStaticOnlyClass(XClass xClass) {
        if (xClass.getInterfaceDescriptorList().length > 0) {
            return false;
        }
        ClassDescriptor superclassDescriptor = xClass.getSuperclassDescriptor();
        if (superclassDescriptor == null) {
            return false;
        }
        String superClassName = superclassDescriptor.getClassName();
        if (!superClassName.equals("java/lang/Object")) {
            return false;
        }
        int staticCount = 0;
        List<? extends XMethod> methods = xClass.getXMethods();
        for (XMethod xMethod : methods) {
            if (xMethod.isStatic() && !xMethod.isSynthetic()) {
                ++staticCount;
                continue;
            }
            if (xMethod.getName().equals("<init>") && xMethod.getSignature().equals("()V")) continue;
            return false;
        }
        List<? extends XField> fields = xClass.getXFields();
        for (XField xField : fields) {
            if (xField.isStatic()) {
                ++staticCount;
                continue;
            }
            if (xField.isPrivate()) continue;
            return false;
        }
        return staticCount != 0;
    }
}

