/*
 *  CPAchecker is a tool for configurable software verification.
 *  This file is part of CPAchecker.
 *
 *  Copyright (C) 2007-2014  Dirk Beyer
 *  All rights reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *
 *  CPAchecker web page:
 *    http://cpachecker.sosy-lab.org
 */
package org.sosy_lab.cpachecker.cfa.types.c;

public enum CBasicType {

  UNSPECIFIED(""),
  BOOL("_Bool"),
  CHAR("char"),
  INT("int"),
  FLOAT("float"),
  DOUBLE("double"),
  ;

  private final String code;

  private CBasicType(String pCode) {
    code = pCode;
  }

  /**
   * Returns true if a type is a floating type as defined by
   * the C standard §6.2.5.
   */
  public boolean isFloatingPointType() {
    return this == FLOAT
        || this == DOUBLE;
  }

  /**
   * Returns true if a type is an integer type as defined by
   * the C standard §6.2.5.
   */
  public boolean isIntegerType() {
    return this == BOOL
        || this == CHAR
        || this == INT
        || this == UNSPECIFIED;
  }

  public String toASTString() {
    return code;
  }
}
