/*
 *  CPAchecker is a tool for configurable software verification.
 *  This file is part of CPAchecker.
 *
 *  Copyright (C) 2007-2014  Dirk Beyer
 *  All rights reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *
 *  CPAchecker web page:
 *    http://cpachecker.sosy-lab.org
 */
package org.sosy_lab.cpachecker.cfa.types.java;

import java.util.ArrayList;
import java.util.List;

/**
 * Description of a constructor method of a Java class.
 */
public class JConstructorType extends JMethodType implements JType {

  private static final JConstructorType UNRESOLVABLE_TYPE = new JConstructorType(JClassType.createUnresolvableType(), new ArrayList<JType>(), false);

  /**
   * Creates a new <code>JConstructorType</code> object with the given attributes.
   *
   * @param pReturnType a {@link JClassType} describing the class the described constructor creates
   * @param pParameters the parameters the constructor takes
   * @param pTakesVarArgs if <code>true</code>, the constructor takes a variable amount of
   *        arguments, otherwise not
   */
  public JConstructorType(JClassType pReturnType, List<JType> pParameters, boolean pTakesVarArgs) {
    super(pReturnType, pParameters, pTakesVarArgs);
  }

  @Override
  public JClassType getReturnType() {
    return (JClassType) super.getReturnType();
  }

  /**
   * Returns a <code>JContructorType</code> instance describing an unresolvable constructor.
   *
   * @return a <code>JContructorType</code> instance describing an unresolvable constructor
   */
  public static JConstructorType createUnresolvableConstructorType() {
    return UNRESOLVABLE_TYPE;
  }

  @Override
  public int hashCode() {
      final int prime = 31;
      int result = 7;
      result = prime * result + super.hashCode();
      return result;
  }

  @Override
  public boolean equals(Object obj) {
      return super.equals(obj);
  }
}
