#!/usr/bin/python

import sys

sys.dont_write_bytecode = True # prevent creation of .pyc files

import signal
from benchmark.cgroups import *

CPUSET = 'cpuset'
MEMORY = 'memory'

def isCGroupAvailable():

    _cgroups = {} 
    initCgroup(_cgroups, MEMORY)
    if not _cgroups[MEMORY]:
        return False

    initCgroup(_cgroups, CPUSET)
    cgroupCpuset = _cgroups[CPUSET]
    if not cgroupCpuset:
        return False

    return True

def main(argv=None):

    print(str(isCGroupAvailable()))

if __name__ == "__main__":

    main()
